//
//  ChangeServerAddressViewController.m
//  HWMSDKDemo
//
//  Created by guoyongliang/gwx917154 on 2020/9/16.
//  Copyright © 2020 HuaWei. All rights reserved.
//

#import "ChangeServerAddressViewController.h"
#import "SDKEnvConfig.h"
#import "UIUtil.h"
@interface ChangeServerAddressViewController ()
@property (weak, nonatomic) IBOutlet UITextField *serverAddressTextField;
@property (weak, nonatomic) IBOutlet UITextField *serverPortTextField;
@property (weak, nonatomic) IBOutlet UISwitch *caVerifySwitch;

@end

@implementation ChangeServerAddressViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.caVerifySwitch.on = [SDKEnvConfig sharedInstance].caVerify;
}

- (IBAction)saveServerAddress:(id)sender {
    NSString * serverAddress = self.serverAddressTextField.text;
    NSInteger serverPort = [self.serverPortTextField.text integerValue];
    BOOL isVerify = self.caVerifySwitch.isOn;
    [SDKEnvConfig sharedInstance].serverAddress = serverAddress;
    [SDKEnvConfig sharedInstance].serverPort = serverPort;
    [SDKEnvConfig sharedInstance].caVerify = isVerify;
    if ([HWMSdk hasInit]) {
        [HWMSdk setServerConfigWithUrl:serverAddress port:serverPort];
        HWMCaVerifyParam *param = [[HWMCaVerifyParam alloc] init];
        param.isVerify = isVerify;
        [HWMSdk setCaVerifyParam:param];
    }
    [UIUtil showMessage:@"保存成功"];
}

- (IBAction)resetServerAddress:(id)sender {
    [SDKEnvConfig sharedInstance].serverAddress = @"";
    [SDKEnvConfig sharedInstance].serverPort = 0;
    [SDKEnvConfig sharedInstance].caVerify = NO;
    [UIUtil showMessage:@"重置成功"];
}

@end
