//
//  CustomInMeetingUIManager.h
//  HWMSDKDemo
//
//  Created by y00450113 on 2020/7/14.
//  Copyright © 2020 HuaWei. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "AudioCallMenuHandlerImpl.h"
#import "AudioConfMenuHandlerImpl.h"
#import "VideoCallMenuHandlerImpl.h"
#import "VideoConfMenuHandlerImpl.h"
#import "ParticipantListMenuHandlerImpl.h"
#import "ConfTitleBarMenuHandlerImpl.h"
#import <HWMUISDK/HWMUISDK.h>
#import "StatusBarMenuHandlerImpl.h"

typedef NS_ENUM (NSInteger, CustomUIType) {
    CustomUITypeConfTitleInfo, // 会中title点击的会议信息页面定制
    CustomUITypeAudioCallToolBar, //音频呼叫底部会控菜单定制
    CustomUITypeAudioConfToolBar, //音频会议底部会控菜单定制
    CustomUITypeVideoCallToolBar, //视频呼叫底部会控菜单定制
    CustomUITypeVideoConfToolBar, //视频会议底部会控菜单定制
    CustomUITypeAudioConfMore, // 音频会议更多菜单定制
    CustomUITypeVideoCallMore, // 视频呼叫更多菜单定制
    CustomUITypeVideoConfMore, // 视频会议更多菜单定制
    CustomUITypeAudioConfSetting, // 音频会议设置页面
    CustomUITypeVideoCallSetting, // 视频呼叫设置页面
    CustomUITypeVideoConfSetting, // 视频会议设置页面
    CustomUITypeMemberListTitleBar, // 与会者列表顶部菜单定制
    CustomUITypeMemberListToolBar,// 与会者列表底部菜单定制
    CustomUITypeMemberListMore, // 与会者列表底部菜单点击弹出更多定制
    CustomUITypeMemberListActionSheet, // 与会者列表点击与会者弹出的actionSheet 定制
    CustomUITypeConfStatusBar, // 会中状态栏定制
    CustomUITypeWaitingListToolBar, // 等候中列表底部菜单定制
    CustomUITypeOfflineListToolBar // 未入会列表底部菜单定制
};

NS_ASSUME_NONNULL_BEGIN

@interface CustomInMeetingUIManager : NSObject <HWMContactUIHandler, HWMSocialShareHandler, HWMInMeetingCellDelegate>

@property(nonatomic, assign)BOOL customMenu; // 是否自定义菜单

// 默认实现
@property(nonatomic, strong)AudioCallMenuHandlerImpl *defaultAudioCallImpl;
@property(nonatomic, strong)AudioConfMenuHandlerImpl *defaultAudioConfImpl;
@property(nonatomic, strong)VideoCallMenuHandlerImpl *defaultVideoCallImpl;
@property(nonatomic, strong)VideoConfMenuHandlerImpl *defaultVideoConfImpl;
@property(nonatomic, strong)ParticipantListMenuHandlerImpl *defaultMemberListImpl;
@property(nonatomic, strong)ConfTitleBarMenuHandlerImpl *defaultTitleBarImpl;
@property(nonatomic, strong) StatusBarMenuHandlerImpl *defaultStatusBarImpl;

+ (instancetype)sharedInstance;

- (NSArray *)getCustomMenuItems:(CustomUIType)type;

- (void)updateCustomMenuItems:(CustomUIType)type items:(NSArray *)items;

- (HWMConfCtrlType )generateCtrlType;
@end

NS_ASSUME_NONNULL_END
