//
//  CustomInMeetingUIManager.m
//  HWMSDKDemo
//
//  Created by y00450113 on 2020/7/14.
//  Copyright © 2020 HuaWei. All rights reserved.
//

#import "CustomInMeetingUIManager.h"
#import <HWMUISDK/HWMUISDK.h>
#import "ContactSelectViewController.h"
#import "ShareView.h"
#import "UIUtil.h"

@interface CustomInMeetingUIManager ()
//自定义的菜单内容， key: @(CustomUIType), value: NSArray<HWMConfMenuItem *>
@property (nonatomic, strong) NSMutableDictionary <NSNumber *, NSArray *> *customItems;
@property (nonatomic, assign) NSInteger defaultConfCtrlValue;
@end
@implementation CustomInMeetingUIManager

+ (instancetype)sharedInstance
{
    static id instance = nil;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        instance = [[self alloc] init];
    });
    return instance;
}

- (instancetype)init {
    if (self = [super init]) {
        self.defaultAudioCallImpl = [[AudioCallMenuHandlerImpl alloc] init];
        self.defaultAudioConfImpl = [[AudioConfMenuHandlerImpl alloc] init];
        self.defaultVideoCallImpl = [[VideoCallMenuHandlerImpl alloc] init];
        self.defaultVideoConfImpl = [[VideoConfMenuHandlerImpl alloc] init];
        self.defaultMemberListImpl = [[ParticipantListMenuHandlerImpl alloc] init];
        self.defaultTitleBarImpl = [[ConfTitleBarMenuHandlerImpl alloc] init];
        self.defaultStatusBarImpl = [[StatusBarMenuHandlerImpl alloc] init];
        self.customItems = [[NSMutableDictionary alloc] init];
        self.defaultConfCtrlValue = ConfCtrlSetting + 1024;
    }
    return self;
}

#pragma mark - HWMSocialShareHandler
// 此方法与getShareLogoImages getBrandName不能同时使用。同时使用getShareLogoImages getBrandName 无效果
- (void)shareConf:(HWMConfDetail *)confInfo isAnonymous:(BOOL)isAnonymous inCtrl:(UIViewController *)controller {
    NSLog(@"enter share conf");
    ShareView *shareView = [[ShareView alloc] init];
    [shareView showShareView:^(NSInteger index) {
        [UIUtil showMessage:[NSString stringWithFormat:@"点击了第%zd个按钮", index + 1]];
    }];
}

#pragma mark - HWMContactUIHandler
- (void)openContactSelectPage:(NSArray<HWMConfContactModel *> *)param
                        scene:(HWMSelectedContactScene)scene
               completeHander:(void (^)(NSArray<HWMContactSelectedModel *> *result, NSError *error))handler {
    NSLog(@"enter open contact select page");
    ContactSelectViewController *contactSelectVc = [[ContactSelectViewController alloc] initWithResultHandler:handler];
    UINavigationController *currentNav =  [UIUtil findCurrentNavigationController];
    if (currentNav) {
        [currentNav pushViewController:contactSelectVc animated:YES];
    } else {
        NSLog(@"ERROR:");
    }
}

- (NSArray *)getCustomMenuItems:(CustomUIType)type {
    NSArray *customItems = [self.customItems objectForKey:@(type)];
    if (customItems) {
        return customItems;
    } else {
        return [self getDefaultItemsWithType:type];
    }
}

- (NSArray *)getDefaultItemsWithType:(CustomUIType)type {
    switch (type) {
        case CustomUITypeConfTitleInfo:
            return [self.defaultTitleBarImpl buildTitleBarPopViewItems];
            break;
        case CustomUITypeAudioCallToolBar:
            return [self.defaultAudioCallImpl buildToolBarMenuItems];
            break;
        case CustomUITypeAudioConfToolBar:
            return [self.defaultAudioConfImpl buildToolBarMenuItems];
            break;
        case CustomUITypeVideoCallToolBar:
            return [self.defaultVideoCallImpl buildToolBarMenuItems];
            break;
        case CustomUITypeVideoConfToolBar:
            return [self.defaultVideoConfImpl buildToolBarMenuItems];
            break;
        case CustomUITypeAudioConfMore:
            return [self.defaultAudioConfImpl buildToolBarMoreMenuItems];
            break;
        case CustomUITypeVideoCallMore:
            return [self.defaultVideoCallImpl buildToolBarMoreMenuItems];
            break;
        case CustomUITypeVideoConfMore:
            return [self.defaultVideoConfImpl buildToolBarMoreMenuItems];
            break;
        case CustomUITypeAudioConfSetting:
            return [self.defaultAudioConfImpl buildSettingItems];
            break;
        case CustomUITypeVideoCallSetting:
            return [self.defaultVideoCallImpl buildSettingItems];
            break;
        case CustomUITypeVideoConfSetting:
            return [self.defaultVideoConfImpl buildSettingItems];
            break;
        case CustomUITypeMemberListTitleBar:
            return [self.defaultMemberListImpl buildParticipantTitleBarMenuItems];
            break;
        case CustomUITypeMemberListToolBar:
            return [self.defaultMemberListImpl buildParticipantToolBarMenuItems];
            break;
        case CustomUITypeMemberListMore:
            return [self.defaultMemberListImpl buildParticipantToolBarMoreMenuItems];
            break;
        case CustomUITypeMemberListActionSheet:
            return [self.defaultMemberListImpl buildParticipantActionSheetItems];
            break;
        case CustomUITypeConfStatusBar:
            return [self.defaultStatusBarImpl buildRecordMenuItems];
        case CustomUITypeWaitingListToolBar:
            return [self.defaultMemberListImpl buildWaitingToolBarMenuItems];
        case CustomUITypeOfflineListToolBar:
            return [self.defaultMemberListImpl buildOfflineToolBarMenuItems];
        default:
            return @[];
            break;
    }
}

- (void)updateCustomMenuItems:(CustomUIType)type items:(NSArray *)items {
    [self.customItems setObject:items forKey:@(type)];
}

- (HWMConfCtrlType)generateCtrlType {
    self.defaultConfCtrlValue++;
    return self.defaultConfCtrlValue;
}


/// cell 对象代理
/// @param cellType cellType
- (UITableViewCell *)cellForRowWithCellType:(HWMConfInfoCellType)cellType inTableView:(nonnull UITableView *)tableView indexPath:(nonnull NSIndexPath *)indexPath{
    NSString *reuseIdentifier = [NSString stringWithFormat:@"CustomCell_%ld", cellType];
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:reuseIdentifier];
    if (cell == nil) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:reuseIdentifier];
    }
    cell.contentView.backgroundColor = [UIColor clearColor];
    cell.backgroundColor = [UIColor clearColor];
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    
    UIImageView * safeImg = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"custom_conf_setting"]];
    [cell.contentView addSubview:safeImg];
    
    UILabel * safeLabel = [[UILabel alloc] init];
    safeLabel.font = [UIFont systemFontOfSize:14];
    safeLabel.textColor = [UIColor whiteColor];
    safeLabel.text = reuseIdentifier;
    [cell.contentView addSubview:safeLabel];
    
    UIView *lineView = [[UIView alloc] init];
    [lineView setBackgroundColor:HexColor(0x666666)];
    [cell.contentView addSubview:lineView];
    
    [safeImg mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(16);
        make.size.mas_equalTo(CGSizeMake(16, 16));
        make.centerY.mas_equalTo(safeLabel);
    }];
    
    [safeLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(safeImg.mas_right).offset(10);
        make.top.mas_equalTo(10);
        make.height.mas_equalTo(34);
        make.bottom.mas_equalTo(-10);
    }];
    
    [lineView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.bottom.equalTo(cell.contentView);
        make.height.mas_equalTo(0.5);
    }];
    
    return cell;
}


/// cell点击事件代理
/// @param cellType cellType
- (void)cellSelectedWithCellType:(HWMConfInfoCellType)cellType{
    [UIUtil showMessage:[NSString stringWithFormat:@"点击了菜单：%lu", (unsigned long)cellType]];
}


@end
