//
//  SetDeployInfoViewController.m
//  HWMSDKDemo
//
//  Created by lining on 2025/2/18.
//  Copyright © 2025 HuaWei. All rights reserved.
//

#import "SetDeployInfoViewController.h"

@interface SetDeployInfoViewController ()

@property (weak, nonatomic) IBOutlet UITextField *serverAddrTF;
@property (weak, nonatomic) IBOutlet UITextField *serverPortTF;

@property (weak, nonatomic) IBOutlet UIButton *deployTypeBtn;
@property (nonatomic, assign) HWMDeployType deployType;

@end

@implementation SetDeployInfoViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.deployType = HWMSDKCloudMode;
}

- (IBAction)selectDeployType:(UIButton *)sender {
    UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"部署模式" message:nil preferredStyle:UIAlertControllerStyleActionSheet];
    if (Is_Ipad) {
        alertController.popoverPresentationController.sourceView = self.view;
        alertController.popoverPresentationController.sourceRect = sender.frame;
    }
    UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleCancel handler:nil];
    UIAlertAction *cloudModeAction = [UIAlertAction actionWithTitle:@"上云模式" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        self.deployType = HWMSDKCloudMode;
        [self.deployTypeBtn setTitle:@"上云模式" forState:UIControlStateNormal];
    }];
    UIAlertAction *sinkModeAction = [UIAlertAction actionWithTitle:@"下沉模式" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        self.deployType = HWMSDKSinkMode;
        [self.deployTypeBtn setTitle:@"下沉模式" forState:UIControlStateNormal];
    }];
    [alertController addAction:cancelAction];
    [alertController addAction:cloudModeAction];
    [alertController addAction:sinkModeAction];
    [self presentViewController:alertController animated:YES completion:nil];
}

- (IBAction)reset {
    self.deployType = HWMSDKCloudMode;
    [self.deployTypeBtn setTitle:@"上云模式" forState:UIControlStateNormal];
    self.serverAddrTF.text = @"";
    self.serverPortTF.text = @"";
}

- (IBAction)save {
    HWMSDKServerInfoModel *serverInfo = [[HWMSDKServerInfoModel alloc] init];
    serverInfo.serverAddr = self.serverAddrTF.text;
    serverInfo.serverPort = self.serverPortTF.text.integerValue;
    HWMSDKDeployInfoModel *model = [[HWMSDKDeployInfoModel alloc] init];
    model.deployType = self.deployType;
    model.serverInfo = serverInfo;
    [[HWMSdk getPrivateApi] setDeployInfo:model];
}


@end
