//
//  SDKEnvConfig.h
//  HWMSDKDemo
//
//  Created by y00450113 on 2020/7/4.
//  Copyright © 2020 HuaWei. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface SDKEnvConfig : NSObject
@property(nonatomic, assign) BOOL hideOfflineMembers;
@property(nonatomic, assign) BOOL usePushLaunch;
@property(nonatomic, assign)BOOL customSocialShare;         /**< 是否自定义分享 */
@property(nonatomic, assign)BOOL customContact;             /**< 是否自定义联系人 */
@property(nonatomic, assign) BOOL customConfSetting;        /**< 是否自定义会议设置 */
@property(nonatomic, assign) BOOL isChinaSite;              /**< 是否是中国站点 */
@property(nonatomic, assign) BOOL isHideExternalLabel;      /**< 是否隐藏外部标签 */
@property (nonatomic, assign) BOOL contactHeadPortrait;     /**< 联系人头像 */
@property(nonatomic, strong) NSString *serverAddress;       /**< 服务器地址，默认为华为云地址 */
@property(nonatomic, assign) NSUInteger serverPort;         /**< 服务器端口号 */
@property (nonatomic, copy) NSString *appId;                /**< AppId登录的id */
@property (nonatomic, copy) NSString *domain;               /**< sso登录域名 */
@property (nonatomic, copy) NSString *code;                 /**< sso登录code */
@property (nonatomic, copy) NSString *logPath;              /**< 自定义日志路径 */
/// 网络接入方式
@property (nonatomic, assign) NSInteger accessType;
/// 屏幕共享权限
@property (nonatomic, assign) BOOL enableScreenSharePermission;
/// 是否校验证书
@property (nonatomic, assign) BOOL caVerify;
/// 是否拦截虚拟背景自定义图片
@property (nonatomic, assign) BOOL customVirtualBackground;
/// 自定义文案
@property (nonatomic, assign) BOOL customText;
/// 自定义图片
@property (nonatomic, assign) BOOL customImage;
/// 自定义呼叫其他号码
@property (nonatomic, assign) BOOL customCallOtherNumber;
/// 是否拦截共享
@property (nonatomic, assign) BOOL interceptShare;
/// 是否支持分组会议
@property (nonatomic, assign) BOOL supportBreakoutConf;
/// 是否显示录制安全提示窗
@property (nonatomic, assign) BOOL isShowRecordSafeAlert;
/// 是否匿名入会时保存会中名字
@property (nonatomic, assign) BOOL isSaveNickNameWhenAnonymousJoin;
/// 是否支持断开音频入会
@property (nonatomic, assign) BOOL supportDisconnectAudio;
/// 是否支持虚拟背景
@property (nonatomic, assign) BOOL supportVirtualBackground;
/// 隐藏会中邀请提示
@property (nonatomic, assign) BOOL hideInviteResultToast;
/// 隐藏未入会与会者列表
@property (nonatomic, assign) BOOL hideOfflineParticipantList;
/// 是否自定义查询联系人信息
@property(nonatomic, assign)BOOL customQueryContact;
/// 隐藏虚拟背景隐私风险提示
@property(nonatomic, assign) BOOL isHiddenVBRiskTip;
/// 隐藏隐藏离会提示
@property(nonatomic, assign) BOOL hideConfEndTips;
+ (instancetype)sharedInstance;

@end

NS_ASSUME_NONNULL_END
