//
//  SchemeLinkViewController.m
//  HWMSDKDemo
//
//  Created by WeLink on 2020/8/7.
//  Copyright © 2020 HuaWei. All rights reserved.
//

#import "SchemeLinkViewController.h"
#import <AFNetworking/AFNetworking.h>

@interface SchemeLinkViewController ()
@property (nonatomic, strong) UITextField *nonceTextField;
@property (nonatomic, strong) UITextField *confIdTextField;
@property (nonatomic, strong) UITextField *confPWTextField;
@property (nonatomic, strong) UITextField *nameTextField;
@property (nonatomic, strong) UISwitch *cameraSwitch;
@property (nonatomic, strong) UISwitch *micSwitch;
@property (nonatomic, strong) UIButton *subBtn;
@property (nonatomic, copy) NSString * schemeLink;
@end

@implementation SchemeLinkViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"链接拉起入会";
    
}
- (void)setupViews {
    [super setupViews];
    if ([self isNeedNonce]) {
        self.nonceTextField = [[UITextField alloc] init];
        [self.view addSubview:self.nonceTextField];
        self.nonceTextField.userInteractionEnabled = NO;
        self.nonceTextField.text = self.nonce;
        [self.nonceTextField mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.mas_equalTo(120);
            make.height.mas_equalTo(30);
            make.left.mas_equalTo(50);
            make.right.mas_equalTo(-50);
        }];
        [UIView addBottomLineWithView:self.nonceTextField parentView:self.view];
    }
    self.confIdTextField = [[UITextField alloc] init];
    [self.view addSubview:self.confIdTextField];
    self.confIdTextField.placeholder = @"会议id";
    [self.confIdTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        if ([self isNeedNonce]) {
            make.top.mas_equalTo(self.nonceTextField.mas_bottom).mas_offset(20);
        } else {
            make.top.mas_equalTo(120);
        }
        make.height.mas_equalTo(30);
        make.left.mas_equalTo(50);
        make.right.mas_equalTo(-50);
    }];
    [UIView addBottomLineWithView:self.confIdTextField parentView:self.view];
    
    self.confPWTextField = [[UITextField alloc] init];
    [self.view addSubview:self.confPWTextField];
    self.confPWTextField.placeholder = @"会议密码（无密码时可以不填）";
    [self.confPWTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.confIdTextField.mas_bottom).mas_offset(20);
        make.height.mas_equalTo(30);
        make.left.mas_equalTo(50);
        make.right.mas_equalTo(-50);
    }];
    [UIView addBottomLineWithView:self.confPWTextField parentView:self.view];
    
    self.nameTextField = [[UITextField alloc] init];
    [self.view addSubview:self.nameTextField];
    self.nameTextField.placeholder = @"会议中的名称";
    [self.nameTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.confPWTextField.mas_bottom).mas_offset(20);
        make.height.mas_equalTo(30);
        make.left.mas_equalTo(50);
        make.right.mas_equalTo(-50);
    }];
    [UIView addBottomLineWithView:self.nameTextField parentView:self.view];
    
    
    UILabel * cameraLabel = [self newLabelWithTitle:@"打开摄像头"];
    [self.view addSubview:cameraLabel];
    [cameraLabel mas_makeConstraints:^(MASConstraintMaker *make) {
      make.top.mas_equalTo(self.nameTextField.mas_bottom).mas_offset(20);
      make.left.mas_equalTo(self.confIdTextField);
    }];

    self.cameraSwitch = [[UISwitch alloc] init];
    [self.view addSubview:self.cameraSwitch];
    self.cameraSwitch.on = YES;
    [self.cameraSwitch addTarget:self action:@selector(cameraSwitchChanged:) forControlEvents:(UIControlEventValueChanged)];
    [self.cameraSwitch mas_makeConstraints:^(MASConstraintMaker *make) {
      make.centerY.mas_equalTo(cameraLabel);
      make.right.mas_equalTo(-50);
    }];

    UILabel * micLabel = [self newLabelWithTitle:@"打开麦克风"];
    [self.view addSubview:micLabel];
    [micLabel mas_makeConstraints:^(MASConstraintMaker *make) {
      make.top.mas_equalTo(cameraLabel.mas_bottom).mas_offset(20);
      make.left.mas_equalTo(self.confIdTextField);
    }];

    self.micSwitch = [[UISwitch alloc] init];
    [self.view addSubview:self.micSwitch];
    self.micSwitch.on = YES;
    [self.micSwitch addTarget:self action:@selector(micSwitchChanged:) forControlEvents:(UIControlEventValueChanged)];
    [self.micSwitch mas_makeConstraints:^(MASConstraintMaker *make) {
      make.centerY.mas_equalTo(micLabel);
      make.right.mas_equalTo(-50);
    }];
    
    self.subBtn = [UIButton newButtonWithTitle:@"链接拉起会议"];
    [self.view addSubview:self.subBtn];
    [self.subBtn addTarget:self action:@selector(schemeLinkClicked) forControlEvents:UIControlEventTouchUpInside];
    [self.subBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(micLabel.mas_bottom).mas_offset(50);
        make.left.right.mas_equalTo(self.confIdTextField);
        make.height.mas_equalTo(50);
    }];
    
    if ([self isNeedNonce]) {
        UIButton * copyBtn = [UIButton newButtonWithTitle:@"复制链接拉起会议链接"];
        [self.view addSubview:copyBtn];
        [copyBtn addTarget:self action:@selector(copySchemeLinkClicked) forControlEvents:UIControlEventTouchUpInside];
        [copyBtn mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.mas_equalTo(self.subBtn.mas_bottom).mas_offset(20);
            make.left.right.mas_equalTo(self.confIdTextField);
            make.height.mas_equalTo(50);
        }];
    }
}

- (UILabel *)newLabelWithTitle:(NSString *)title {
    UILabel * label = [[UILabel alloc] init];
    label.text = title;
    label.font = [UIFont systemFontOfSize:16];
    label.textColor = HexColor(0x333333);
    return label;
}

#pragma make -clickEvent
- (void)cameraSwitchChanged:(UISwitch *)swt{
    
}
- (void)micSwitchChanged:(UISwitch *)swt{
    
}
- (void)schemeLinkClicked {
    if (![self generalSchemeLink]) {
        return;
    }
    
    NSURL *schemUrl = [[NSURL alloc] initWithString:[self.schemeLink stringByAddingPercentEncodingWithAllowedCharacters:[NSCharacterSet URLQueryAllowedCharacterSet]]];
    [[UIApplication sharedApplication] openURL:schemUrl];
}

- (void)copySchemeLinkClicked {
    if (![self generalSchemeLink]) {
        return;
    }
    
    UIPasteboard *pab = [UIPasteboard generalPasteboard];
    pab.string = (self.schemeLink.length > 0) ? self.schemeLink : @"";
    [UIUtil showMessage:pab == nil ? @"复制失败" : @"已复制"];
}

- (BOOL)generalSchemeLink {
    if (self.confIdTextField.text.length <= 0) {
        [UIUtil showMessage:@"请填写会议id"];
        return NO;
    }
    
    if (self.nameTextField.text.length <= 0) {
        [UIUtil showMessage:@"请填写会议中显示的名字"];
        return NO;
    }
    NSString *openMic = @"false";
    NSString *openCamera = @"false";
    if (self.micSwitch.isOn) {
        openMic = @"true";
    }
    if (self.cameraSwitch.isOn) {
        openCamera = @"true";
    }
    NSString *schemeStr = @"";
    NSString * pageStr = [self isNeedNonce] ? @"page=LoginAndJoinConf" : @"page=joinConfByLink";
    NSString * pwdStr = self.confPWTextField.text.length > 0 ? [NSString stringWithFormat:@"&enter_code=%@", self.confPWTextField.text] : @"";
    NSString * nonceStr = [self isNeedNonce] ? [NSString stringWithFormat:@"&nonce=%@", self.nonce] : @"";
    NSString *plistPath = [[NSBundle bundleForClass:[self class]] pathForResource:@"demoEnvConfig" ofType:@"plist"];
    NSMutableDictionary *plistDic = [[NSMutableDictionary alloc] initWithContentsOfFile:plistPath];
    NSString *serverAddr = [plistDic valueForKey:@"uat"];
    schemeStr = [NSString stringWithFormat:@"cloudlink://welinksoftclient/h5page?%@&server_url=%@&port=8443&conf_id=%@%@&name=%@&open_mic=%@&open_camera=%@%@", pageStr,serverAddr, self.confIdTextField.text, pwdStr,self.nameTextField.text,openMic,openCamera, nonceStr];
    self.schemeLink = schemeStr;
    return YES;
}

- (BOOL)isNeedNonce {
    return self.nonce.length > 0;
}
@end
