//
//  HWMUITextField.m
//  HWMSDKDemo
//
//  Created by guoyongliang/g30033086 on 2023/9/5.
//  Copyright © 2023 HuaWei. All rights reserved.
//

#import "HWMUITextField.h"

@interface HWMUITextField() <UITextFieldDelegate>

@end

@implementation HWMUITextField

- (instancetype)init {
    if (self = [super init]) {
        self.delegate = self;
    }
    return self;
}

- (BOOL)textField:(UITextField *)textField shouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string
{
    NSString * checkStr = [textField.text stringByReplacingCharactersInRange:range withString:string];
    if (self.keyboardType == UIKeyboardTypeNumberPad) {
        // 正则表达式
        NSString * regex = @"^[0-9]*";
        BOOL ret = [self validateStr:checkStr withRegex:regex];
        return ret;
    }
    
    return YES;
}

- (BOOL)validateStr:(NSString *)string withRegex:(NSString *)regex
{
    NSPredicate * resultStr = [NSPredicate predicateWithFormat:@"SELF MATCHES %@", regex];
    return [resultStr evaluateWithObject:string];
}

@end
