//
//  ShowError.h
//  HWMSDKDemo
//
//  Created by adminstrator on 2020/4/1.
//  Copyright © 2020 HuaWei. All rights reserved.
//

#import <Foundation/Foundation.h>
typedef enum : NSUInteger {
    HWMUISDKLaunchTypePresent, // 使用present 的方式打开
    HWMUISDKLaunchTypePush, // 使用push的方式打开
} HWMUISDKLaunchType;

NS_ASSUME_NONNULL_BEGIN

@interface UIUtil : NSObject
+(void)showMessage:(NSString *)message vc:(UIViewController *)vc;
+(void)showMessage:(NSString *)message error:(NSError * _Nullable)error;
+(void)showMessage:(NSString *)message;
+(void)showMessageWithError:(NSError * _Nullable)error;
+ (HWMUISDKLaunchType)getLaunchType;

+ (void)setLaunchType:(HWMUISDKLaunchType)type;

+ (UIViewController *)findTopPresentViewController:(UIViewController *)vc;

+ (UIColor *)colorWithHex:(NSUInteger)rgb;

+ (UIViewController *)findCurrentViewController;
+ (UINavigationController *)findCurrentNavigationController;
@end

NS_ASSUME_NONNULL_END
