//
//  UIView+HWM.m
//  HWMSDKDemo
//
//  Created by adminstrator on 2020/4/2.
//  Copyright © 2020 HuaWei. All rights reserved.
//

#import "UIView+HWM.h"

@implementation UIView (HWM)

+ (void)addBottomLineWithView:(UIView *)view parentView:(UIView *)parentView {
    UILabel * lineLabel = [[UILabel alloc] init];
    [parentView addSubview:lineLabel];
    lineLabel.backgroundColor = HexColor(0xf2f2f2);
    [lineLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(view.mas_bottom);
        make.height.mas_equalTo(1);
        make.left.right.mas_equalTo(view);
    }];
}

- (void)addTapAction:(SEL)action target:(id)target {
    UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc] initWithTarget:target action:action];
    tap.numberOfTapsRequired = 1;
    [self addGestureRecognizer:tap];
}

@end
