//
//  SliderCodeView.h
//  HWMSDKDemo
//
//  Created by yaolili/ywx577644 on 2023/9/7.
//  Copyright © 2023 HuaWei. All rights reserved.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

@interface SliderCodeParam : NSObject

@property (nonatomic, assign) CGFloat bgImageRatio; //滑块图片原始宽高比
@property (nonatomic, assign) CGFloat bgImageWidth; //滑块背景图片的宽度
@property (nonatomic, copy) NSString *shadowImage;
@property (nonatomic, copy) NSString *cutImage;
@property (nonatomic, assign) NSInteger pointY;

@end

@protocol SliderCodeViewDelegate <NSObject>

@optional
- (void)checkSliderCodeWithPointX:(NSInteger)pointX slideTime:(NSInteger)timer;
- (void)clickRefreshSlider;
@end

@interface SliderCodeView : UIView

@property (nonatomic, weak) id <SliderCodeViewDelegate>delegate;
- (void)sliderCheckSuccess;
- (void)refreshBtnUserInteraction:(BOOL)enable;
- (void)updateSliderCodeView:(SliderCodeParam *)sliderParam;
- (void)changeViewsStatus:(BOOL)isMoveSuccess;
- (void)changeSliderViewWithSuccessViewHidden:(BOOL)isHidden sliderIsSuccess:(BOOL)isSuccess sliderEnable:(BOOL)isEnabled;
- (void)dissmiss;
- (instancetype)initWithFrame:(CGRect)frame param:(SliderCodeParam *)param;


@end

NS_ASSUME_NONNULL_END
