//
//  ChangeVmrInfoViewController.m
//  HWMSDKDemo
//
//  Created by guoyongliang/gwx917154 on 2020/8/14.
//  Copyright © 2020 HuaWei. All rights reserved.
//

#import "ChangeVmrInfoViewController.h"
#import "CommonUtil.h"

@interface ChangeVmrInfoViewController ()
@property (nonatomic, strong) UISwitch *pwdSwitch;
@property (nonatomic, strong) UITextField *pwdTextField;
@property (nonatomic, strong) UISwitch *allowGuestJoinConfSwitch;
@property (nonatomic, strong) UILabel *joinConfRestrictionLabel;
@property (nonatomic, strong) UISwitch *waitingRoomSwitch;

@property (nonatomic, assign) HWMCallInRestrictionType callInRestriction;
@end

@implementation ChangeVmrInfoViewController

- (void)viewDidLoad {
    [super viewDidLoad];
}

- (void)setupViews {
    [super setupViews];
    UILabel *describeLabel = [self newLabelWithTitle:@"开启密码"];
    [self.view addSubview:describeLabel];
    [describeLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(100);
        make.left.mas_equalTo(50);
    }];

    self.pwdSwitch = [[UISwitch alloc] init];
    [self.view addSubview:self.pwdSwitch];
    [self.pwdSwitch setOn:self.vmrInfo.guestPwd.length > 0];
    [self.pwdSwitch mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.mas_equalTo(describeLabel);
        make.right.mas_equalTo(-50);
    }];
    
    self.pwdTextField = [[UITextField alloc] init];
    [self.view addSubview:self.pwdTextField];
    self.pwdTextField.placeholder = @"vmr密码";
    self.pwdTextField.text = self.vmrInfo.guestPwd;
    [self.pwdTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(50);
        make.height.mas_equalTo(30);
        make.right.mas_equalTo(-50);
        make.top.mas_equalTo(describeLabel.mas_bottom).mas_offset(20);
    }];
    [UIView addBottomLineWithView:self.pwdTextField parentView:self.view];
    
    UILabel *allowGuestJoinConfLable = [self newLabelWithTitle:@"允许来宾在主持人之前入会"];
    [self.view addSubview:allowGuestJoinConfLable];
    [allowGuestJoinConfLable mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.pwdTextField.mas_bottom).mas_offset(20);
        make.left.mas_equalTo(50);
    }];
    
    self.allowGuestJoinConfSwitch = [[UISwitch alloc] init];
    [self.view addSubview:self.allowGuestJoinConfSwitch];
    [self.allowGuestJoinConfSwitch setOn:self.vmrInfo.allowGuestStartConf];
    [self.allowGuestJoinConfSwitch mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.mas_equalTo(allowGuestJoinConfLable);
        make.right.mas_equalTo(-50);
    }];
    
    // 允许入会
    UILabel *joinConfRestrictionLabel = [self newLabelWithTitle:@"允许入会"];
    joinConfRestrictionLabel.userInteractionEnabled = YES;
    [self.view addSubview:joinConfRestrictionLabel];
    [joinConfRestrictionLabel addTapAction:@selector(selectJoinConfRestriction:) target:self];
    [joinConfRestrictionLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(allowGuestJoinConfLable);
        make.right.mas_equalTo(self.allowGuestJoinConfSwitch);
        make.top.mas_equalTo(allowGuestJoinConfLable.mas_bottom).mas_offset(20);
    }];
    
    self.joinConfRestrictionLabel = [self newLabelWithTitle:@""];
    self.joinConfRestrictionLabel.accessibilityIdentifier = HWMManageConfJoinConfRestriction;
    [self.view addSubview:self.joinConfRestrictionLabel];
    self.callInRestriction = self.vmrInfo.confAllowJoinUser;
    [self updateJoinConfRestrictionLabelText];
    [self.joinConfRestrictionLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.mas_equalTo(self.allowGuestJoinConfSwitch);
        make.centerY.mas_equalTo(joinConfRestrictionLabel);
    }];
    
    UILabel *waitingRoomDescLabel = [self newLabelWithTitle:@"开启等候室"];
    [self.view addSubview:waitingRoomDescLabel];
    [waitingRoomDescLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(joinConfRestrictionLabel.mas_bottom).mas_offset(20);
        make.left.mas_equalTo(joinConfRestrictionLabel);
    }];

    self.waitingRoomSwitch = [[UISwitch alloc] init];
    [self.view addSubview:self.waitingRoomSwitch];
    [self.waitingRoomSwitch setOn:self.vmrInfo.isOpenWaitingRoom];
    [self.waitingRoomSwitch mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.mas_equalTo(waitingRoomDescLabel);
        make.right.mas_equalTo(-50);
    }];
    
    UIButton *submitBtn = [UIButton newButtonWithTitle:@"确认"];
    [self.view addSubview:submitBtn];
    [submitBtn addTarget:self action:@selector(changeVmrInfo) forControlEvents:UIControlEventTouchUpInside];
    [submitBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(waitingRoomDescLabel.mas_bottom).mas_offset(50);
        make.left.right.mas_equalTo(self.pwdTextField);
        make.height.mas_equalTo(50);
    }];
    
}

- (void)selectJoinConfRestriction:(UITapGestureRecognizer *)tap {
    UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"允许入会" message:nil preferredStyle:UIAlertControllerStyleActionSheet];
    if (Is_Ipad) {
        alertController.popoverPresentationController.sourceView = self.view;
        alertController.popoverPresentationController.sourceRect = tap.view.frame;
    }
    UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleCancel handler:nil];
    cancelAction.accessibilityIdentifier = HWMManageConfJoinConfRestrictionCancel;
    
    UIAlertAction *allAction = [UIAlertAction actionWithTitle:@"所有人" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        self.callInRestriction = HWMCallRestrictionAll;
        [self updateJoinConfRestrictionLabelText];
    }];
    allAction.accessibilityIdentifier = HWMManageConfJoinConfRestrictionAll;
    UIAlertAction *companyAction = [UIAlertAction actionWithTitle:@"仅企业内人员" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        self.callInRestriction = HWMCallRestrictionCompany;
        [self updateJoinConfRestrictionLabelText];
    }];
    companyAction.accessibilityIdentifier = HWMManageConfJoinConfRestrictionCompany;
    UIAlertAction *invitedAction = [UIAlertAction actionWithTitle:@"仅会议邀请人员" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        self.callInRestriction = HWMCallRestrictionInvited;
        [self updateJoinConfRestrictionLabelText];
    }];
    invitedAction.accessibilityIdentifier = HWMManageConfJoinConfRestrictionInvited;
    [alertController addAction:cancelAction];
    [alertController addAction:allAction];
    [alertController addAction:companyAction];
    [alertController addAction:invitedAction];
    [self presentViewController:alertController animated:YES completion:nil];
}

- (void)updateJoinConfRestrictionLabelText {
    self.joinConfRestrictionLabel.text = [CommonUtil getTitleAllowInComming:self.callInRestriction];
}

- (void)changeVmrInfo {
    if ([self.pwdTextField.text isEqualToString:self.vmrInfo.guestPwd]) {
        [self.navigationController popViewControllerAnimated:YES];
    }
    
    HWMModifyVMRParam * vmrInfo = [[HWMModifyVMRParam alloc] init];
    vmrInfo.guestPwd = self.pwdSwitch.isOn ? self.pwdTextField.text : @"";
    vmrInfo.chairPwd = self.vmrInfo.chairmanPwd;
    vmrInfo.vmrName = self.vmrInfo.name;
    vmrInfo.vmrId = self.vmrInfo.vmrId;
    vmrInfo.allowGuestStartConf = self.allowGuestJoinConfSwitch.isOn;
    vmrInfo.confAllowJoinUser = self.callInRestriction;
    vmrInfo.isOpenWaitingRoom = self.waitingRoomSwitch.isOn;
    [[HWMBizSdk getBizOpenApi] changeVmrInfo:vmrInfo callback:^(NSError * _Nullable error, id  _Nullable result) {
        [UIUtil showMessage:@"修改成功" error:error];
    }];
}

- (UILabel *)newLabelWithTitle:(NSString *)title {
    UILabel *label = [[UILabel alloc] init];
    label.text = title;
    label.font = [UIFont systemFontOfSize:16];
    label.textColor = HexColor(0x333333);
    return label;
}

@end
