//
//  VmrListViewController.m
//  HWMSDKDemo
//
//  Created by guoyongliang/gwx917154 on 2020/8/12.
//  Copyright © 2020 HuaWei. All rights reserved.
//

#import "VmrListViewController.h"
#import "ChangeVmrInfoViewController.h"
#import "ConfListTableViewCell.h"
#import "CommonUtil.h"

@interface VmrListViewController ()
@property (nonatomic, strong) NSArray <HWMVmrInfoModel *> *vmrList;
@end

@implementation VmrListViewController
- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"虚拟会议室列表";
    [self initData];
    [self setupTableView];
}

- (void)initData {
    [[HWMBizSdk getBizOpenApi] getVmrList:^(NSError * _Nullable error, NSArray<HWMVmrInfoModel *> * _Nullable result) {
        self.vmrList = result;
        [self.tableView reloadData];
    }];
    
    [[HWMBizSdk getBizOpenApi] getVmrInfoList:^(NSError * _Nullable error, HWMVmrInfoListModel * _Nullable result) {
        self.vmrList = result.vmrList;
        [self.tableView reloadData];
    }];
}

- (void)setupTableView {
    [super setupTableView];
    [self.tableView registerClass:[ConfListTableViewCell class] forCellReuseIdentifier:@"ConfListTableViewCell"];
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.vmrList.count;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    return 140;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    HWMVmrInfoModel *model = self.vmrList[indexPath.row];
    ConfListTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"ConfListTableViewCell"];
    cell.titleLabel.numberOfLines = 0;
    [cell.editBtn setHidden:YES];
    [cell.cancelBtn setTitle:@"修改信息" forState:UIControlStateNormal];
    cell.titleLabel.text = [NSString stringWithFormat:@"会议ID：%@ \n会议ID类型：%@\n来宾密码：%@ \n主席密码：%@ \n允许来宾在主持人之前入会：%@\n允许入会：%@\n等候室：%@", model.confId,
                            model.type == HWMConfIdPersonal ? @"个人会议ID" : @"专用会议ID",
                            model.guestPwd,
                            model.chairmanPwd,
                            model.allowGuestStartConf?@"允许":@"不允许",
                            [CommonUtil getTitleAllowInComming:model.confAllowJoinUser],
                            model.isOpenWaitingRoom ? @"开启" : @"关闭"];
    weakify(self)
    cell.clickEvent = ^(BtnType type) {
        strongify(self)
        ChangeVmrInfoViewController * vc = [[ChangeVmrInfoViewController alloc] init];
        vc.vmrInfo = model;
        [self.navigationController pushViewController:vc animated:YES];
    };
    return cell;
}

@end
