//
//  SampleHandler.m
//  ScreenShareExtension
//
//  Created by LL on 2020/4/6.
//  Copyright © 2020 HuaWei. All rights reserved.
//


#pragma mark - SDK集成文档内容，放开以下内容，删除现有代码

 #import "SampleHandler.h"
#import <HWMExtension/HWMExtension.h>

 @interface SampleHandler()<ScreenShareManagerDelegate>
 @property (strong, nonatomic) HWMExensionDataManager *screenShareManager;

 @end

 @implementation SampleHandler

 - (instancetype)init {
     if (self = [super init]) {
//         [HWMExtensionAppGroup setAppGroup:@"group.com.huawei.cloudlink"];// 这里替换成自己申请的appgroup
        self.screenShareManager = [[HWMExensionDataManager alloc] init];
        self.screenShareManager.delegate = self;
     }
     return self;
 }


- (void)dealloc {
    self.screenShareManager = nil;
}

- (void)broadcastStartedWithSetupInfo:(NSDictionary<NSString *,NSObject *> *)setupInfo {
    // User has requested to start the broadcast. Setup info from the UI extension can be supplied but optional.
    [self.screenShareManager broadcastStartedWithSetupInfo:setupInfo];
}

- (void)broadcastPaused {
    // User has requested to pause the broadcast. Samples will stop being delivered.
    [self.screenShareManager broadcastPaused];
}

- (void)broadcastResumed {
    // User has requested to resume the broadcast. Samples delivery will resume.
    [self.screenShareManager broadcastResumed];
}

- (void)broadcastFinished {
    // User has requested to finish the broadcast.
    [self.screenShareManager broadcastFinished];
    
}

- (void)processSampleBuffer:(CMSampleBufferRef)sampleBuffer withType:(RPSampleBufferType)sampleBufferType {
    switch (sampleBufferType) {
        case RPSampleBufferTypeVideo:
            // Handle video sample buffer
            [self.screenShareManager processSampleBuffer:sampleBuffer withType:RPSampleBufferTypeVideo];
            
            break;
        case RPSampleBufferTypeAudioApp:
            // Handle audio sample buffer for app audio
            break;
        case RPSampleBufferTypeAudioMic:
            // Handle audio sample buffer for mic audio
            break;
            
        default:
            break;
    }
}

- (void)screenShareManagerFinishBroadcastWithError:(NSError *)error {
    [self.screenShareManager broadcastFinished];
    [self finishBroadcastWithError: error];
}

 @end
