//
//  HWMAnonymousJoinConfBySignatureInfo.h
//  HWMUISDK
//
//  Created by guoyongliang/g30033086 on 2023/9/18.
//  Copyright © 2023 huawei. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "HWMAppAuthInfo.h"

NS_ASSUME_NONNULL_BEGIN

@interface HWMAnonymousJoinConfBySignatureInfo : NSObject
/// 会议id
@property (nonatomic, copy) NSString *confId;
/// 会议密码
@property (nonatomic, copy) NSString *password;
/// 会议随机数
@property (nonatomic, copy) NSString *confRandom;
/// 会场名
@property (nonatomic, copy) NSString *name;
/// 会场名(英文)
@property (nullable, nonatomic, copy) NSString *aliasEN;
/// 会场名(中文)
@property (nullable, nonatomic, copy) NSString *aliasCN;
/// 是否打开摄像头，默认关闭
@property(nonatomic, assign) BOOL isCameraOn;
/// 是否打开麦克风， 默认打开
@property(nonatomic, assign) BOOL isMicOn;
/// 是否关闭扬声器
@property (nonatomic, assign) BOOL isCloseSpk;
/// app鉴权信息
@property (nonatomic, strong) HWMAppAuthInfo *appAuthInfo;
/// 企业互信应用ID 
@property (nonatomic, copy) NSString *corpTrustAppId;
/// 扩展信息
@property (nonatomic, copy) NSString *extendedField;
/// 是否支持登录后入会
@property (nonatomic, assign) BOOL supportLoginedJoinConf;
/// 是否隐藏密码弹窗，默认NO
@property (nonatomic, assign) BOOL isHidePasswordAlert;

@end

NS_ASSUME_NONNULL_END
