//
//  HWMAvatarStyle.h
//  HWMConfUI
//
//  Created by lining on 2025/3/29.
//  Copyright © 2025 huawei. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

/// 姓名显示风格
typedef NS_ENUM(NSInteger, HWMNameShowType) {
    HWMNameShowTypeFirstName,   // 显示拼音首字母
    HWMNameShowTypeFamilyName   // 显示姓氏
};

/// 头像形状
typedef NS_ENUM(NSInteger, HWMAvatarShape) {
    HWMAvatarShapeCircle    // 圆形头像
};

@interface HWMAvatarStyle : NSObject

/// 背景色
@property (nonatomic, strong) UIColor *backgroundColor;

/// 文字颜色
@property (nonatomic, copy) UIColor *textColor;

/// 姓名显示风格
@property (nonatomic, assign) HWMNameShowType nameShowType;

/// 头像形状
@property (nonatomic, assign) HWMAvatarShape avatarShape;

/// pstn用户头像图片
@property (nonatomic, strong) UIImage *phoneIcon;

/// 大屏头像图片
@property (nonatomic, strong) UIImage *boardIcon;

@end

NS_ASSUME_NONNULL_END
