//
//  HWMBizOpenApi.h
//  HWMUISDK
//
//  Created by y00450113 on 2020/8/3.
//  Copyright © 2020 huawei. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "HWMConfDetail.h"
#import "HWMOrderConfParam.h"
#import "HWMSdkDefine.h"
#import "HWMVmrInfoModel.h"
#import "HWMModifyVMRParam.h"
#import "HWMCancelConfParam.h"
#import "HWMOrderCycleConfParam.h"
#import "HWMSDKCancelCycleConfParamModel.h"
#import "HWMSDKCancelSubCycleConfParamModel.h"
#import "HWMSDKModifySubCycleConfParamModel.h"
#import "HWMSDKVoicePromptsModel.h"
#import "HWMUISDKExternalInviteeModel.h"
#import "HWMSDKGuaranteedIpAddressModel.h"
#import "HWMAvatarStyle.h"
#import "HWMSubtitleLanguageInfoModel.h"

NS_ASSUME_NONNULL_BEGIN

@interface HWMBizOpenApi : NSObject

/// 自己是否是主持人
- (BOOL)selfIsChairMan;

/// 获取会议列表
- (NSArray<HWMBaseConfDetailParam *> *)getConfList;


/// 获取会议详情
/// @param confId 会议ID
/// @param handler 结果回调，错误信息和会议信息
- (void)getConfDetail:(NSString *)confId completeHandler:(HWMSDKConfInfoCompleteHandler)handler;

/// 修改vmr会议室信息
/// @param info vmr会议信息
/// @param callback 结果回调
- (void)changeVmrInfo:(HWMModifyVMRParam *)info callback:(_Nonnull HWMSDKCompleteHandler)callback;

///  获取VMR ID列表，预约会议时可从次列表中选取固定会议ID进行预约
- (NSArray<HWMVmrInfoModel *> *)getVmrList DEPRECATED_MSG_ATTRIBUTE("Use '- (void)getVmrList:(_Nonnull HWMSDKVmrListCompleteHandler)callback' instead");

/// 获取VMR ID列表，预约会议时可从次列表中选取固定会议ID进行预约
/// @param callback 结果回调
- (void)getVmrList:(_Nonnull HWMSDKVmrListCompleteHandler)callback DEPRECATED_MSG_ATTRIBUTE("Use '- (void)getVmrInfoList:(__Nonnull HWMSDKVmrInfoListCompleteHandler)callback' instead");

/// 获取VMR ID列表，预约会议时可从次列表中选取固定会议ID进行预约
/// @param callback 结果回调
- (void)getVmrInfoList:(_Nonnull HWMSDKVmrInfoListCompleteHandler)callback;

/// 预约会议
/// @param param 预约会议信息
/// @param callback 结果回调（result返回会议详情）
- (void)bookConf:(HWMOrderConfParam *_Nonnull)param callback:(_Nonnull HWMSDKCompleteHandler)callback;

/// 预约周期会议
/// @param param 预约周期会议信息
/// @param callback 结果回调（result返回会议详情）
- (void)bookCycleConf:(HWMOrderCycleConfParam *_Nonnull)param callback:(_Nonnull HWMSDKCompleteHandler)callback;

/// 取消会议
/// @param confId 会议id
/// @param callback 结果回调
- (void)cancelConf:(NSString *_Nonnull)confId callback:(_Nonnull HWMSDKCompleteHandler)callback;

/// 取消会议
/// @param param 取消会议信息
/// @param callback 结果回调
- (void)cancelConfWithParam:(HWMCancelConfParam *_Nonnull)param callback:(_Nonnull HWMSDKCompleteHandler)callback;

/// 取消周期会议
/// @param param 取消周期会议信息
/// @param callback 结果回调
- (void)cancelCycleConfWithParam:(HWMSDKCancelCycleConfParamModel *_Nonnull)param callback:(_Nonnull HWMSDKCompleteHandler)callback;

/// 取消周期子会议
/// @param param 取消周期子会议信息
/// @param callback 结果回调
- (void)cancelSubCycleWithParam:(HWMSDKCancelSubCycleConfParamModel *_Nonnull)param callback:(_Nonnull HWMSDKCompleteHandler)callback;

/// 编辑会议
/// @param param 编辑会议信息
/// @param callback 结果回调
- (void)editConf:(HWMOrderConfParam *_Nonnull)param callback:(_Nonnull HWMSDKCompleteHandler)callback;

/// 编辑周期会议
/// @param param 编辑周期会议信息
/// @param callback 结果回调
- (void)editCycleConf:(HWMOrderCycleConfParam *_Nonnull)param callback:(_Nonnull HWMSDKCompleteHandler)callback;

/// 编辑周期子会议
/// @param param 编辑周期子会议信息
/// @param callback 结果回调
- (void)editSubCycleConf:(HWMSDKModifySubCycleConfParamModel *_Nonnull)param callback:(_Nonnull HWMSDKCompleteHandler)callback;

/// 上传用户头像
/// @param filePath 上传头像文件路径
/// @param callback 结果回调
- (void)uploadSelfAvatarWithFilePath:(NSString *_Nullable)filePath callback:(_Nonnull HWMSDKCompleteHandler)callback;

/// 获取会议和通话的状态
- (HWMSDKConfOrCallStatus)getIsInConfOrCall;

/// 获取会议呼叫电话号码
- (NSString *)getConfPstnAccessNumber;

/// 获取与会者列表
- (NSArray <HWMAttendeeInfo *> *)getAttendeeList;

/// 获取观众列表
- (NSArray <HWMAttendeeInfo *> *)getAudienceList;

/// 根据企业域名获取鉴权中心Url
/// @param domain 企业域名
/// @param callback 结果回调
- (void)getSsoAuthUrlWithDomain:(NSString *)domain callback:(_Nonnull HWMSDKSsoAuthUrlCompleteHandler)callback;

/// 禁用会议中的提示音
- (HWMSDKERR)disableVoicePrompts:(HWMSDKVoicePromptsModel *)voicePrompts;

/// 根据错误码获取错误提示
- (NSString *)getErrorMessage:(NSUInteger)code;

/// 设置(会控)保底ip地址
/// @param pAddresses  保底ip地址列表 多个地址中间用分号隔开, 最多支持4个地址
- (HWMSDKERR)setGuaranteedIpAddresses:(NSString *)pAddresses;

/// 设置(管理面)保底ip地址
/// @param ipAddresses 保底ip地址信息
- (HWMSDKERR)setGlobalGuaranteedIpAddresses:(NSArray<HWMSDKGuaranteedIpAddressModel *> *)ipAddresses;

/// 会前设置是否断开音频
- (void)setDisconnectAudioConfig:(BOOL)enable;

/// 更新外部受邀者
- (void)updateExternalInviteesList:(NSArray<HWMUISDKExternalInviteeModel *> *)externalInvitees;

/// 是否允许收集打点信息
- (void)setAllowMeetingUt:(BOOL)allowMeetingUt;

/// 显示会议主窗口
- (void)showMeetingWindow;

/// 查询自己共享状态
- (BOOL)getSelfShareState;

/// 停止共享
- (void)stopShare:(NSString * _Nullable)stopShareDes;

/// 获取登录状态
- (HWMLoginState)getLoginState;

/// 设置与会者头像风格
- (HWMSDKERR)setParticipantAvatarStyle:(HWMAvatarStyle *)avatarStyle;

/// 获取登录token
- (NSString *)getLoginToken;

/// 开启/关闭字幕
- (void)openSubtitle:(BOOL)isOpen callback:(HWMSDKCompleteHandler)callback;

/// 是否已经打开字幕页面
- (BOOL)subtitlePageOpened;

/// 开启/关闭等候室
- (void)openWaitingRoom:(BOOL)isOpen callback:(HWMSDKCompleteHandler)callback;

/// 是否已经开启等候室
- (BOOL)waitingRoomOpened;

/// 申请主持人
- (void)applyHostRole:(NSString *)password callback:(HWMSDKCompleteHandler)callback;

/// 打开虚拟背景设置
- (void)openVirtualBackgroundSettingPageWithCallback:(HWMSDKCompleteHandler)callback;

/// 是否已经打开虚拟背景设置
- (BOOL)virtualBackgroundSettingPageOpened;

/// 订阅/取消订阅字幕
- (void)subscribeSubtitle:(BOOL)isSubscribe callback:(HWMSDKCompleteHandler)callback;

/// 订阅字幕语言
- (HWMSDKERR)subscribeSubtitleLanguage:(HWMTargetLanguageType)targetLanguageType;

/// 获取字幕翻译语言列表
- (NSArray<HWMSubtitleLanguageInfoModel *> *)getSubtitleSupportLanguage;

@end

NS_ASSUME_NONNULL_END
