//
//  HWMCreateConfParam.h
//  HWMUISDK
//
//  Created by 融合软终端02 on 2020/3/27.
//  Copyright © 2020 huawei. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "HWMConfSdkDefine.h"
#import "HWMSdkDefine.h"
typedef NS_ENUM(NSUInteger, HWMConfType) {
    HWMConfTypeAudio, // 音频会议
    HWMConfTypeVideo, // 视频会议
    HWMConfTypeAudioAndData,// 音频数据会议，支持屏幕共享能力
    HWMConfTypeVideoData// 视频数据会议， 支持屏幕共享能力
};
NS_ASSUME_NONNULL_BEGIN

@interface HWMCreateConfMember : NSObject
// 与会者 名字
@property(nonatomic, strong)NSString *name;

// 与会者号码
@property(nonatomic, strong)NSString *number;

// 用户账号ID
@property(nonatomic, strong)NSString *accountId;

// 终端类型
@property(nonatomic, assign)HWMClientDeviceType clientType;

#pragma mark - APPID 登录属性，用于带人创会&会中邀人，优先级高于 accountId
@property (nonatomic, copy) NSString *thirdUserId; /// APPID 登录场景下的第三方账号

/// 中文别名
@property (nullable, nonatomic, copy) NSString *aliasCN;

/// 英文别名
@property (nullable, nonatomic, copy) NSString *aliasEN;

/// 三方自定义字段
@property (nullable, nonatomic, copy) NSString *extendedField;

/// 企业id
@property (nullable, nonatomic, copy) NSString *orgId;

/// 用户类型
@property (nonatomic, assign) HWMConfAttendeeType type;

/// 是否自动外邀，默认YES
@property (nonatomic, assign) BOOL isAutoInvite;

@end

@interface HWMCreateConfParam : NSObject

/// 会议主题
@property(nonatomic, copy) NSString *subject;

/// 会议媒体类型 默认语音会议，如果要支持屏幕共享能力，需传入数据会议
@property(nonatomic, assign) HWMConfType confType;

/// 会议是否需要设置密码，默认不需要,传入vmrId时，设置为YES
@property(nonatomic, assign) BOOL needPassword;
/// 会议密码，仅对随机ID会议生效
@property (nonatomic, copy) NSString *guestPwd;

/// 成员列表，可选
@property(nonatomic, strong) NSArray <HWMCreateConfMember *> *members;

/// 个人会议或者云会议室Id，创建个人会议或云会议室的时候传入，其它时候传入空
@property(nonatomic, copy) NSString *vmrId;

/// VmrId会议类型(固定/随机)
@property (nonatomic, assign) HWMVmrIdType vmrIdType;

/// 允许入会范围
@property (nonatomic, assign)  HWMJoinConfRestrictionType joinConfRestrictionType;

/// 是否打开摄像头, 默认关闭
@property(nonatomic, assign) BOOL isCameraOn;

/// 是否打开麦克风， 默认打开
@property(nonatomic, assign) BOOL isMicOn;

/// 是否打开会议录制， 默认关闭
@property (nonatomic, assign) BOOL isRecordOn;

/// 是否允许自动录制会议， 默认关闭
@property (nonatomic, assign) BOOL isAutoRecord;

/// 媒体类型,预留参数请勿使用
@property (nonatomic, assign) HWMAvType mediaServerType;

/// 是否允许开启等候室
@property (nonatomic, assign) BOOL isOpenWaitingRoom;

/// 自定义信息
@property (nonatomic, copy) NSString *customInfo;

/// 是否关闭扬声器，默认不关闭
@property (nonatomic, assign) BOOL isSpeakerOff;

/// (选填）会议最大与会人数，默认0
@property (nonatomic, assign) NSUInteger concurrentParticipants;
/// 会议资源类型
@property (nonatomic, assign) HWMConfResType confResType;
/// 个人客户端入会是否自动静音
@property (nonatomic, assign) HWMAutoMuteType autoMuteMode;
/// 会议室设备入会是否自动静音
@property (nonatomic, assign) HWMAutoMuteType hardTerminalAutoMuteMode;
/// 是否开启多人共享
@property (nonatomic, assign) BOOL supportMultiShare;
/// 是否支持水印
@property (nonatomic, assign) BOOL supportWatermark;
/// 录制时，智能会议纪要的默认状态，仅支持会议纪要时生效
@property (nonatomic, assign) HWMSummaryState defaultSummaryState;
/// 是否免审核自动发布纪要
@property (nonatomic, assign) BOOL autoPublishSummary;

@end

NS_ASSUME_NONNULL_END
