//
//  HWMCustomUITextHandler.h
//  HWMConfUI
//
//  Created by houxiebing on 2024/8/26.
//

#import <Foundation/Foundation.h>

typedef NS_ENUM(NSUInteger, HWMCustomUITextScene) {
    HWMCustomUITextSceneCloudRecordFinishedAlert = 0,    // 会议云录制结束弹窗提示文案
    HWMCustomUITextSceneCloudRecordFinishedInMeetingAlert,    // 会中会议云录制结束弹窗提示文案
    HWMCustomUITextSceneLeaveOrEndConfPopupWindow,       // 离开或结束会议弹框标题文案
    HWMCustomUITextSceneCloudRecordMenuTitle,            // 录制弹窗菜单中的云录制标题
    HWMCustomUITextSceneMainWindowCloudRecordDes,        // 主窗口中的云录制描述
    HWMCustomUITextSceneCount,                           // 仅用于遍历计数，请在此项之前添加新场景！！！
};

NS_ASSUME_NONNULL_BEGIN

@interface HWMUILanguageInfo : NSObject

/// 语言代码
@property (nonatomic, copy) NSString *languageCode;

/// 需要自定义的内容
@property (nonatomic, copy) NSString *customContent;

/// Fast Init
/// - Parameters:
///   - code: languageCode 约定 中文：@"cn" English: @"en"  其他自定义语言的传入 xx.lproj 文件中的 @"xx" 如：ar.lproj 就传 @"ar"
///   - content: customContent
+ (instancetype)infoWithCode:(NSString *)code content:(NSString *)content;

@end

@protocol HWMCustomUITextHandler <NSObject>

@optional

/// 场景文案自定义
/// - Parameter scene: 返回当前场景的所有要支持的语言模型，至少包含中英两种类型的模型，否则会设置失败
/// - example：
/// NSArray *models = @[[HWMUILanguageInfo infoWithCode:@"cn" content:@"谢谢"], [HWMUILanguageInfo infoWithCode:@"en" content:@"Thanks"]]
/// return models
- (NSArray <HWMUILanguageInfo *> *)customLanguageInfosForScene:(HWMCustomUITextScene)scene;

@end


NS_ASSUME_NONNULL_END
