//
//  HWMOrderConfParam.h
//  HWMUISDK
//
//  Created by guoyongliang/gwx917154 on 2020/8/11.
//

#import <Foundation/Foundation.h>
#import "HWMAttendeeInfo.h"
#import "HWMSdkDefine.h"
#import "HWMConfSdkDefine.h"
NS_ASSUME_NONNULL_BEGIN

@interface HWMOrderConfParam : NSObject
@property (nonatomic, copy) NSString *confSubject;          /**< 会议主题 */
@property (nonatomic, assign) NSTimeInterval startTime DEPRECATED_MSG_ATTRIBUTE("Use 'startTimeStamp' instead");     /**< 会议开始时间 */
@property (nonatomic, assign) NSTimeInterval startTimeStamp;  /**< 会议开始时间 */
@property (nonatomic, assign) NSUInteger duration;          /**< 会议持续时长，单位分钟 */
@property (nonatomic, assign) HWMOrderConfType confType;    /**< 会议类型 */
@property (nonatomic, assign) BOOL isNeedConfPwd;           /**< 是否需要来宾密码 */
@property (nonatomic, copy) NSString *guestPwd;             /**< 来宾密码（只针对随机ID会议生效） */
@property (nonatomic, assign) BOOL isRecordOn;              /**< 录制会议开关 */
@property (nonatomic, assign) BOOL isLiveOn;                /**< 是否直播 */
@property (nonatomic, assign) BOOL isAutoRecord;            /**< 允许自动录制会议开关 */
@property (nonatomic, assign) NSInteger timeZone;           /**< 时区 */
@property (nonatomic, copy) NSString *vmrId;                /**< 个人会议或者云会议室时传入 */
@property (nonatomic, assign) HWMVmrIdType vmrIdType;       /**< VmrId会议类型(固定/随机) */
@property (nonatomic, assign) HWMJoinConfRestrictionType callInRestrictionType; /**< 允许入会范围限制 */
@property (nonatomic, strong) NSArray<HWMAttendeeInfo *> *attendee;             /**< 与会者信息 */

@property (nonatomic, assign) BOOL isSmsOn;                 /**< 发送短信通知开关，可选参数，企业配置里面需要开启，否则不生效 */
@property (nonatomic, assign) BOOL isMailOn;                /**< 发送邮件通知开发，可选参数，企业配置里面需要开启，否则不生效 */
@property (nonatomic, assign) BOOL isEmailCalenderOn;       /**< 发送邮件日历开关 */
@property (nonatomic, assign) HWMAvType mediaServerType;    /**< 媒体类型,预留参数请勿使用 */
@property (nonatomic, assign) BOOL allowGuestStartConf;     /**< 允许来宾在主持人之前入会，默认允许 */
@property (nonatomic, assign) NSInteger allowGuestStartConfTime; /**< 来宾可在会议开始前多久入会。0：任意时间，n:可提起n分钟入会，默认0 */
/// 编辑会议时使用。
@property (nonatomic, copy) NSString *confId;
@property (nonatomic, assign) BOOL isOpenWaitingRoom;
@property (nonatomic, copy) NSString *customInfo;           /// 自定义信息
/// (选填）会议最大与会人数，默认0
@property (nonatomic, assign) NSUInteger concurrentParticipants;
/// 会议资源类型
@property (nonatomic, assign) HWMConfResType confResType;
/// 个人客户端入会是否自动静音
@property (nonatomic, assign) HWMAutoMuteType autoMuteMode;
/// 会议室设备入会是否自动静音
@property (nonatomic, assign) HWMAutoMuteType hardTerminalAutoMuteMode;
/// 是否开启多人共享
@property (nonatomic, assign) BOOL supportMultiShare;
/// 是否提供水印
@property (nonatomic, assign) BOOL supportWatermark;
/// 录制时，智能会议纪要的默认状态，仅支持会议纪要时生效
@property (nonatomic, assign) HWMSummaryState defaultSummaryState;
/// 是否免审核自动发布纪要
@property (nonatomic, assign) BOOL autoPublishSummary;

// SDK预约会议是否去掉预定者。默认false，携带预定者；true，去掉预定者
@property (nonatomic, assign) BOOL attendeesExcludeSelf;
@end

NS_ASSUME_NONNULL_END
