//
//  HWMVirtualBackgroundImageConfig.h
//  HWMConfUI
//
//  Created by yaolili/ywx577644 on 2022/5/12.
//  Copyright © 2022 huawei. All rights reserved.
//

#import <Foundation/Foundation.h>

// 设置虚拟背景默认图片方式
typedef NS_ENUM(NSInteger, HWMSettingVBDefaultImageMode) {
    HWMSettingVBDefaultImageModeReplaceAll, // 全部替换, 覆盖原有默认图片，最多50张
    HWMSettingVBDefaultImageModeAppend      // 追加，原有的默认图片+新增的默认图片，最多45张
};

NS_ASSUME_NONNULL_BEGIN


@interface HWMVirtualBackgroundImageModel : NSObject

/// 图片路径
@property (nonatomic, copy) NSString *imagePath;

@end


@interface HWMVirtualBackgroundImageConfig : NSObject

@property (nonatomic, assign) BOOL allowCustomVirtualBackgroundImage;/**< 是否允许自定义虚拟背景图片 */
@property (nonatomic, assign) HWMSettingVBDefaultImageMode imageMode; // 默认HWMSettingVBDefaultImageModeAppend
@property (nonatomic, strong) NSArray<HWMVirtualBackgroundImageModel *> *imageInfos;

@end


NS_ASSUME_NONNULL_END
