﻿/**
* @file HwmDataBaseService.h
*
* Copyright(C), 2024-2025, Huawei Tech. Co., Ltd. ALL RIGHTS RESERVED.
*
* @brief Xxxxxx.
*/

#ifndef __HWM_DATA_BASE_SERVICE_H__
#define __HWM_DATA_BASE_SERVICE_H__

#import "HwmSdkCommonDef.h"
#import "HwmDataBaseDef.h"
#import "HwmGlobalErrorCodeDef.h"

BEGIN_HWM_SDK_NAMESPACE

/**
* @brief [en]This class is about db management object.
*        [cn]数据库管理对象
* @detail
* [en]This class is about db management object.
* [cn]获取数据库管理对象的方法NativeSDK.getDBApi()
*
* @android:disable
* @ios:disable
* @mac:disable
*
* @GetInstance
*        HWM_SDK_NAMESPACE::HwmNativeSDK::GetDBApi() 
*/
class IHwmDB
{
public:
    /**
    * @brief
    * [en]
    * [cn] 初始化数据库路径
    * @mobile:disable
    *
    */
    virtual SDKERR InitDBPath(IN const HWM_CHAR* dbPath, IN const HWM_CHAR* logPath) = 0;

    /**
    * @brief
    * [en]
    * [cn] 设置日志路径
    * @synchronized
    * @private
    * @mobile:disable
    *
    */
    virtual SDKERR SetLogPath(IN const HWM_CHAR* logPath) = 0;

    /**
    * @brief
    * [en]
    * [cn] 初始化数据库
    * @synchronized
    * @mobile:disable
    *
    */
    virtual SDKERR InitDB(IN const HWM_CHAR* dbPath, IN const HWM_CHAR* userAccount) = 0;

    /**
    * @brief
    * [en]
    * [cn] 添加系统配置
    * @synchronized
    * @mobile:disable
    *
    */
    virtual SDKERR AddSysConfig(IN const DBSysKeyValue* keyValue) = 0;

     /**
    * @brief
    * [en]
    * [cn] 删除系统配置
    * @synchronized
    * @mobile:disable
    *
    */
    virtual SDKERR DelSysConfig(IN const DBMatchInfo* matchInfo) = 0;

    /**
    * @brief
    * [en]
    * [cn] 查询系统配置
    * @synchronized
    * @paramOut
    * @mobile:disable
    *
    */
    virtual SDKERR QuerySysConfig(IN const DBMatchInfo* matchInfo, HWM_UINT32 len, OUT HwmList<DBSysKeyValue>* sysKeyValueList) = 0;

    /**
    * @brief
    * [en]
    * [cn] 添加登录信息
    * @synchronized
    * @mobile:disable
    *
    */
    virtual SDKERR AddLoginInfo(IN const DBLoginInfo* loginInfo) = 0;

    /**
    * @brief
    * [en]
    * [cn] 删除登录信息
    * @synchronized
    * @mobile:disable
    *
    */
    virtual SDKERR DelLoginInfo(IN const DBMatchInfo* matchInfo) = 0;

    /**
    * @brief
    * [en]
    * [cn] 查询登录信息
    * @synchronized
    * @paramOut
    * @mobile:disable
    *
    */
    virtual SDKERR QueryLoginInfo(IN const DBMatchInfo* matchInfo, IN HWM_UINT32 len,  OUT HwmList<DBLoginInfo>* loginInfoList) = 0;

    /**
    * @brief
    * [en]
    * [cn] 添加联系人
    * @synchronized
    * @mobile:disable
    *
    */
    virtual SDKERR AddContact(IN const DBContactInfo* contactInfo) = 0;

    /**
    * @brief
    * [en]
    * [cn] 添加联系人列表
    * @synchronized
    * @mobile:disable
    *
    */
    virtual SDKERR AddContactList(HwmList<DBContactInfo>* contactInfoList) = 0;

    /**
    * @brief
    * [en]
    * [cn] 删除联系人列表
    * @synchronized
    * @mobile:disable
    *
    */
    virtual SDKERR DelContactList(IN const DBMatchInfo* matchInfo) = 0;

    /**
    * @brief
    * [en]
    * [cn] 查询联系人
    * @synchronized
    * @paramOut
    * @mobile:disable
    *
    */
    virtual SDKERR QueryContact(IN const DBMatchInfo* matchInfo, HWM_UINT32 len, OUT HwmList<DBContactInfo>* contactInfoList) = 0;

    /**
    * @brief
    * [en]
    * [cn] 添加用户配置
    * @synchronized
    * @mobile:disable
    *
    */
    virtual SDKERR AddUserConfig(IN const DBKeyValue* keyValue) = 0;

    /**
    * @brief
    * [en]
    * [cn] 删除用户配置
    * @synchronized
    * @mobile:disable
    *
    */
    virtual SDKERR DelUserConfig(IN const DBMatchInfo* matchInfo) = 0;

    /**
    * @brief
    * [en]
    * [cn] 查询用户配置
    * @synchronized
    * @paramOut
    * @mobile:disable
    *
    */
    virtual SDKERR QueryUserConfig(IN const DBMatchInfo* matchInfo, HWM_UINT32 len, OUT HwmList<DBKeyValue>* keyValueList) = 0;

    /**
    * @brief
    * [en]
    * [cn] 添加呼叫记录
    * @synchronized
    * @mobile:disable
    *
    */
    virtual SDKERR AddCallRecord(IN const DBCallRecord* callRecord) = 0;

    /**
    * @brief
    * [en]
    * [cn] 添加用户配置列表
    * @synchronized
    * @mobile:disable
    *
    */
    virtual SDKERR AddUserConfigList(HwmList<DBKeyValue>* keyValueList) = 0;

    /**
    * @brief
    * [en]
    * [cn] 设置盐值
    * @synchronized
    * @mobile:disable
    *
    */
    virtual SDKERR SetDBSalt(IN const HWM_CHAR* plainText, IN const HWM_CHAR* vecText, IN const HWM_CHAR* secText) = 0;

    /**
    * @brief
    * [en]
    * [cn] 获取盐值
    * @synchronized
    * @paramOut
    * @mobile:disable
    *
    */
    virtual SDKERR GetDBSalt(OUT DBSalt* discNumber) = 0;

    /**
    * @brief
    * [en]
    * [cn] 添加头像
    * @synchronized
    * @mobile:disable
    *
    */
    virtual SDKERR AddAvatar(IN const DBAvatarTag* avatarTag) = 0;

    /**
    * @brief
    * [en]
    * [cn] 删除头像
    * @synchronized
    * @mobile:disable
    *
    */
    virtual SDKERR DelAvatar(IN const DBMatchInfo* matchInfo) = 0;

    /**
    * @brief
    * [en]
    * [cn] 查询头像
    * @synchronized
    * @paramOut
    * @mobile:disable
    * 
    */
    virtual SDKERR QueryAvatar(IN const DBMatchInfo* matchInfo, IN HWM_UINT32 len, OUT HwmList<DBAvatarTag>* avatarTagList) = 0;
};


END_HWM_SDK_NAMESPACE

#endif /* __HWM_DATA_BASE_SERVICE_H__ */