﻿/**
* @file HwmKMCService.h
*
* Copyright(C), 2024-2025, Huawei Tech. Co., Ltd. ALL RIGHTS RESERVED.
*
* @brief Xxxxxx.
*/

#ifndef __HWM_HTTP_SERVICE_H__
#define __HWM_HTTP_SERVICE_H__

#import "HwmSdkCommonDef.h"
#import "HwmHTTPDef.h"

BEGIN_HWM_SDK_NAMESPACE

/**
* @brief [en]http notify
*        [cn]HTTP通知.
*
* @android:disable
* @ios:disable
* @mac:disable
*
*/
class HWM_API IHwmHTTPNotifyCallback
{
public:
    /**
    * @brief
    * [en] HTTP response notify
    * [cn] http响应通知
    * 
    * @param handle [type:HWM_UINT32]
    * [cn]http句柄
    * @param enCode [type:HWM_INT32]
    * [cn]错误码
    * @param rsp [type:HTTPRsp*]
    * [cn]http响应结果
    * 
    * @android:disable
    * @ios:disable
    * @mac:disable
    *
    * @since:v1.0
    */
    virtual HWM_VOID OnResponseNotify(HWM_UINT32 handle, HWM_INT32 enCode, HTTPRsp* rsp){};

    /**
    * @brief
    * [en] HTTP trans progress notify
    * [cn] http传输过程通知
    * 
    * @param handle [type:HWM_UINT32]
    * [cn]http句柄
    * @param ulTotal [type:HWM_UINT64]
    * [cn]文件(数据)总大小
    * @param ulNow [type:HWM_UINT64]
    * [cn]当前已传输大小
    * 
    * @android:disable
    * @ios:disable
    * @mac:disable
    *
    * @since:v1.0
    */
    virtual HWM_VOID OnTransProgressNotify(HWM_UINT32 handle, HWM_UINT64 ulTotal, HWM_UINT64 ulNow){};
};


/**
* @brief [en]This class is about http management object.
*        [cn]HTTP管理对象
* @detail
* [en]This class is about http management object.
* [cn]获取HTTP管理对象的方法NativeSDK.getHTTPApi()
*
* @android:disable
* @ios:disable
* @mac:disable
*
* @GetInstance
*        HWM_SDK_NAMESPACE::HwmNativeSDK::GetHTTPApi()
*/
class IHwmHTTP
{
public:
    /**
    * @brief
    * [en]This class is about the global callbacks of HTTP notifications class.
    * [cn]设置HTTP通知类全局回调
    *
    * @param callback [cs_allowNull:N]
    * [en]
    * [cn]HTTP通知类全局回调
    * @see IHwmHTTPNotifyCallback
    * 
    * @android:disable
    * @ios:disable
    * @mac:disable
    * 
    * @since:v1.0
    */
    virtual SDKERR SetHTTPNotifyCallback(IHwmHTTPNotifyCallback* callback) = 0;

    /**
    * @brief
    * [en] HTTP asynchronous request
    * [cn] http异步请求
    * 
    * @synchronized
    * @paramOut
    * 
    * @param param [type:HTTPAsynSendParam*][cs_allowNull:N]
    * [cn]参数
    * @param result [type:HTTPResult*]
    * [cn]接口调用结果
    * 
    * @android:disable
    * @ios:disable
    * @mac:disable
    * 
    * @since:v1.0
    */
    virtual HWM_VOID AsynSend(IN const HTTPAsynSendParam* param, OUT HTTPResult* result) = 0;

    /**
    * @brief
    * [en] HTTP Upload request
    * [cn] http上传请求
    * 
    * @synchronized
    * @paramOut
    * 
    * @param param [type:HTTPUploadFileParam*][cs_allowNull:N]
    * [cn]参数
    * @param result [type:HTTPResult*]
    * [cn]接口调用结果
    * 
    * @android:disable
    * @ios:disable
    * @mac:disable
    * 
    * @since:v1.0
    */
    virtual HWM_VOID Upload(IN const HTTPUploadFileParam* param, OUT HTTPResult* result) = 0;

    /**
    * @brief
    * [en] HTTP download request
    * [cn] http下载请求
    * 
    * @synchronized
    * @paramOut
    * 
    * @param param [type:HTTPDownloadFileParam*][cs_allowNull:N]
    * [cn]参数
    * @param result [type:HTTPResult*]
    * [cn]接口调用结果
    * 
    * @android:disable
    * @ios:disable
    * @mac:disable
    * 
    * @since:v1.0
    */
    virtual HWM_VOID Download(IN const HTTPDownloadFileParam* param, OUT HTTPResult* result) = 0;

    /**
    * @brief
    * [en] HTTP cancel request
    * [cn] http取消正在进行的请求
    * 
    * @synchronized
    * 
    * @param handle [type:HWM_UINT32][cs_allowNull:Y]
    * [cn]参数
    * 
    * @android:disable
    * @ios:disable
    * @mac:disable
    * 
    * @since:v1.0
    */
    virtual SDKERR Cancel(IN HWM_UINT32 handle) = 0;
};

END_HWM_SDK_NAMESPACE

#endif  /* __HWM_HTTP_SERVICE_H__ */
