﻿/**
* @file HwmKMCService.h
*
* Copyright(C), 2024-2025, Huawei Tech. Co., Ltd. ALL RIGHTS RESERVED.
*
* @brief Xxxxxx.
*/

#ifndef __HWM_KMC_SERVICE_H__
#define __HWM_KMC_SERVICE_H__

#import "HwmSdkCommonDef.h"
#import "HwmKMCDef.h"
#import "HwmGlobalErrorCodeDef.h"

BEGIN_HWM_SDK_NAMESPACE

/**
* @brief [en]This class is about kmc management object.
*        [cn]KMC管理对象
* @detail
* [en]This class is about kmc management object.
* [cn]获取KMC管理对象的方法NativeSDK.getKMCApi()
*
* @android:disable
* @ios:disable
* @mac:disable
*
* @GetInstance
*        HWM_SDK_NAMESPACE::HwmNativeSDK::GetKMCApi()
*/
class IHwmKMC
{
public:
    /**
    * @brief
    * [en]
    * [cn] 通用加密
    * @synchronized
    * @paramOut
    * @mobile:disable
    *
    */
    virtual SDKERR CommonLibEncrypt(const HWM_CHAR* key, const HWM_CHAR* iv, const HWM_CHAR* plain, OUT CipherText* cipherText) = 0;

    /**
    * @brief
    * [en]
    * [cn] 通用解密
    * @synchronized
    * @paramOut
    * @mobile:disable
    *
    */
    virtual SDKERR CommonLibDecrypt(const HWM_CHAR* key, const HWM_CHAR* iv, const HWM_CHAR* cipher, OUT PlainText* plainText) = 0;

    /**
    * @brief
    * [en]
    * [cn] 获取真随机数
    * @synchronized
    * @paramOut
    * @mobile:disable
    *
    */
    virtual SDKERR CommonLibGetRealRandom(HWM_UINT32 randomLen, OUT RandomText* randomText) = 0;

    /**
    * @brief
    * [en]
    * [cn] 获取派生密钥
    * @synchronized
    * @paramOut
    * @mobile:disable
    *
    */
    virtual SDKERR CommonLibGetDerivedKey(const HWM_CHAR* salt, const HWM_CHAR* iv, HWM_UINT32 dkLen, OUT DerivedKey* derivedKey) = 0;

    /**
    * @brief
    * [en]
    * [cn] 启动
    * @synchronized
    * @mobile:disable
    *
    */
    virtual SDKERR KMCStart(const HWM_CHAR* logFile, const HWM_CHAR* keyStore, const HWM_CHAR* keyStoreBack) = 0;

    /**
    * @brief
    * [en]
    * [cn] 停止
    * @synchronized
    * @mobile:disable
    *
    */
    virtual SDKERR KMCStop() = 0;

    /**
    * @brief
    * [en]
    * [cn] 加密
    * @synchronized
    * @paramOut
    * @mobile:disable
    *
    */
    virtual SDKERR KMCEncrypt(const HWM_CHAR* text, OUT CipherText* cipherText) = 0;

    /**
    * @brief
    * [en]
    * [cn] 解密
    * @synchronized
    * @paramOut
    * @mobile:disable
    *
    */
    virtual SDKERR KMCDecrypt(const HWM_CHAR* cipher, OUT PlainText* plainText) = 0;
};

END_HWM_SDK_NAMESPACE

#endif  /* __HWM_KMC_SERVICE_H__ */
