﻿/**
* @file HwmNativeLoggerService.h
*
* Copyright(C), 2024-2025, Huawei Tech. Co., Ltd. ALL RIGHTS RESERVED.
*
* @brief Xxxxxx.
*/

#ifndef __HWM_NATIVE_LOGGER_SERVICE_H__
#define __HWM_NATIVE_LOGGER_SERVICE_H__

#import "HwmSdkCommonDef.h"
#import "HwmNativeSdkDef.h"

BEGIN_HWM_SDK_NAMESPACE

/**
* @brief [en]This class is about logger management object.
*        [cn]日志管理对象
* @detail
* [en]This class is about logger management object.
* [cn]获取日志管理对象的方法NativeSDK.getLoggerApi()
*
* @android:disable
* @ios:disable
* @mac:disable
*
* @GetInstance
*        HWM_SDK_NAMESPACE::HwmNativeSDK::GetLoggerApi()
*/
class IHwmLogger
{
public:
    /**
    * @brief
    * [en]
    * [cn] 初始化日志管理对象
    * @synchronized
    *
    */
    virtual HWM_VOID InitLogger(const HWM_CHAR* moduleName, const LogParam* logParam) = 0;

    /**
    * @brief
    * [en]
    * [cn] 更新日志信息
    * @synchronized
    *
    */
    virtual HWM_VOID UpdateLogger(const HWM_CHAR* moduleName, const LogParam* logParam) = 0;

    /**
    * @brief
    * [en]
    * [cn] 写入日志
    * @synchronized
    *
    */
    virtual HWM_VOID WriteLog(const LogInfoParam* logInfoParam) = 0;
};

END_HWM_SDK_NAMESPACE

#endif  /* __HWM_NATIVE_LOGGER_SERVICE_H__ */
