﻿/**
 * @file HwmLoginServiceDef.h
 *
 * Copyright(C), 2019-2020, Huawei Tech. Co., Ltd. ALL RIGHTS RESERVED.
 *
 * @brief Xxxxxx.
 */


#ifndef __HWM_NETWORK_SERVICE_DEF_H__
#define __HWM_NETWORK_SERVICE_DEF_H__

#import "HwmSdkCommonDef.h"

BEGIN_HWM_SDK_NAMESPACE




/**
* [en]This enumeration is used to describe domain mode.
* [cn]域名模式
*/
typedef enum tagServerDomainStrategyMode
{
    SERVER_DOMAIN_STRATEGY_MODE_COM = 0,                /**< [en]Indicates server domain com strategy.
                                                             [cn]COM模式
                                                             [ios:rename:Com] */
    SERVER_DOMAIN_STRATEGY_MODE_CN,                     /**< [en]Indicates server domain cn strategy.
                                                             [cn]CN模式
                                                             [ios:rename:Cn] */
}ServerDomainStrategyMode;

/**
 * [en]This structure is used to describe the domain.
 * [cn]域名模式信息
 */
typedef struct tagServerDomainStrategy
{
    ServerDomainStrategyMode mode;                        /**< [en]Indicates the server domain strategy.
                                                                           [cn]域名模式
                                                                           [cs_allowNull:N] */
    HWM_CHAR strategy[HWM_MAX_SERVER_DOMAIN_STRATEGY_LEN];         /**< [en]Indicates the server domain
                                                                           [cn]域名
                                                                           [cs_allowNull:N] */
}ServerDomainStrategy;

/**
 * [en]This enumeration is used to describe verify mode.
 * [cn]认证模式
 */
typedef enum tagVerifyMode
{
    VERIFY_MODE_NONE = 0,                       /**< [en]Indicates no authentication.
                                                     [cn]不认证
                                                     [ios:rename:None] */
    VERIFY_MODE_SERVER,                         /**< [en]Indicates  authentication server.
                                                     [cn]认证服务端
                                                     [ios:rename:Server] */
    VERIFY_MODE_BUTT                            /**< [ios:rename:Butt] */
}VerifyMode;


/**
 * [en]This structure is used to describe the http proxy information.
 * [cn]代理信息
 */
typedef struct tagProxyInfo
{
    HWM_CHAR userName[HWM_MAX_USERNAME_LEN];        /**< [en]Indicates the account username.
                                                         [cn]账户用户名 
                                                         [cs_allowNull:Y][cs_length:0-128][cs_sensitive:name] */
    HWM_CHAR password[HWM_MAX_PASSWORD_LEN];        /**< [en]Indicates the account password.
                                                         [cn]账户密码 
                                                         [cs_allowNull:Y][cs_length:0-128] [cs_sensitive:hide] */
    HWM_CHAR proxyUri[HWM_MAX_URL_LEN];             /**< [en]Indicates the proxy address.
                                                         [cn]服务器地址 
                                                         [cs_allowNull:Y][cs_length:0-256] */
    HWM_UINT32 proxyPort;                           /**< [en]Indicates the proxy port.
                                                         [cn]代理服务器端口号 
                                                         [cs_allowNull:Y] */
}ProxyInfo;


/**
 * [en]This structure is used to describe login parameters.
 * [cn]登录信息参数
 */
typedef struct tagServerInfo
{
    HWM_CHAR serverAddr[HWM_MAX_URL_LEN];           /**< [en]Indicates the server address.
                                                         [cn]服务器地址，国内站或国际站
                                                         [cs_allowNull:N][cs_length:1-256] */
    HWM_UINT32 serverPort;                          /**< [en]Indicates the server port.
                                                         [cn]服务器端口号，端口默认443
                                                         [cs_allowNull:N][cs_length:1-512] */
}ServerInfo;

typedef enum tagDeployType
{
    CLOUD_MODE = 0,                          /**< [en]Indicates cloud mode
                                                        <br>[cn]云上模式 */
    SINK_MODE,                               /**< [en]Indicates sink mode
                                                        <br>[cn]下沉模式 */
}DeployType;


/**
 * [en]This structure is used to describe deploy info.
 * [cn]部署信息参数
 */
typedef struct tagDeployInfo
{
    ServerInfo serverInfo;                          /**< [en]Indicates the server info.
                                                         [cn]服务器地址和端口信息
                                                         [cs_allowNull:N] */
    DeployType deployType;                          /**< [en]Indicates the deploy mode.
                                                         [cn]部署模式
                                                         [cs_allowNull:N] */
}DeployInfo;

/**
 * [en]This structure is used to describe the verify param.
 * [cn]Verify参数
 */
typedef struct tagVerifyParam
{
    VerifyMode verifyMode;                       /**< [en]Indicates the tls verify mode
                                                         [cn]认证模式
                                                         [cs_allowNull:N] */
    HWM_CHAR certPath[HWM_MAX_FILE_PATH_LEN];       /**< [en]Indicates the CA certificate path
                                                         [cn]证书存储路径 
                                                         [cs_allowNull:Y] */
}VerifyParam;

typedef enum tagLoginChannelType
{
    CHANNEL_TYPE_NATIVE = 0,               /**< [en]Indicates native
                                           <br>[cn]原生模式 */
    CHANNEL_TYPE_SIGNAL_PROXY,             /**< [en]Indicates signal proxy
                                           <br>[cn]信令代理模式 */
    CHANNEL_TYPE_MIXED,                    /**< [en]Indicates mixed
                                           <br>[cn]混合模式 */
} LoginChannelType;

/**
 * 决策会管/会控/打点/非首跳登录等走自建代理还或公网地址.
 */
typedef enum tagNetworkAccessType
{
    ACCESS_TYPE_AUTO = 0,                 /**< [en]Indicates auto
                                          <br>[cn]默认值 */
    ACCESS_TYPE_INNER,                    /**< [en]Indicates inner
                                          <br>[cn]公司内网接入 */
    ACCESS_TYPE_OUTER,                    /**< [en]Indicates outter
                                          <br>[cn]公司外网接入 */
} NetworkAccessType;

/**
 * 决策mrc走vpn(内网)或公网.
 */
typedef enum tagNetConnectType {
    NET_CONNECT_AUTO = 0,         /**< [en]Indicates auto 
                                   <br>[cn]默认值，自动模式 */
    NET_CONNECT_FORCE_VPN,        /**< [en]Indicates force vpn
                                   <br>[cn]强制vpn(内网)模式 */
    NET_CONNECT_FORCE_DIRECT,     /**< [en]Indicates force direct connect
                                   <br>[cn]强制直连(公网)模式 */
}NetConnectType;

typedef struct tagNetWorkModeInfo {
    NetworkAccessType accessType;                       /**< [en]Indicates network access type . [cn]网络接入类型 */
    NetConnectType netConnectType;                           /**< [en]Is Forced Vpn . [cn]vpn模式 */
    HWM_CHAR accessAddr[HWM_MAX_URL_LEN];               /**< [en]Indicates access addr.[cn]接入地址 */
}NetWorkModeInfo;

/**
 * [cn] 接入网络地址类型
 */
typedef enum tagAccessAddrType {
    GLOBAL_PROXY,                   /**< [en]Indicates global proxy. [cn]全局代理. 用于usg接口 */
    REGION_PROXY,                   /**< [en]Indicates regin proxy. [cn]regin代理. 用于cms接口 */
    IM_PROXY,                       /**< [en]Indicates im proxy. [cn]im代理. 用于im接口 */
    HTTP_PROXY,                     /**< [en]Indicates http proxy. [cn]全局代理. 用于其它http接口 */
    OBS_PROXY,                      /**< [en]Indicates obs proxy. [cn]全局代理. 用于obs接口 */
}AccessAddrType;

/**
 * [cn] 接入网络地址类型
 */
typedef enum tagDeviceSleepState {
    DEVICE_SLEEP_AWAKENING,         /**< [en]Indicates awakening. [cn]唤醒 */
    DEVICE_SLEEP_SLEEPING,          /**< [en]Indicates sleeping. [cn]休眠 */
    DEVICE_SLEEP_UNKNOWN            /**< [en]Indicates unknow. [cn]未知 */
}DeviceSleepState;

END_HWM_SDK_NAMESPACE
#endif /* __HWM_NETWORK_SERVICE_DEF_H__ */

