﻿/**
 * @file HwmPrivateConfServiceShare.h
 *
 * Copyright(C), 2019-2020, Huawei Tech. Co., Ltd. ALL RIGHTS RESERVED.
 *
 * @brief Xxxxxx.
 */


#ifndef __HWM_PRIVATE_CONF_SERVICE_SHARE_H__
#define __HWM_PRIVATE_CONF_SERVICE_SHARE_H__


#import "HwmPrivateConfServiceDef.h"
#import "HwmPrivateConfServiceShareDef.h"
BEGIN_HWM_SDK_NAMESPACE

/**
* @brief [en]This class is about xxxx.
*        [cn]会议共享操作类回调
* @private
*/
class HWM_API IHwmPrivateConfShareResultCallback
{
public:
    /**
    * @brief [en] xxxxxx
    *        [cn] 共享前准备接口回调
    *
    * @param result [type:SDKERR]
    * [en]
    * [cn]错误码
    * @see SDKERR
    *
    * @param reasonDesc [type:HWM_CHAR*]
    * [en]
    * [cn]错误描述
    *
    * @android:disable
    * @ios:disable
    * @mac:disable
    * @win:disable
    *
    * @since:v1.0
    *
    * @UTCallback
    **/
    virtual HWM_VOID OnPrepareDataShareResult(SDKERR result, const HWM_CHAR* reasonDesc) {};
};

/**
  * @brief [en]This class is about xxxx.
  *        [cn]会议共享通知类回调
  * @private
  */
class HWM_API IHwmPrivateConfShareNotifyCallback
{
public:

    /**
    * @brief
    * [en]
    * [cn]共享停止通知
    *
    */
    virtual HWM_VOID OnShareStoppedNotify(const StopShareInfo* stopShareInfo) = 0;

    /**
    * @brief
    * [en]
    * [cn]错误通知
    *
    */
    virtual HWM_VOID OnDataShareErrorNotify(HWM_BOOL isSender, SDKERR errorCode) {};

    /**
    * @brief
    * [en]
    * [cn]标注状态通知
    */
    virtual HWM_VOID OnShareAnnoStatusChange(HWM_BOOL isOpenAnnotation) = 0;

    /**
    * @brief
    * [en]
    * [cn]新辅流标注状态通知
    */
    virtual HWM_VOID OnAuxAnnoStatusChange(HWM_UINT32 shareUserId, HWM_BOOL isOpenAnnotation) = 0;

    /**
    * @brief
    * [en]
    * [cn]正在共享通知
    */
    virtual HWM_VOID OnDataSharingNotify(const ScreenShareInfo* sharingInfo) = 0;

    /**
    * @brief
    * [en]
    * [cn]接收白板通知
    *
    */
    virtual HWM_VOID OnReceiveWhiteBoardNotify(const WhiteBoardInfo* wbInfo) = 0;

    /**
    * @brief
    * [en]
    * [cn]正在共享通知
    *
    */
    virtual HWM_VOID OnAuxDataSharingNotify(const ScreenShareInfoList* sharingInfoList) = 0;

    /**
    * @brief
    * [en]
    * [cn]停止白板的通知
    *
    *
    */
    virtual HWM_VOID OnStopWhiteBoardNotify(HWM_BOOL isSender) = 0;

    /**
    * @brief
    * [en]
    * [cn]白板数据通知
    *
    *
    */
    virtual HWM_VOID OnWhiteBoardRenderNotify() = 0;

    /**
    * @brief
    * [en]
    * [cn] 数据共享失败通知
    *
    */
    virtual HWM_VOID OnRecvDataShareFailedNotify() = 0;

    /**
    * @brief
    * [en]
    * [cn] 共享远程控制状态通知
    *
    * @android:disable
    * @ios:disable
    *
    */
    virtual HWM_VOID OnShareRemoteControlStatusNotify(const RemoteControlStatus* remoteStatus) = 0;

    /**
    * @brief
    * [en]
    * [cn] 数据会议成员名称变化
    *
    * @android:disable
    *
    */
    virtual HWM_VOID OnShareMemberNameChangeNotify(const DataMemberInfo* dataMemberInfo) = 0;

    /**
    * @brief
    * [en]
    * [cn] 数据会议通知离会
    *
    * @android:disable
    * @ios:disable
    *
    */
    virtual HWM_VOID OnShareConfLeaveNotify(HWM_UINT32 reason) = 0;

    /**
    * @brief
    * [en]
    * [cn] 程序共享遮挡窗口状态通知
    *
    * @android:disable
    * @ios:disable
    *
    */
    virtual HWM_VOID OnShareConfAppSharingStateNotify(HWM_HWND overlapWnd) = 0;

    /**
    * @brief
    * [en]
    * [cn] 内存不足共享失败通知
    *
    * @android:disable
    * @ios:disable
    *
    */
    virtual HWM_VOID OnShareOutOfMemoryNotify() = 0;

    /**
    * @brief
    * [en]
    * [cn] 加入共享结果通知
    *
    *
    */
    virtual HWM_VOID OnJoinConfShareNotify(SDKERR result, const HWM_CHAR* reasonDesc, HWM_UINT32 confHandle, HWM_BOOL isSupportShareStrategy, HWM_BOOL isAux) = 0;

    /**
    * @brief
    * [en]
    * [cn] 上报重连的结果
    *
    * @android:disable
    *
    */
    virtual HWM_VOID OnShareReconnectNotify(ShareReconnectState state) = 0;

    /**
    * @brief
    * [en]
    * [cn] 上报数据会议采集的状态
    *
    * @android:disable
    * @ios:disable
    * @mac:disable
    * @win:disable
    *
    */
    virtual HWM_VOID OnShareCaptureStateNotify(ShareCaptureState state, HWM_UINT32 code) {};

    /**
    * @brief
    * [en]
    * [cn] 主动共享时，用户选择屏幕
    *
    * @android:disable
    * @ios:disable
    * @mac:disable
    * @win:disable
    *
    */
    virtual HWM_VOID OnShareCaptureUserSelectDisplayNotify(HWM_UINT32 displayId) {};

    /**
    * @brief
    * [en]
    * [cn] 主动共享时，是否在共享窗口(app)
    *
    * @android:disable
    * @ios:disable
    * @mac:disable
    * @win:disable
    *
    */
    virtual HWM_VOID OnShareProgramsNotify(HWM_BOOL isSharePrograms) {};

    /**
    * @brief
    * [en]
    * [cn] UI或SDK发起共享结果通知
    *
    *
    */
    virtual HWM_VOID OnStartDataShareNotify(SDKERR result, const HWM_CHAR* reasonDesc, const ScreenShareInfo* appShareResultInfo) {};

    /**
    * @brief
    * [en]
    * [cn]UI或SDK发起白板结果通知
    *
    *
    */
    virtual HWM_VOID OnStartWhiteBoardNotify(SDKERR result, const HWM_CHAR* reasonDesc, const WhiteBoardInfo* wbInfo) {};

    /**
    * @brief
    * [en]
    * [cn]通知UI消息
    *
    * @android:disable
    * @ios:disable
    *
    */
    virtual HWM_VOID OnShareMessageNotify(DataConfNotifyMessageType messageType) {};

    /**
    * @brief
    * [en]
    * [cn]通知UI标注动他背景能力
    *
    * @android:disable
    * @ios:disable
    *
    */
    virtual HWM_VOID OnAnnoDynamicBackgroundNotify(HWM_BOOL enableAnnoDynamicBackground) {};


    /**
    * @brief
    * [en]
    * [cn]上报UI共享屏幕时接收方渲染失败错误码
    *
    * @android:disable
    * @ios:disable
    *
    */
    virtual HWM_VOID OnShareRenderScreenFailedNotify(SDKERR result) {};

    /**
    * @brief
    * [en]
    * [cn]开始动态标志通知
    */
    virtual HWM_VOID OnStartAnnotationNotify(StartAnnotationResult result, StartAnnotationResultRole role) {};

    /**
    * @brief
    * [en]
    * [cn]开始动态标志通知
    */
    virtual HWM_VOID OnAuxStartAnnotationNotify(StartAnnotationResult result, HWM_UINT32 userId) {};

    /**
    * @brief
    * [en]This class is about the notification of independent Annotation.
    * [cn]独立标注事件通知
    *
    * @param status[type:IndependentAnnoStatus]
    * [en]
    * [cn]状态
    * @see IndependentAnnoStatus
    * @param info[type:IndependentAnnoInfo*]
    * [en]
    * [cn]额外信息
    * @see IndependentAnnoInfo
    * @hook:notifyWithoutMainFrame
    * @android:disable
    * @ios:disable
    *
    * @since:v1.0
    */
    virtual HWM_VOID OnIndependentAnnoNotify(IndependentAnnoStatus status, const IndependentAnnoInfo* info) {};

    /**
   * @brief
   * [en]
   * [cn]数据会议变更通知
   *
   * @pc:disable
   *
   */
    virtual HWM_VOID OnScreenDataChangedNotify(HWM_UINT32 updateInfoSize, HWM_UINT32 dataSize) {};
    /**
    * @brief
    * [en]
    * [cn]数据会议接收共享分辨率变更通知
    *
    * @android:disable
    *
    */
    virtual HWM_VOID OnScreenSizeChangedNotify(const SizeInfo* sizeInfo) {};

    /**
    * @brief
    * [en]
    * [cn]数据会议接收共享分辨率变更通知
    *
    * @android:disable
    * @pc:disable
    *
    */
    virtual HWM_VOID OnSharingCodecTypeNotify(SharingCodecType type) {};


    /**
    * @brief
    * [en] Share capture type change
    * [cn] 共享采集类型变更通知
    *
    * @mobile:disable
    * @mac:disable
    *
    */
    virtual HWM_VOID OnShareCaptureTypeChange(ShareCaptureType capType) {};

    /**
    * @brief
    * [en]
    * [cn]通知共享加载窗口
    * @android:disable
    * @ios:disable
    * @mac:disable
    * @win:disable
    */
    virtual HWM_VOID OnDataShareLoadWindowNotify (const ScreenShareInfo* sharingInfo) {};

    /**
    * @brief
    * [en] Share capture type need switch notify
    * [cn] 共享采集失败,通知用户需要切换其他采集方式
    *
    * @mobile:disable
    * @mac:disable
    *
    */
    virtual HWM_VOID OnShareCaptureTypeNeedSwitchNotify() {};

    /**
    * @brief
    * [en] Share clear and smooth mode change notify
    * [cn]共享清晰且流畅模式变化通知
    */
    virtual HWM_VOID OnShareClearAndSmoothModeChangeNotify(HWM_BOOL isClearAndSmoothMode) {};

    /**
    * @brief
    * [en] Share Audio Notification
    * [cn] 共享音频结果通知.
    *
    */
    virtual HWM_VOID OnShareAudioNotify(SDKERR result, ShareAudioState shareAudioState) {};

    /**
    * @brief
    * [en]
    * [cn]接收共享第一帧通知
    */
    virtual HWM_VOID OnRecvKeyFrameNotify(const HWM_UINT32 userId) {};
};


/**
  * @brief [en]This class is about xxxx.
  *        [cn]会议共享对象
  * @private
  * @GetInstance
  *        HWM_SDK_NAMESPACE::HwmPrivateNativeSDK::GetPrivateConfShareApi()
  */
class IHwmPrivateConfShare
{
public:

    /**
    * @brief
    * [en]This class is about the global callback for the operating results of setting the conference share.
    * [cn]设置会议共享私有操作类全局回调
    */
    virtual SDKERR SetPrivateConfShareResultCallback(IHwmPrivateConfShareResultCallback* callback) = 0;

    /**
    * @brief
    * [en]This class is about the global callback for the notifications of conference share.
    * [cn]设置会议共享私有通知类全局回调
    */
    virtual SDKERR SetPrivateConfShareNotifyCallback(IHwmPrivateConfShareNotifyCallback* callback) = 0;

    /**
    * @brief
    * [en]
    * [cn] 移动端初始化数据会议参数
    *
    * @pc:disable
    *
    */
    virtual SDKERR InitDataConfParams(IN const MobileDataConfParams* params) { return SDKERR_SUCCESS; };

    /**
    * @brief
    * [en]
    * [cn] 设置共享渲染窗口
    *
    * @pc:disable
    *
    */
    virtual SDKERR SetSharePreview(IN HWM_UPTR view) { return SDKERR_SUCCESS; };

    /**
    * @brief
    * [en]
    * [cn] 移动端发起共享
    *
    * @pc:disable
    *
    */
    virtual SDKERR StartCastShare(IN const CastShareConfig* shareConfig) { return SDKERR_SUCCESS; };

    /**
    * @brief
    * [en]
    * [cn] 更新分辨率
    *
    * @pc:disable
    *
    */
    virtual SDKERR ChangeResolution(IN HWM_UINT32 width, IN HWM_UINT32 height) { return SDKERR_SUCCESS; };

    /**
    * @brief
    * [en]
    * [cn] 移动端发起共享
    *
    * @pc:disable
    * @android:disable
    *
    */
    virtual SDKERR UpdateViewDataInfo(IN const ViewDataInfo* dataInfo) { return SDKERR_SUCCESS; };

    /**
    * @brief
    * [en]
    * [cn] 移动端获取屏幕数据
    *
    * @pc:disable
    * @android:disable
    *
    */
    virtual SDKERR GetScreenData(IN const ScreenData* screenData) { return SDKERR_SUCCESS; };

    /*
    * @brief
    * [en]
    * [cn]当前是否在数据会议中
    *
    *
    */
    virtual HWM_BOOL IsDataInConf() = 0;

    /**
    * @brief
    * [en]This interface is used to start multi screen share
    * [cn]共享前准备(目前鸿蒙端采集权限申请是系统采集接口内部做的, 需要共享前调用)
    *
    * @android:disable
    * @ios:disable
    * @mac:disable
    * @win:disable
    * 
    */
    virtual SDKERR PrepareDataShare(IN const PrepareDataShareInfo* prepareDataShareInfo) = 0;

    /**
    * @brief
    * [en]This interface is used to start multi screen share
    * [cn]pc发起多屏共享
    *
    * @mobile:disable
    *
    */
    virtual SDKERR StartMultiScreenShare(IN HWM_HWND shareHwnd, IN HWM_UINT32 index, HWM_BOOL shareAudio, HWM_BOOL isQualityFirst) = 0;

    /*
    * @brief
    * [en]
    * [cn]停止共享
    *
    *
    */
    virtual SDKERR StopDataShare(HWM_VOID) = 0;

    /*
    * @brief
    * [en]
    * [cn]设置需要共享的程序
    *
    * @android:disable
    * @ios:disable
    *
    */
    virtual SDKERR SetSharingAppHwnd(HWM_UINT32 handle, HWM_HWND pAppWnd, HWM_BOOL action) = 0;

    /**
    * @brief
    * [en]This interface is used to start multi screen share
    * [cn]pc发起摄像头共享
    *
    * @mac:disable
    * @mobile:disable
    *
    */
    virtual SDKERR StartCameraShare(IN HWM_UINT32 index, HWM_BOOL shareAudio, HWM_BOOL isQualityFirst) = 0;

    /*
    * @brief
    * [en]
    * [cn]开启共享标注
    */
    virtual SDKERR StartDataShareAnnotation(HWM_UINT32 userId) = 0;

    /*
    * @brief
    * [en]
    * [cn]停止共享标注
    */
    virtual SDKERR StopDataShareAnnotation(HWM_UINT32 userId) = 0;

    /*
    * @brief
    * [en]
    * [cn]停止共享开关显示正在标注者的信息标注
    */
    virtual SDKERR SetShowAnnotatorName(HWM_BOOL bShow) = 0;

    /*
    * @brief
    * [en]
    * [cn]获取是否显示标注信息
    */
    virtual HWM_BOOL IsShowAnnotatorName(HWM_VOID) = 0;

    /*
    * @brief
    * [en]
    * [cn]获取当前页是否存在标注内容
    *
    * @android:disable
    * @ios:disable
    *
    */
    virtual HWM_BOOL IsExistAnnoDets(HWM_UINT32 userId) = 0;

    /*
    * @brief
    * [en]
    * [cn]发起白板共享
    *
    * @android:disable
    * @ios:disable
    *
    */
    virtual SDKERR StartWhiteBoard(IN HWM_UINT32 width, IN HWM_UINT32 height, IN HWM_BOOL isPrimaryMonitor, IN HWM_BOOL shareAudio, IN HWM_BOOL isQualityFirst) = 0;

    /*
    * @brief
    * [en]
    * [cn]停止白板共享
    *
    * @android:disable
    * @ios:disable
    *
    */
    virtual SDKERR StopDataWhiteBoard(HWM_VOID) = 0;

    /*
    * @brief
    * [en]
    * [cn]设置是否有远程控制白板共享能力
    *
    * @android:disable
    * @ios:disable
    *
    */
    virtual SDKERR SetRemoteControlCapacity(IN HWM_BOOL hasCapacity) = 0;

    /*
    * @brief
    * [en]
    * [cn]绑定共享显示窗口
    *
    * @android:disable
    * @ios:disable
    *
    */
    virtual SDKERR AttachHwnd(IN HWM_UINT32 userId, IN HWM_HWND renderHwnd) = 0;

    /*
    * @brief
    * [en]
    * [cn]解绑共享显示窗口
    *
    * @android:disable
    * @ios:disable
    *
    */
    virtual SDKERR DetachHwnd(HWM_UINT32 userId) = 0;

    /*
    * @brief
    * [en]
    * [cn]设置render视图大小
    *
    * @android:disable
    * @ios:disable
    *
    */
    virtual SDKERR SetRenderViewSize(HWM_UINT32 userId, HWM_INT32 width, HWM_INT32 height) = 0;

    /**
    * @brief
    * [en]This class is about set win prop.
    * [cn]设置window属性
    * @mobile:disable
    */
    virtual SDKERR InputWindowMsg(IN HWM_UINT32 userId, IN HWM_UINT32 msgType, IN HWM_ULONG wparam, IN HWM_LONG lparam) = 0;

    /*
    * @brief
    * [en]
    * [cn]设置渲染时是否原始大小显示，偏移量
    *
    * @android:disable
    * @ios:disable
    *
    */
    virtual SDKERR SetShareRenderPaintProp(HWM_UINT32 userId, HWM_BOOL isDrawOrigin, HWM_INT32 offsetX, HWM_INT32 offsetY) = 0;

    /**
    * @brief
    * [en]This class is about getting share render paint prop.
    * [cn]获取渲染时是否原始大小显示，偏移量
    * @mobile:disable
    * @android:disable
    * @ios:disable
    * @paramOut
    */
    virtual SDKERR GetShareRenderPaintProp(IN HWM_UINT32 userId, OUT RenderPaintPropInfo* paintPropInfo) = 0;

    /**
    * @brief
    * [en]This class is about getting sharer monitor PPI.
    * [cn]获取远端设备PPI
    * @android:disable
    * @paramOut
    */
    virtual SDKERR GetSharerMonitorPPI(IN HWM_UINT32 userId, OUT PPIInfo* ppiInfo) = 0;

    /*
    * @brief
    * [en]
    * [cn]获取动态标注背景能力
    *
    * @android:disable
    * @ios:disable
    *
    */
    virtual HWM_BOOL GetAnnoDynamicBackGroundAbility() = 0;

    /**
     * 获取本远端缩放比
     * @paramOut
     * @mobile:disable
     * @android:disable
     * @ios:disable
     * @paramOut
     */
    virtual SDKERR GetShareViewFactor(IN HWM_UINT32 userId, OUT HWM_FLOAT* viewFactor) = 0;

    /*
    * @brief
    * [en]
    * [cn]请求远程控制当前共享与会者的桌面
    *
    * @android:disable
    * @ios:disable
    *
    */
    virtual SDKERR ReqRemoteControl(IN HWM_UINT32 dataUserId) = 0;

    /*
    * @brief
    * [en]
    * [cn]主动授予或收到请求时授予
    *
    * @android:disable
    * @ios:disable
    *
    */
    virtual SDKERR GrantRemoteControl(IN HWM_UINT32 dataUserId, IN HWM_BOOL isGrant) = 0;

    /*
    * @brief
    * [en]
    * [cn]拒绝远程控制
    *
    * @android:disable
    * @ios:disable
    *
    */
    virtual SDKERR RejectRemoteControl(IN HWM_UINT32 dataUserId) = 0;

    /*
    * @brief
    * [en]
    * [cn]回收远程控制
    *
    * @android:disable
    * @ios:disable
    *
    */
    virtual SDKERR RevokeRemoteControl(IN HWM_UINT32 dataUserId) = 0;

    /*
    * @brief
    * [en]
    * [cn]数据会议心跳接口
    *
    * @android:disable
    * @ios:disable
    *
    */
    virtual HWM_VOID HeartBeat() = 0;

    /*
    * @brief
    * [en]
    * [cn]设置指定窗口透明属性
    *
    * @android:disable
    * @ios:disable
    *
    */
    virtual SDKERR SetTransparentWindow(HWM_UPTR  hwnd, HWM_BOOL isTransparent) = 0;

    /*
    * @brief
    * [en]
    * [cn]设置共享策略,质量优先还是流畅性优先
    *
    * @android:disable
    * @ios:disable
    *
    */
    virtual SDKERR SetShareQualityStrategy(HWM_BOOL isQualityFirst) = 0;

    /*
    * @brief
    * [en]
    * [cn]设置是否开启音频共享
    *
    * @android:disable
    * @ios:disable
    *
    */
    virtual SDKERR SetShareAudio(IN HWM_BOOL isOpen) = 0;

    /*
    * @brief
    * [en]
    * [cn]设置检测电脑声音阈值
    *
    * @android:disable
    * @ios:disable
    *
    */
    virtual SDKERR SetBGMDetectSensitivity(IN HWM_UINT32 level) = 0;

    /*
    * @brief
    * [en]
    * [cn]开始检测电脑声音
    *
    * @android:disable
    * @ios:disable
    *
    */
    virtual SDKERR StartBGMDetect() = 0;

    /*
    * @brief
    * [en]
    * [cn]停止检测电脑声音
    *
    * @android:disable
    * @ios:disable
    *
    */
    virtual SDKERR StopBGMDetect() = 0;

    /**
    * @brief
    * [en]This class is about set pen info.
    * [cn]设置画笔
    */
    virtual SDKERR SetPen(IN const PenInfo* penInfo) = 0;

    /**
    * @brief
    * [en]This class is about set brush info.
    * [cn]设置笔刷
    */
    virtual SDKERR SetBrush(IN const BrushInfo* brushInfo) = 0;

    /**
    * @brief
    * [en]This class is about start draw annotation.
    * [cn]进行标注划线
    */
    virtual SDKERR DrawAnnotationStart(IN HWM_UINT32 userId, IN const PointInfo* point) = 0;

    /**
    * @brief
    * [en]This class is about update draw annotation.
    * [cn]更新标注
    */
    virtual SDKERR DrawAnnotationUpdate(IN HWM_UINT32 userId, IN const PointInfo* point) = 0;

    /**
    * @brief
    * [en]This class is about finish draw annotation.
    * [cn]完成标注
    */
    virtual SDKERR DrawAnnotationDone(IN HWM_UINT32 userId) = 0;

    /**
    * @brief
    * [en]This interface is used to set annot follow ppt screening cap.
    * [cn]设置标注跟随PPT放映能力
    * @mobile:disable
    */
    virtual SDKERR SetAnnoFollowPptScreening(HWM_BOOL enable) = 0;

    /**
    * @brief
    * [en]This interface is used to create a new page in a appointed document.
    * [cn]在指定的文档中新建页
    * @mobile:disable
    * @mac:disable
    */
    virtual SDKERR CreateNewPage(HWM_UINT32 userId, ComponentIID ciid, HWM_UINT32 docID, HWM_INT32 pageWidth, HWM_INT32 pageHeight, OUT HWM_UINT32* pageId) = 0;

    /**
    * @brief
    * [en]This interface is used to delete appointed page of appointed document.
    * [cn]删除指定文档中的指定页面
    * @mobile:disable
    */
    virtual SDKERR DeletePage(HWM_UINT32 userId, ComponentIID ciid, HWM_UINT32 docID, HWM_UINT32 pageId) = 0;

    /**
    * @brief
    * [en]This interface is used to set the current page.
    * [cn]设置当前显示的页面
    * @mobile:disable
    */
    virtual SDKERR SetCurrentPage(HWM_UINT32 userId, ComponentIID ciid, HWM_UINT32 docID, HWM_UINT32 pageId, HWM_BOOL sync) = 0;
    
    /**
    * @brief
    * [en]This interface is used to get current page id in a appointed document.
    * [cn]获取指定文档的当前页
    * @mobile:disable
    * @mac:disable
    */
    virtual SDKERR GetCurrentPage(HWM_UINT32 userId, ComponentIID ciid, HWM_UINT32 docID, OUT HWM_UINT32* pageId) = 0;

    /**
    * @brief
    * [en]This class is about finish draw annotation.
    * [cn]完成标注
    */
    virtual SDKERR DrawAnnotationDoneNew(HWM_UINT32 userId, HWM_BOOL bCancel) = 0;

    /**
    * @brief
    * [en]This class is about test rect annotation.
    * [cn]测试矩形点阵
    * @android:disable
    * @paramOut
    */
    virtual SDKERR HitTestRectAnnotation(IN HWM_UINT32 userId, IN const HitTestRectParam* hitTestRect, OUT AnnotationSet *annotationIdSet) = 0;

    /**
    * @brief
    * [en]This class is about test line annotation.
    * [cn]测试线条点阵
    * @android:disable
    * @paramOut
    */
    virtual SDKERR HitTestLineAnnotation(IN HWM_UINT32 userId, IN const HitTestLineParam* hitTestLine, OUT AnnotationSet *annotationIdSet) = 0;

    /**
    * @brief
    * [en]This class is about erase annotation.
    * [cn]擦除标注
    * @android:disable
    */
    virtual SDKERR EraseAnnotation(IN const AnnotationSet *annotationIdSet) = 0;
    /* 保存图片 */
    virtual SDKERR SavePic(IN HWM_UINT32 userId, IN const HWM_CHAR* fileName) = 0;

	/**
	* @brief
	* [en]This class is about erase area annotation.
	* [cn]擦除指定区域内标注
	* @android:disable
	*/
	virtual SDKERR EraseAreaAnnotation(IN HWM_UINT32 userId, IN const EraseAreaAnnoParam* param) { return SDKERR_SUCCESS; };
    
    /**
    * @brief
    * [en]This class is used to set the data callback function.
    * [cn]设置数据共享数据回调函数
    * @mobile:disable
    * @mac:disable
    */
    virtual SDKERR SetDataCallback(IN data_multi_callback callback) = 0;

    /**
    * @brief
    * [en]This class is about erase annotation.
    * [cn]擦除标注
    * @mobile:disable
    */
    virtual SDKERR SaveAnnoPic(IN const AnnoWaterMarkItem* waterMark) = 0;

    /**
       * @brief
       * [en]This class is about clear annotation.
       * [cn]清除标注
       */
    virtual SDKERR ClearAnnotation(HWM_UINT32 userId) { return SDKERR_SUCCESS; };

    /**
    * @brief
    * [en]This class is about set whiteboard canvas size.
    * [cn]设置白板画布大小
    * @mobile:disable
    */
    virtual SDKERR SetWhiteboardCanvasSize(IN const SizeInfo* size) = 0;

    /**
    * @brief
    * [en]This class is about set whiteboard origin.
    * [cn]设置白板原点
    * @mobile:disable
    */
    virtual SDKERR SetWhiteboardOrigin(IN const SizeInfo* size) = 0;

    /**
    * @brief
    * [en]This class is about set whiteboard page info.
    * [cn]设置白板页面信息
    * @paramOut
    * @android:disable
    */
    virtual SDKERR GetWhiteboardPageInfo(OUT PageInfo* pageInfo) = 0;

    /**
    * @brief
    * [en]This class is about lock whiteboard surface.
    * [cn]锁定白板渲染缓存区
    * @paramOut
    * @android:disable
    */
    virtual SDKERR LockWhiteboardSurface(OUT WhiteboardSurfaceInfo* whiteboardSurfaceInfo) = 0;
    /*解锁白板渲染缓存区*/
    virtual SDKERR UnlockWhiteboardSurface() = 0;

    /**
    * @brief
    * [en]This class is about lock whiteboard surface.
    * [cn]获取白板渲染缓存区
    * @paramOut
    * @android:disable
    * @pc:disable
    */
    virtual SDKERR GetWhiteboardSurface(OUT WhiteboardSurfaceInfo* whiteboardSurfaceInfo) = 0;

    /**
    * @brief
    * [en]This class is about getting share conf member list.
    * [cn]获取数据会议成员列表
    * @mobile:disable
    * @synchronized
    * @paramOut
    */
    virtual SDKERR GetDataMemberList(OUT HwmList<DataMemberInfo>* memList) = 0;

    /**
     * 获取数据会议与会者人数
     * @paramOut
     * @mobile:disable
     * @paramOut
     */
    virtual SDKERR GetDataMemberCount(OUT HWM_UINT32* len) = 0;

    /**
    * @brief
    * [en]This class is about data share window
    * [cn]数据会议共享界面观看情况
    * @param isWatching [type:HWM_BOOL]
    * [en] indicate user is watching data share window or not
    * [cn] 是否在看数据会议共享界面
    * @param resolutionLevel [type:GeneralWatchResolutionLevel]
    * [en] indicate resolution level of data share window
    * [cn]选看数据会议窗口分辨率
    * @see GeneralWatchResolutionLevel
    * @mobile:disable
    * @return [type:SDKERR]
    *
    * @since:v1.0
    */
    virtual SDKERR SetDataShareWatchParam(IN HWM_BOOL isWatching, IN GeneralWatchResolutionLevel resolutionLevel) = 0;

    /**
    * @brief
    * [en]
    * [cn]设置数据会议帧率
    *
    * @param frameRate [type:HWM_UINT32][cs_allowNull:N]
    * [en]
    *
    * @return [type:SDKERR]
    * @mac:disable
    *
    * @UTInterface:start
    */
    virtual SDKERR SetConfFrameRate(IN HWM_UINT32 frameRate) { return SDKERR_SUCCESS; };

    /**
   * @brief
   * [en]
   * [cn]设置数据会议线程数据，目前win大屏用
   *
   * @param threadNum [type:HWM_UINT32][cs_allowNull:N]
   * [en]
   *
   * @return [type:SDKERR]
   * @android:disable
   * @ios:disable
   * @mac:disable
   *
   * @UTInterface:start
   */
    virtual SDKERR SetDataConfThreadInfo(IN const DataConfThreadInfo* threadInfo) { return SDKERR_SUCCESS; };

    /**
   * @brief
   * [en]
   * [cn]开启独立标注
   *
   * @param startAnnoInfo [type:IndependentStartAnnoInfo]
   * @see IndependentStartAnnoInfo
   *
   *
   * @return [type:SDKERR]
   * @android:disable
   * @ios:disable
   */
    virtual SDKERR StartIndependentAnno(const IndependentStartAnnoInfo* startAnnoInfo) { return SDKERR_SUCCESS; };

    /**
    * @brief
    * [en]This class is stop independent annotation.
    * [cn]停止标注
    * @return [type:SDKERR]
    * @mobile:disable
    */
    virtual SDKERR StopIndependentAnno(HWM_VOID) { return SDKERR_SUCCESS; };

    /**
    * @brief
    * [en]This class is about attach independent Wnd.
    * [cn]附加窗口
    * @return [type:SDKERR]
    * @mobile:disable
    */
    virtual SDKERR AttachIndependentAnnoWnd(HWM_HWND shareHwnd) { return SDKERR_SUCCESS; };

    /**
    * @brief
    * [en]Set the device information to be displayed..
    * [cn]更新共享设备显示信息(共享过程中调用)
    * @return [type:SDKERR]
    * @ios:disable
    * @mac:disable
    * @android:disable
    */
    virtual SDKERR UpdateSharingDisplayInfo(const DisplayInfo* displayInfo) { return SDKERR_SUCCESS; };

    /**
    * @brief
    * [en]Set data share skip privacy window id info
    * [cn]设置共享采集相关的豁免隐私窗口信息
    * @return [type:SDKERR]
    * @ios:disable
    * @mac:disable
    * @android:disable
    */
    virtual SDKERR SetSkipPrivacyWindowIds(const SkipPrivacyWindowIdInfo* info) { return SDKERR_SUCCESS; };

    /**
    * [en]This function is about.
    * [cn]设置屏幕共享或应用程序共享相关参数
    * @return [type:SDKERR]
    * @mobile:disable
    */
    virtual SDKERR TupConfAsSetparam(IN HWM_UINT32 handle, IN ScreenData* param) { return SDKERR_SUCCESS; };

    /**
    * @brief
    * [en]This function is about annotation rendering.
    * [cn]标注窗口渲染
    * @return [type:SDKERR]
    * @mobile:disable
    */
    virtual SDKERR PaintAnnotation(HWM_VOID) = 0;

    /**
    * @brief
    * [en]This function is used to force refresh frame in watching side during sharing.
    * [cn]共享时，在观看端强制刷新一帧
    * @return [type:SDKERR]
    * @mobile:disable
    */
    virtual SDKERR FlushScreendata(HWM_UINT32 userId) = 0;

    /**
    * @brief
    * [en]This function is used to set canvas background color of document sharing module.
    * [cn]设置文档共享模块画布的背景色
    * @return [type:SDKERR]
    * @mobile:disable
    */
    virtual SDKERR SetBgcolor(IN ComponentIID ciid, IN HWM_UINT32 bgColor) = 0;

    /**
    * @brief
    * [en]This function is used to set canvas background color of white board sharing module.
    * [cn]设置白板共享模块当前页的背景色
    * @return [type:SDKERR]
    * @mobile:disable
    */
    virtual SDKERR SetPageBgcolor(IN BgColor* bgColor) = 0;

    /**
    * @brief
    * [en]This function is used to set zoom of document.
    * [cn]设置文档的缩放
    * @return [type:SDKERR]
    * @mobile:disable
    */
    virtual SDKERR SetZoom(IN DsZoom* dsZoom) = 0;

    /**
    * @brief
    * [en]This function is about.
    * [cn]新建一个空的白板文档
    * @return [type:SDKERR]
    * @mobile:disable
    */
    //virtual SDKERR TupConfDsNewDoc(IN HWM_UINT32 handle, IN ComponentIID ciid, OUT HWM_UINT32* ret_docid) { return SDKERR_SUCCESS; };

    /* 获取指定页面的信息 */
    /**
    * @brief
    * [en]This function is about.
    * [cn]获取指定页面的信息
    * @return [type:SDKERR]
    * @mobile:disable
    */
    //virtual SDKERR TupConfDsGetPageinfo(IN HWM_UINT32 handle, IN ComponentIID ciid, IN HWM_UINT32 docid, IN HWM_UINT32 pageid, OUT HwmAuxDsPageInfo* pageinfo) { return SDKERR_SUCCESS; };

    /**
    * @brief
    * [en]This function is about.
    * [cn]文档的单页内容保存成JPEG图片
    * @return [type:SDKERR]
    * @mobile:disable
    */
    virtual SDKERR  TupConfDsSaveasPictureex(IN HWM_UINT32 handle, IN ComponentIID ciid, IN HWM_UINT32 docid, IN HWM_UINT32 pageid, IN const HWM_CHAR* filename, HwmAuxAnnoWaterMarkItem* waterMark) { return SDKERR_SUCCESS; };

    /**
    * @brief
    * [en]This function is about.
    * [cn]锁定文档页面数据
    * @return [type:SDKERR]
    * @mobile:disable
    */
    //virtual HWM_VOID* TupConfDsLockSurfacebmp(IN HWM_UINT32 handle, IN ComponentIID ciid, OUT HWM_UINT32* width, OUT HWM_UINT32* height) { return nullptr; };

    /**
    * @brief
    * [en]This function is about.
    * [cn]设置数据共享数据回调函数
    * @return [type:SDKERR]
    * @mobile:disable
    */
    //virtual SDKERR TupConfSetDataCallback(IN HWM_VOID* callback, IN HWM_UINT32 handle) { return SDKERR_SUCCESS; };

    /**
    * @brief
    * [en]This function is about.
    * [cn]屏幕共享中，观看端加入某个数据通道
    * @return [type:SDKERR]
    * @mobile:disable
    */
    virtual SDKERR TupConfAsAttach(IN HWM_UINT32 handle, IN HWM_UINT32 userId, IN HWM_INT32 channel_type, IN HWM_HWND hwnd, IN RenderMode render_mode) { return SDKERR_SUCCESS; };

    /**
    * @brief
    * [en]This function is about.
    * [cn]设置数据共享数据回调函数
    * @return [type:SDKERR]
    * @mobile:disable
    * @mac:disable
    */
    virtual SDKERR TupConfSetDataCallback(IN HWM_VOID* callback, IN HWM_UINT32 handle) { return SDKERR_SUCCESS; };

    /**
    * @brief
    * [en]This function is about.
    * [cn]设置数据共享数据窗口属性
    * @return [type:SDKERR]
    * @mobile:disable
    * @mac:disable
    */
    virtual SDKERR TupConfAnnoSetWindowAttr(IN HWM_UINT32 handle, IN HWM_UINT32 userId, IN HWM_INT32 ciid, IN HWM_INT32 eAttributeType) { return SDKERR_SUCCESS; };


    /**
    * @brief
    * [en]This function is about.
    * [cn]设置数据共享数据窗口消息
    * @return [type:SDKERR]
    * @mobile:disable
    * @mac:disable
    */
    virtual SDKERR SetShareCaptureType(IN ShareCaptureType shareCaptureType) { return SDKERR_SUCCESS; };

    /**
    * @brief
    * [en]This function is about get share capture type.
    * [cn]获取共享采集模式
    * @return [type:SDKERR]
    * @mobile:disable
    * @mac:disable
    */
    virtual SDKERR GetShareCaptureType(OUT ShareCaptureType* pShareCaptureType) { return SDKERR_SUCCESS; };

    /**
    * @brief
    * [en]This function is about get share capture type list.
    * [cn]获取共享采集模式列表
    * @param supportCaptureTypeList [type:HwmList<ShareCaptureType>][cs_allowNull:N]
    * @return [type:SDKERR]
    * @mobile:disable
    * @mac:disable
    */
    virtual SDKERR GetShareCaptureTypeList(OUT HwmList<ShareCaptureType>* supportCaptureTypeList) { return SDKERR_SUCCESS; };

    /**
    * @brief
    * [en]This function is about set share strategy.
    * [cn]设置数据共享策略
    * @return [type:SDKERR]
    * @mobile:disable
    */
    virtual SDKERR SetShareStrategy(IN HwmShareStrategy shareStrategy) { return SDKERR_SUCCESS; };

    /**
    * @brief
    * [en]This function is about share data render frame mode.
    * [cn]设置数据共享渲染模式
    * @return [type:SDKERR]
    */
    virtual SDKERR SetShareRenderFrameMode(IN ShareRenderFrameMode shareRenderFrameMode) { return SDKERR_SUCCESS; };

    /**
    * @brief
    * [en]This function is used to set whether filter share window.
    * [cn]设置数据共享是否过滤窗口
    * @return [type:SDKERR]
    */
    virtual SDKERR SetIsFilterShareWnd(IN HWM_BOOL bFilterShareWnd) { return SDKERR_SUCCESS; };

    /**
    * @brief
    * [en]This function is used to get whether filter share window.
    * [cn]读取数据共享是否过滤窗口
    * @return [type:HWM_BOOL]
    */
    virtual HWM_BOOL IsFilterShareWnd() { return HWM_FALSE; };

    /**
    * @brief
    * [en]This function is used to get whether clear and smooth mode.
    * [cn]是否高清流畅模式
    * @return [type:HWM_BOOL]
    */
    virtual HWM_BOOL IsClearAndSmoothMode() { return HWM_FALSE; };

    /**
    * @brief
    * [en]This function is used to update share cursor capture status.
    * [cn]更新鼠标采集状态
    * @return [type:HWM_BOOL]
    * @mobile:disable
    */
    virtual SDKERR UpdateAnnotCursorCaptureStatus(IN HWM_BOOL bPauseCursorCapture) { return SDKERR_SUCCESS; };

    /**
    * @brief
    * [en]This function is about response annotation request for android.
    * [cn]获取共享采集模式列表
    * @param errCode [type:HWM_UINT32][cs_allowNull:N]
    * @return [type:SDKERR]
    * @pc:disable
    * @ios:disable
    */
    virtual SDKERR ResponseAnnotationRequest(HWM_UINT32 errCode) { return SDKERR_SUCCESS; };
};

END_HWM_SDK_NAMESPACE
#endif /* __HWM_CONF_SERVICE_SHARE_H__ */

