﻿/**
 * @file HwmConfServiceDef.h
 *
 * Copyright(C), 2019-2020, Huawei Tech. Co., Ltd. ALL RIGHTS RESERVED.
 *
 * @brief Xxxxxx.
 */


#ifndef __HWM_PRIVATE_CONF_SERVICE_SHARE_DEF_H__
#define __HWM_PRIVATE_CONF_SERVICE_SHARE_DEF_H__

#import "HwmConfServiceDef.h"
#import "HwmConfServiceShareDef.h"

BEGIN_HWM_SDK_NAMESPACE

/**
 * [en]This enumeration is used to describe the pen styles.
 * [cn]画笔样式
 */
typedef enum tagPenStyle
{
    PEN_STYLE_SOLID = 0,      /**< [en]Indicates the entity pen.
                                                     [cn]实体笔
                                                     [ios:rename:Solid] */
    PEN_STYLE_DASH,           /**< [en]Indicates the dash pen.
                                                     [cn]虚线笔
                                                     [ios:rename:Dash] */
    PEN_STYLE_DOT,            /**< [en]Indicates the dot pen.
                                                     [cn]点笔
                                                     [ios:rename:Dot] */
    PEN_STYLE_DASH_DOT,       /**< [en]Indicates the dash dot pen.
                                                     [cn]虚线点笔
                                                     [ios:rename:DashDot] */
    PEN_STYLE_DASH_DOT_DOT,   /**< [en]Indicates the dash dot dot pen.
                                                     [cn]虚线点点笔
                                                     [ios:rename:DashDotDot] */
    PEN_STYLE_ORDINARY,       /**< [en]Indicates an ordinary pen.
                                                     [cn]普通画笔
                                                     [ios:rename:Ordinary] */
    PEN_STYLE_INSIDE_FRAME,   /**< [en]Indicates the inside frame pen.
                                                     [cn]内框笔
                                                     [ios:rename:InsideFrame] */
    PEN_STYLE_USER_STYLE,     /**< [en]Indicates the user to customize the pen.
                                                     [cn]用户自定义笔
                                                     [ios:rename:UserStyle] */
    PEN_STYLE_ALTERNATE,      /**< [en]Indicates the alternate pen.
                                                     [cn]间隔线笔
                                                     [ios:rename:Alternate] */
    PEN_STYLE_BUTT            /**< [ios:rename:Butt] */
}PenStyle;


/**
 * [en]This enumeration is used to describe the brush styles.
 * [cn]画刷样式
 */
typedef enum tagBrushStyle
{
    BRUSH_NULL = 0,       /**< [en]Indicates empty brush.
                                                 [cn]空画刷
                                                 [ios:rename:Null] */
    BRUSH_SOLID,          /**< [en]Indicates solid brush.
                                                 [cn]实体画刷
                                                 [ios:rename:Solid] */
    BRUSH_GRADIENT,       /**< [en]Indicates gradient brush.
                                                 [cn]渐变画刷
                                                 [ios:rename:Gradient] */
    BRUSH_HATCH,          /**< [en]Indicates hatch brush.
                                                 [cn]阴影画刷
                                                 [ios:rename:Hatch] */
    BRUSH_PATTERN,        /**< [en]Indicates pattern brush.
                                                 [cn]图形画刷
                                                 [ios:rename:Pattern] */
    BRUSH_BUTT            /**< [ios:rename:Butt] */
}BrushStyle;



/**
 * [en]This enumeration is used to describe annotation hit test mode.
 * [cn]标注的点击测试模式
 */
typedef enum tagHitTestMode
{
    HIT_TEST_ALL = 0,           /**< [en]Indicates all annotation in the region
                                                       [cn]区域内的全部标注
                                                       [ios:rename:All] */     //[注意]tup的起始值为1
    HIT_TEST_OTHERS,            /**< [en]Indicates all annotation except someone
                                                       [cn]除某人外的全部标注
                                                       [ios:rename:Others] */
    HIT_TEST_SOMEONE,           /**< [en]Indicates someone's annotation
                                                       [cn]某人的标注
                                                       [ios:rename:Someone] */
    HIT_TSET_MODE_BUTT          /**< [ios:rename:Butt] */
}HitTestMode;

/**
* [en]This enumeration is used to describe start app share result.
* [cn]程序共享结果
* @mobile:disable
*/
typedef struct tagStartAppShareResultInfo
{
    HWM_BOOL allowSetShareStrategy;         /**< [en]Indicates xxxx.
                                                 [cn]是否允许设置共享策略 */
    AttendeeInfo shareOwner;             /**< [en]Indicates xxxx.
                                                 [cn]共享Owner，理论上不需要此字段，待确认后若无需要再删除 */
}StartAppShareResultInfo;

/**
* [en]This struct is used to describe start monitor share result.
* [cn]屏幕共享结果
* @mobile:disable
*/
typedef struct tagStartMonitorShareResultInfo
{
    HWM_BOOL allowSetShareStrategy;         /**< [en]Indicates xxxx.
                                                 [cn]是否允许设置共享策略 */
    AttendeeInfo shareOwner;             /**< [en]Indicates xxxx.
                                                 [cn]共享Owner，理论上不需要此字段，待确认后若无需要再删除 */
}StartMonitorShareResultInfo;

/**
* [en]This struct is used to describe start app share param.
* [cn]程序共享参数
* @mobile:disable
*/
typedef struct tagAppSharingInfo
{
    AttendeeInfo owner;                  /**< [en]Indicates xxxx.
                                                 [cn]共享Owner */
    ClientDeviceType deviceType;                  /**< [en]Indicates xxxx.
                                                 [cn]共享设备类型 */ //TODO 需要确认包含哪些类型，需要定义一个枚举
    HWM_INT32 originalWidth;                /**< [en]Indicates xxxx.
                                                 [cn]共享侧图像原始宽度 */
    HWM_INT32 originalHeight;               /**< [en]Indicates xxxx.
                                                 [cn]共享侧图像原始高度 */
    HWM_BOOL allowSetShareStrategy;         /**< [en]Indicates xxxx.
                                                 [cn]是否允许设置共享策略 */
    HWM_BOOL allowAnnotation;               /**< [en]Indicates xxxx.
                                                 [cn]是否允许标注 */
    HWM_BOOL hasAnnotation;                 /**< [en]Indicates xxxx.
                                                 [cn]是否有标注在共享中 */
}AppSharingInfo;

/**
* [en]This enumeration is used to describe sharing info.
* [cn]屏幕共享通知
* @mobile:disable
*/
typedef struct tagMonitorSharingInfo
{
    AttendeeInfo owner;                  /**< [en]Indicates xxxx.
                                                 [cn]共享Owner */
    HWM_UINT32 deviceType;                  /**< [en]Indicates xxxx.
                                                 [cn]共享设备类型 */ //TODO 需要确认包含哪些类型，需要定义一个枚举
    HWM_INT32 originalWidth;                /**< [en]Indicates xxxx.
                                                 [cn]共享侧图像原始宽度 */
    HWM_INT32 originalHeight;               /**< [en]Indicates xxxx.
                                                 [cn]共享侧图像原始高度 */
    HWM_BOOL allowSetShareStrategy;         /**< [en]Indicates xxxx.
                                                 [cn]是否允许设置共享策略 */
    HWM_BOOL allowRemoteCtrl;               /**< [en]Indicates xxxx.
                                                 [cn]是否允许远程控制 */
    HWM_BOOL allowAnnotation;               /**< [en]Indicates xxxx.
                                                 [cn]是否允许标注 */
    HWM_BOOL hasAnnotation;                 /**< [en]Indicates xxxx.
                                                 [cn]是否有标注在共享中 */
}MonitorSharingInfo;

/**
* [en]This enumeration is used to describe board sharing info.
* [cn]白板共享信息
* @mobile:disable
*/
typedef struct tagWhiteBoardSharingInfo
{
    AttendeeInfo owner;                  /**< [en]Indicates xxxx.
                                                 [cn]共享Owner */
}WhiteBoardSharingInfo;

/**
* [en]This structure is used to describe remote control type.
* [cn]远程控制类型
* @mobile:disable
*/
typedef enum tagRemoteControlType
{
    REMOTE_CONTROL_GET = 0,   //获得别人的共享权限
    REMOTE_CONTROL_DEL,       //权限释放
    REMOTE_CONTROL_BE_REJECT, //申请权限被拒绝
    REMOTE_CONTROL_REQUEST    //请求权限
}RemoteControlType;

/**
* [en]This structure is used to describe the remote control status information.
* [cn]远程控制状态信息
* @mobile:disable
*/
typedef struct tagRemoteControlStatusInfo
{
    RemoteControlType msgType;
    AttendeeInfo peerInfo;
} RemoteControlStatusInfo;



/**
 * [en]This structure is used to describe the application window information.
 * [cn]应用程序窗口信息
 * @mobile:disable
 */
typedef struct tagAppWndInfo
{
    HWM_HWND hwnd;                                       /**< [en]Indicates the application window handle.
                                                                         [cn]应用程序窗口句柄 */
    HWM_WCHAR title[HWM_MAX_APP_WND_TITLE_LEN];                                      /**< [en]Indicates the window title.
                                                                         [cn]窗口名称 */ //TBD:为什么是U16的，是否可以转换UTF-8 的CHAR
    HWM_PTR smallIconHwnd;                                   /**< [en]Indicates the icon handle.
                                                                         [cn]ICON图标Handle */
}AppWndInfo;

/**
* [en]This structure type is used to describe the collection of app wnd info.
* [cn]程序列表信息
* @mobile:disable
*/
typedef struct tagAppWndSet
{
    HWM_UINT32 numOfAppWndInfo;

    AppWndInfo appWndInfos[HWM_MAX_APP_WND_NUM];

}AppWndSet;

/**
 * [en]This structure type is used to describe the definition of a generic point.
 * [cn]通用点的定义
 */
typedef struct tagPointInfo
{
    HWM_INT32 x;                                                   /**< [en]Indicates the x coordinate.
                                                                         [cn]x坐标 */
    HWM_INT32 y;                                                   /**< [en]Indicates the x coordinate.
                                                                         [cn]y坐标*/
}PointInfo;


/**
 * [en]This structure type is used to describe the generic size definition.
 * [cn]通用尺寸定义
 */
typedef struct tagSizeInfo
{
    HWM_INT32 width;                                               /**< [en]Indicates the width.
                                                                        [cn]宽 */
    HWM_INT32 height;                                              /**< [en]Indicates height.
                                                                        [cn]高*/
    HWM_BOOL redraw;                                               /**< [en]Indicates whether to redraw right now.
                                                                        [cn]是否立刻重绘，取值: true 重绘, false 不重绘*/
}SizeInfo;


/**
 * [en]This structure is used to describe the rectangular definition (top, bottom, left and right coordinates).
 * [cn]矩形定义 （上下左右坐标表示）
 */
typedef struct tagRectInfo
{
    HWM_INT32 left;                                                /**< [en]Indicates the x coordinate of the left side of the rectangle.
                                                                         [cn]矩形左侧x坐标 */
    HWM_INT32 top;                                                 /**< [en]Indicates the top y coordinate of the rectangle.
                                                                         [cn]矩形顶部y坐标 */
    HWM_INT32 right;                                               /**< [en]Indicates the x coordinate of the right side of the rectangle.
                                                                         [cn]矩形右侧x坐标 */
    HWM_INT32 bottom;                                              /**< [en]Indicates the lower y coordinate of the rectangle.
                                                                         [cn]矩形下部y坐标 */
}RectInfo;

/**
* [en]This structure is used to describe the pen width level.
* [cn]画笔宽度等级
*/
typedef enum tagPenWidthLevelType
{
    PEN_WIDTHLEVEL_1 = 1,
    PEN_WIDTHLEVEL_2 = 2,
    PEN_WIDTHLEVEL_3 = 3,
    PEN_WIDTHLEVEL_4 = 4,
}PenWidthLevelType;

/**
 * [en]This structure is used to describe the pen property information.
 * [cn]画笔属性信息
 */
typedef struct tagPenInfo
{
    PenStyle style;                              /**< [en]Indicates pen style.
                                                                         [cn]画笔样式 */
    HWM_UINT32 color;                                              /**< [en]Indicates the color value, 0xRRGGBBAA said.
                                                                         [cn]颜色(RGBA)，0xRRGGBBAA表示 */
    HWM_INT32 width;                                               /**< [en]Indicates pen width.
                                                                         [cn]画笔宽度 */
    PenWidthLevelType widthLevel; /**< [en]Indicates pen width. [cn]画笔等级宽度 */
}PenInfo;

/**
 * [en]This enumeration is used to describe the definition of the component ID.
 * [cn]组件ID定义
 */
typedef enum  tagCOMPONENT_IID
{
    CONF_IID_COMPONENT_BASE = 0x0000,           /**< [en]Indicates conference control
                                                 <br>[cn]会议控制 */
    CONF_IID_COMPONENT_DS = 0x0001,             /**< [en]Indicates document sharing
                                                 <br>[cn]文档共享 */
    CONF_IID_COMPONENT_AS = 0x0002,             /**< [en]Indicates screen sharing
                                                 <br>[cn]屏幕共享 */
    CONF_IID_COMPONENT_WB = 0x0200,             /**< [en]Indicates whiteboard
                                                 <br>[cn]白板 */
    CONF_IID_COMPONENT_IDEAHUB_WB = 0x0400,     /**< [en]Indicates ideahub whiteboard
                                                 <br>[cn]ideahub白板 */
} ComponentIID;

/**
 * [en]This structure is used to describe the brush property information.
 * [cn]画刷属性信息
 */
typedef struct tagBrushInfo
{
    BrushStyle style;                            /**< [en]Indicates brush style.
                                                                         [cn]画刷样式 */
    HWM_UINT32 color;                                              /**< [en]Indicates the color value, 0xRRGGBBAA said.
                                                                         [cn]颜色(RGBA)，0xRRGGBBAA表示 */
}BrushInfo;

typedef struct tagBgColor
{
    ComponentIID ciid;
    HWM_UINT32 docId;
    HWM_UINT32 pageId;
    HWM_UINT32 bgColor;
    HWM_BOOL sync;
}BgColor;

typedef struct tagDsZoom
{
    ComponentIID ciid;
    HWM_UINT32 docId;
    HWM_UINT32 zoomType;
    HWM_UINT32 factor;
    HWM_BOOL sync;
    HWM_BOOL redraw;
}DsZoom;

typedef enum {
    WATERMARK_FORMAT_DATA = 0,           //裸数据
    WATERMARK_FORMAT_BMPINFO_DATA = 1,	 //附带BITMAPINFO结构BMP数据
}WatermarkFormat;

typedef enum {
    WATERMARK_RENDER_NO = 0,          //不渲染
    WATERMARK_RENDER_UPDATE = 1,      //用当前的数据作为水印背景
    WATERMARK_RENDER_ORIGINAL = 2,    //用之前的数据作为水印背景
}WatermarkRender;

/**
 * [en]This structure is used to describe the label icon resource structure definition.
 * [cn]标注水印背景结构定义
 */
typedef struct tagAnnoWaterMarkItem
{
    HWM_UCHAR*               pData;                 /**< [en]Indicates the customize label data. [cn]自定义水印标注数据 [cs_allowNull:Y] */
    HWM_UINT32               dataLen;               /**< [length for pData][en]Indicates the customize label data length. [cn]自定义水印数据长度 */
    WatermarkFormat          format;                /**< [en]Indicates the Indicates the customize label format. [cn]自定义水印数据格式 */
    HWM_UINT16               picW;                  /**< [en]Indicates the picture width. [cn]水印图片宽度，PIXEL为单位，所有互通终端需要相同 */
    HWM_UINT16               picH;                  /**< [en]Indicates the picture height. [cn]水印高度，PIXEL为单位，所有互通终端需要相同 */
    WatermarkRender          renderFlag;            /**< [en]Indicates the picture flag. [cn]是否渲染当前水印 */
    HWM_CHAR                 fileName[HWM_MAX_FILENAME_LEN]; /**< [en]Indicates the file name. [cn]文件名字 */
}AnnoWaterMarkItem;

/**
 * [en]This structure is used to describe annotation hit test point info.
 * [cn]标注点测试信息
 */
typedef struct tagHitTestPointParam
{
    PointInfo point;                                             /**< [en]Indicates point, unit is TWIPS, and must not be scaled with respect to the origin of the page.
                                                                         [cn]要判断的点，以TWIPS以单位，且必须是相对于页面原点无缩放的坐标 */
    HitTestMode hitTestMode;                  /**< [en]Indicates hit test mode.
                                                                         [cn]测试模式 */
}HitTestPointParam;



/**
 * [en]This structure is used to describe annotation hit test line info.
 * [cn]标注线条测试信息
 */
typedef struct tagHitTestLineParam
{
    PointInfo startPoint;                                       /**< [en]Indicates start point.
                                                                         [cn]起始点 */
    PointInfo endPoint;                                         /**< [en]Indicates end point.
                                                                         [cn]结束点 */
    HitTestMode hitTestMode;                  /**< [en]Indicates hit test mode.
                                                                         [cn]测试模式 */
}HitTestLineParam;


/**
 * [en]This structure is used to describe annotation hit test rect info.
 * [cn]标注矩形框测试信息
 */
typedef struct tagHitTestRectParam
{
    RectInfo rectArea;                              /**< [en]Indicates rectangle area for test.
                                                                         [cn]要测试的矩形区域 */
    HitTestMode hitTestMode;                        /**< [en]Indicates hit test mode.
                                                                         [cn]测试模式 */
}HitTestRectParam;


/**
* [en]This structure is used to describe annotation details.
* [cn]标注信息
*/
typedef struct tagAnnotationSet
{
    HWM_UINT32 userId;
    HWM_UINT32 numOfAnnotationId;
    HWM_UINT32 annotationIds[HWM_MAX_ANNOTATION_NUM];
}AnnotationSet;

/**
* [en]This structure is used to indicates callback function type definition.
* [cn]回调函数类型定义
* @mobile:disable
* @mac:disable
*/
typedef HWM_VOID(*data_multi_callback)(HWM_UINT32 confHandle, HWM_INT32 nType, HWM_INT32 nValue1, HWM_ULONG nValue2, HWM_VOID* pVoid, HWM_INT32 nSize);

/**
 * [en]This structure is used to describe document page details.
 * [cn]文档页面详细信息
 * @android:disable
 */
typedef struct tagPageInfo
{
   
    HWM_INT32 pageIndex;                                          /**< [en]Indicates page index.
                                                                         [cn]页面索引 */
    HWM_INT32 width;                                               /**< [en]Indicates the current page width.
                                                                         [cn]当前页的宽 */
    HWM_INT32 height;                                              /**< [en]Indicates the current page height.
                                                                         [cn]当前页的高 */
    HWM_INT32 orgX;                                               /**< [en]Indicates the start X of the page on the server.
                                                                         [cn]该页起点X会标 */
    HWM_INT32 orgY;                                               /**< [en]Indicates the start Y of the page on the server.
                                                                         [cn]该页起点Y会标 */
    HWM_FLOAT zoomPercent;                                        /**< [en]Indicates the scale of the page.
                                                                         [cn]该页的缩放比例 */
    
}PageInfo;

/**
* [en]This structure is used to describe data member info.
* [cn]数据会议成员信息
*/
typedef struct tagDataMemberInfo
{
    HWM_UINT32 dataUserId; /**< [en][cn]数据会议userId */
    HWM_UINT32 videoUserId; /**< [en][cn]音视频会议userId */
    HWM_UINT32 deviceType;
    HWM_CHAR userName[HWM_MAX_NAME_LEN]; /**  [cs_sensitive:name] */
    HWM_CHAR userUri[HWM_MAX_URL_LEN];
    HWM_BOOL isSelf;
    HWM_BOOL isControlling;
    HWM_BOOL hasRemoteControlCapacity;
}DataMemberInfo;

/**
* [en]This structure is used to describe stop share reason.
* [cn]停止共享原因
*/
typedef enum tagStopShareReason
{
    STOP_SHARE_BY_NORMAL,           // 正常停止共享
    STOP_SHARE_BY_REJOIN_CONF,      // MMR迁移
    STOP_SHARE_BY_SCREEN_LOCK,      // 锁屏导致停止共享
    STOP_SHARE_BY_CAMERA_UNPLUGGED  // 共享摄像头被拔出
} StopShareReason;

/**
* [en]This structure is used to describe stop share info.
* [cn]停止共享信息
*/
typedef struct tagStopShareInfo
{
    HWM_BOOL isSender;
    StopShareReason stopShareReason;
}StopShareInfo;

/**
* [en]This structure is used to describe screen share info.
* [cn]屏幕共享信息
*/
typedef struct tagScreenShareInfo
{
    HWM_UINT32 confHandle;
    HWM_UINT32 selfUserId;
    HWM_BOOL isAppShare;
    HWM_BOOL isControlForbidden;
    HWM_BOOL isAnnoForbidden;
    HWM_BOOL isSupportShareStrategy;
    HWM_CHAR shareOwnerName[HWM_MAX_NAME_LEN]; /**<  [cs_sensitive:name] >*/
    HWM_UINT32 shareDeviceType;
    HWM_CHAR shareOwnerUri[HWM_MAX_URL_LEN];
    HWM_UINT32 shareUserId;
    HWM_UINT64 shareUserNo;
    HWM_UINT64 timeStamp;
    HWM_INT32 orginalWidth;    
    HWM_INT32 originalHeight;
    HWM_BOOL hasAnno;
    HWM_HWND shareWnd;
    HWM_BOOL hasRemoteControlCapacity;
    ShareType shareType;
}ScreenShareInfo;

typedef struct tagScreenShareInfoList
{
    HWM_UINT32 screenShareInfoCount;               /**< [length for screenShareInfo][en]count of screen share info] [cn]共享桌面信息列表[cs_allowNull:N]*/
    ScreenShareInfo* screenShareInfo;              /**< [en]Indicates all screen share info [cn]共享桌面信息 [cs_allowNull:N] */
}ScreenShareInfoList;

/**
* [en]This structure is used to describe share white board info.
* [cn]白板共享信息
*/
typedef struct tagWhiteBoardInfo
{
    HWM_UINT32 confHandle;
    HWM_UINT32 docId;
    HWM_UINT32 pageId;
    HWM_UINT32 selfUserId;
    HWM_BOOL isSender;
    HWM_CHAR shareOwnerName[HWM_MAX_NAME_LEN];
    HWM_CHAR shareOwnerUri[HWM_MAX_URL_LEN];
    HWM_UINT32 shareUserId;
    HWM_UINT64 shareUserNo;
    HWM_UINT64 timeStamp;
    HWM_UINT32 shareDeviceType;
}WhiteBoardInfo;

typedef struct tagWhiteBoardInfoList
{
    HWM_UINT32 whiteBoardInfoCount;               /**< [length for whiteBoardInfo][en]count of white board info] [cn]共享白板信息列表[cs_allowNull:N]*/
    WhiteBoardInfo* whiteBoardInfo;              /**< [en]Indicates all white board share info [cn]共享白板信息 [cs_allowNull:N] */
}WhiteBoardInfoList;

/**
* [en]This structure is used to describe remote control status info.
* [cn]远程控制状态信息
* @mobile:disable
*/
typedef struct tagRemoteControlStatus
{
    RemoteControlType msgType;    //远程控制类型
    HWM_CHAR number[HWM_MAX_NUMBER_LEN]; //权限所有者号码
    HWM_CHAR name[HWM_MAX_NAME_LEN];     //权限所有者名称
    HWM_BOOL isInControlling;        //当前是否在远程控制别人
    HWM_BOOL isSelf;                 //是否是自己
    HWM_UINT32 userId;               //权限所有者的userid
}RemoteControlStatus;


/**
* [en]This structure is used to describe share reconnect state.
* [cn]数据共享重连状态
* @mobile:disable
*/
typedef enum tagShareReconnectState
{
    SHARE_RECONNECTING,                               //数据会议中网络断开，会议组件正在尝试重连
    SHARE_RECONNECED_SUCCESS,                         //数据会议中网络恢复通知
    SHARE_RECONNECED_FAILED                           //数据会议中网络失败通知
}ShareReconnectState;

/**
* [en]This structure is used to describe share capture state.
* [cn]数据共享采集状态
* @mobile:disable
*/
typedef enum tagShareCaptureState
{
    SHARE_CAPTURE_STATE_STARTED = 0,                        /**< [en]Indicates capture started by user
                                                                 <br>[cn]采集开始 */
    SHARE_CAPTURE_STATE_CANCELED = 1,                       /**< [en]Indicates capture canceled by user
                                                                 <br>[cn]采集取消 */
    SHARE_CAPTURE_STATE_STOPPED_BY_USER = 2,                /**< [en]Indicates Capture stopped by user
                                                                 <br>[cn]采集被用户停止 */
    SHARE_CAPTURE_STATE_INTERRUPTED_BY_OTHER = 3,           /**< [en]Indicates Capture interrupted by other capture App
                                                                 <br>[cn]采集被其他应用中断 */
    SHARE_CAPTURE_STATE_STOPPED_BY_CALL = 4,                /**< [en]Indicates Capture stopped by phone call
                                                                 <br>[cn]采集被电话打断 */
    SHARE_CAPTURE_STATE_MIC_UNAVAILABLE = 5,                /**< [en]Microphone is temporarily unavailable
                                                                 <br>[cn]麦克风暂时不可用 */
    SHARE_CAPTURE_STATE_MIC_MUTED_BY_USER = 6,              /**< [en]Microphone is muted by user
                                                                 <br>[cn]麦克风被用户静音 */
    SHARE_CAPTURE_STATE_MIC_UNMUTED_BY_USER = 7,            /**< [en]Microphone is unmuted by user
                                                                 <br>[cn]麦克风已被用户取消静音 */
    SHARE_CAPTURE_STATE_ENTER_PRIVATE_SCENE = 8,            /**< [en]Current captured screen has private window
                                                                 <br>[cn]当前捕获的屏幕具有私有窗口 */
    SHARE_CAPTURE_STATE_EXIT_PRIVATE_SCENE = 9,             /**< [en]Private window disappeared on current captured screen
                                                                 <br>[cn]私有窗口在当前捕获的屏幕上消失 */
    SHARE_CAPTURE_STATE_STOPPED_BY_USER_SWITCHES = 10,      /**< [en]ScreenCapture stopped by user switches
                                                                 <br>[cn]屏幕捕获被用户开关停止 */
    SHARE_CAPTURE_STATE_BUTT
}ShareCaptureState;


/**
* [en]This structure is used to describe Start Annotation Result Role.
* [cn]开启标注结果消息的来源方
*/
typedef enum tagStartAnnotationResultRole
{
    START_ANNOTATION_ROLE_SENDER,                 // 发起共享方
    SHARE_ANNOTATION_ROLE_RECEIVER,                         // 接收共享方
    SHARE_ANNOTATION_ROLE_BUIT                           // 无效值
}StartAnnotationResultRole;

/**
* [en]This enumeration is used to describe result of start annotation.
* [cn]开启标注结果
*/
typedef enum tagStartAnnotationResult
{
    START_ANNOTATION_SUCCESS = 0,               /**< [en]success (default mode)
                                                <br>[cn]开启标注成功*/
    START_ANNOTATION_NOT_IN_DATACONF,           /**< [en]not in dataconf
                                                <br>[cn]不在数据会议中 */
    START_ANNOTATION_ALREADY_ANNO_STATUS,       /**< [en]already anno
                                                <br>[cn]已经处于标注状态 */
    START_ANNOTATION_REQUEST_ANNO_SUCCESS,      /**< [en]request success
                                                <br>[cn]申请标注成功 */
    START_ANNOTATION_REQUEST_ANNO_FAILED,       /**< [en]request failed
                                                <br>[cn]申请标注失败 */
    START_ANNOTATION_LOW_VERSION,               /**< [en]sender version low
                                                <br>[cn]共享方版本太低 */
    START_ANNOTATION_NOT_IN_SHARE,              /**< [en]not in share
                                                <br>[cn]既不在共享, 也不在接收共享状态中 */
    START_ANNOTATION_NOT_IN_CONF,               /**< [en]not in conf
                                                <br>[cn]不在会议中 */
    START_ANNOTATION_MAX_COUNT_EXCEED,          /**< [en]max count exceed.
                                                <br>[cn]超出标注的最大数量 */
    START_ANNOTATION_FAILED_BY_NO_APP_RIGHT,    /**< [en]request annotation failed by no app right..
                                                <br>[cn]应用没有权限导致申请标注失败 */
    START_ANNOTATION_BUTT
}StartAnnotationResult;

typedef enum tagIndependentAnnoStatus
{
    ANNO_STATUS_START,   // 发起标注的人收到
    ANNO_STATUS_STOP,    // 结束标注的人收到
    ANNO_STATUS_RECV,    // 有人首次发起标注，全都都能收到 
    ANNO_STATUS_FINISH,  // 首次发起标注的人结束标注，全都都能收到
}IndependentAnnoStatus;

typedef struct tagIndependentAnnoInfo
{
    HWM_UINT32 errorCode;
    HWM_UINT32 userId;   // 用户id，目前仅在ANNO_STATUS_RECV、ANNO_STATUS_START返回共享者的id
    HWM_UINT32 ppix;     // 发送端ppix，ANNO_STATUS_RECV有值
    HWM_UINT32 ppiy;     // 发送端ppiy，ANNO_STATUS_RECV有值
    HWM_UINT32 width;    // 发送端width，ANNO_STATUS_RECV有值
    HWM_UINT32 height;   // 发送端height，ANNO_STATUS_RECV有值
}IndependentAnnoInfo;

typedef struct tagIndependentStartAnnoInfo
{
    HWM_HWND shareHwnd;
    HWM_UINT32 width;    
    HWM_UINT32 height;
    HWM_UINT32 ppix;
    HWM_UINT32 ppiy;
}IndependentStartAnnoInfo;

/**
* [en]This structure is used to describe sharer PPI information.
* [cn]屏幕共享信息
*/
typedef struct tagPPIInfo
{
    HWM_FLOAT ppiX;      
    HWM_FLOAT ppiY;      
}PPIInfo;

/**
* [en]This structure is used to describe render paint prop information.
* [cn]渲染时偏移量信息
*/
typedef struct tagRenderPaintPropInfo
{
    HWM_FLOAT scale;
    HWM_INT32 offsetX;
    HWM_INT32 offsetY;
}RenderPaintPropInfo;

/**
* [en]This structure is used to describe surface information.
* [cn]缓存区信息
*/
typedef struct tagSurfaceInfo
{
    HWM_UCHAR* hdcData;            
    HWM_UINT16 dataSize;     /**< [length for hdcData][en]Indicates data size. [cn]数据长度 */
}SurfaceInfo;

/**
* [en]This structure is used to describe whiteboard surface information.
* [cn]白板渲染缓存区信息
*/
typedef struct tagWhiteboardSurfaceInfo
{
    HWM_UINT32 width;
    HWM_UINT32 height;
    HWM_UCHAR* hdcData;      /**< [en]whiteboard data. [cn]渲染数据缓存 [cs_allowNull:Y] */
    HWM_UINT32 dataSize;     /**< [length for hdcData][en]Indicates data size. [cn]数据长度 */
}WhiteboardSurfaceInfo;

/**
* [en] This enum type is used to describe notify message
* [cn]通知UI消息类型
*/
typedef enum tagDataConfNotifyMessageType
{
    MESSAGE_OUT_OF_MEMORY = 1,       /**< [en]out of memory notify. [cn]内存不足通知 */ 
    MESSAGE_MONITOR_REMOVED = 2,  /**< [en]monitor moved. [cn]屏幕共享由于显示器被拔出而停止*/ 
}DataConfNotifyMessageType;

/**
* [en]This structure is used to describe data conf params for mobile.
* [cn]初始化数据会议参数
* @pc:disable
*/
typedef struct tagMobileDataConfParams
{
    HWM_UINT32 devXDpi;                         /**< [en]indicates devX Dpi.
                                                     [cn]devX Dpi 大小[cs_allowNull:Y] */
    HWM_UINT32 devYDpi;                         /**< [en]Indicates devY Dpi 
                                                     [cn]devY Dpi 大小 */
    HWM_UINT32 clientDeviceType;                /**< [en]Indicates client device type.
                                                     [cn]终端登录类型  */
    HWM_UINT32 ideahubRenderMethod;             /**< [en]Indicates ideahub render method
                                                     [cn]ideahub 渲染模式 */
    HWM_CHAR annoPath[HWM_MAX_FILE_PATH_LEN];   /**<[en]Indicates anno path. [cn]标注路径
                                                     [cs_allowNull:N][cs_length:1-512]*/
    HWM_UINT32 ideahubAnnotationMethod;         /**< [en]indicates ideahub annotation method.
                                                     [cn]ideahub 标注方式[cs_allowNull:Y] */
    HWM_UINT32 screenShareMethod;               /**< [en]Indicates dscreen share method
                                                     [cn]屏幕共享模式*/
    HWM_UINT32 bgColor;                         /**< [en]Indicates the color value, 0xRRGGBBAA said, where AA is a transparent value, the current should be all passed FF.
                                                     [cn]颜色值，0xRRGGBBAA表示，其中AA为透明值，目前应该全部传FF */
}MobileDataConfParams;

/**
* [en] This enum type is used to describe cast type
* [cn]共享类型
*@pc:disable
*/
typedef enum tagCastType
{
    CAST_TYPE_UNKNOWN = -1,             /**< [en]indicates unknow. [cn]未知类型 */
    CAST_TYPE_WIRED_HDMI = 0,   /**< [en]indicates unknow. [cn]有线投屏HDMI*/
    CAST_TYPE_WIRED_TYPEC = 1,  /**< [en]indicates unknow. [cn]有线投屏TYPEC*/
    CAST_TYPE_WIRELESS = 2,     /**< [en]indicates unknow. [cn]无线投屏*/
    CAST_TYPE_SCREEN = 3,       /**< [en]indicates unknow. [cn]屏幕*/
    CAST_TYPE_APP = 4,          /**< [en]indicates unknow. [cn]应用*/
}CastType;

/**
* [en] This enum type is used to describe capture type
* [cn]采集类型
*@pc:disable
*/
typedef enum tagVideoCaptureType
{
    CAPTURE_TYPE_YUV = 0,                /**< [en]indicates yuv capture type. [cn]yuv 采集*/
    CAPTURE_TYPE_TEXTURE = 1,            /**< [en]indicates textureId capture type. [cn]textureId方式*/
    CAPTURE_TYPE_ENCODED_STREAM = 2,     /**< [en]indicates encoded stream. [cn]编码后的数据*/
    CAPTURE_TYPE_IMAGE_RENDER = 3,       /**< [en]indicates image render. [cn]图像渲染方式*/
}VideoCaptureType;

/**
* [en]This structure is used to describe data conf params for mobile.
* [cn]
* @pc:disable
*/
typedef struct tagCastShareConfig
{
    HWM_CHAR castCameraId[HWM_MAX_UUID_LEN];    /**< [en]Indicates log path. [cn]共享摄像头Id
                                                     [cs_allowNull:Y]*/
    CastType castType;                          /**< [en]Indicates cast type.
                                                     [cn]共享类型 [cs_allowNull:N] */
    HWM_BOOL isShareAudio;                      /**< [en]indicates share audio.
                                                     [cn]devX Dpi 大小[cs_allowNull:Y] */
    HWM_UINT32 width;                           /**< [en]indicates width.
                                                     [cn]宽[cs_allowNull:Y] */
    HWM_UINT32 height;                          /**< [en]indicates height.
                                                     [cn]高[cs_allowNull:Y] */
    HWM_UINT32 frameRate;                       /**< [en]indicates frameRate.
                                                     [cn]帧率[cs_allowNull:Y] */
    VideoCaptureType captureType;               /**< [en]indicates captureType.
                                                     [cn]采集类型[cs_allowNull:Y] */  
    HWM_UINT32 cameraDeviceType;                /**< [en]indicates cameraDeviceType.
                                                     [cn]摄像头类型[cs_allowNull:Y] */
}CastShareConfig;
  

/**
* [en]This structure is used to describe view data info for ios.
* [cn]
* @pc:disable
*/
typedef struct tagViewDataInfo
{
    HWM_UINT32 confHandle;;                     /**< [en]Indicates hamdle. [cn]窗口句柄
                                                     [cs_allowNull:N]*/
    HWM_UINT32 width;                           /**< [en]indicates width.
                                                     [cn]宽[cs_allowNull:Y] */
    HWM_UINT32 height;                          /**< [en]indicates height.
                                                     [cn]高[cs_allowNull:Y] */
    HWM_UINT32 bitCount;                        /**< [en]indicates bit count.
                                                     [cn]比特数[cs_allowNull:Y] */
    HWM_UINT32 iLineOffset;                     /**< [en]indicates line offset.
                                                     [cn]偏移量[cs_allowNull:Y] */
    HWM_UCHAR *data;                            /**< [en]indicates data.
                                                     [cn]数据[cs_allowNull:Y] */
    HWM_UINT32 dataLen;                         /**< [en][length for data].
                                                     [cn]数据长度[cs_allowNull:Y] */
}ViewDataInfo;

typedef enum tagSharingCodecType 
{
    SCREEN_SHARE_CODEC_TYPE_H264SW = 1000, // H.264软编码器
    SCREEN_SHARE_CODEC_TYPE_H264HW = 1001, // H.264硬编码器
    SCREEN_SHARE_CODEC_TYPE_SVCSW = 1020, // SVC软编码器
    SCREEN_SHARE_CODEC_TYPE_H265SCCSW = 1030, // H.265 SCC软编码器
    SCREEN_SHARE_CODEC_TYPE_H265HW = 1031, // H.265硬编码器
    SCREEN_SHARE_CODEC_TYPE_H265SCCAuto = 1032  // H.265软硬协同编码器
}SharingCodecType;

/**
 * [en]This structure is used to describe desktop sharing parameters.
 * [cn]桌面共享参数
 */
typedef struct tagScreenData
{
    HWM_UINT8 dataType;;                        /**< [en]Indicates dataType. [cn]数据源格式
                                                     [cs_allowNull:N]*/
    HWM_UCHAR *data;                             /**< [en]indicates data.
                                                     [cn]数据[cs_allowNull:Y] */
    HWM_UINT32 dataLen;                         /**< [en][length for data].
                                                     [cn]数据长度[cs_allowNull:Y] */
}ScreenData;

/**
* [en]display info
* [cn]设备显示信息
* @ios:disable
* @mac:disable
* @android:disable
* @win:disable
*/
typedef struct tagDisplayInfo
{
    HWM_INT32 id;                               /**< [en]device id. [cn]设备id */
    HWM_CHAR name[HWM_MAX_NAME_LENGTH];         /**< [en]device name. [cn]设备名字 */
    HWM_INT32 rotation;                         /**< [en]rotaion. [cn]旋转角度 */
    HWM_INT32 width;                            /**< [en]width. [cn]宽 */
    HWM_INT32 height;                           /**< [en]height. [cn]高 */
    HWM_INT32 densityDPI;                       /**< [en]DPI. [cn]DPI */
    HwmFoldState foldState;                     /**< [en]fold state.
                                                [cn]折叠状态,非折叠设备设置为FOLD_STATE_UNKNOWN
                                                [cs_allowNull:Y] */
}DisplayInfo;

/**
* [en]prepare data share info
* [cn]准备共享前的数据信息
* @ios:disable
* @mac:disable
* @android:disable
* @win:disable
*/
typedef struct tagPrepareDataShareInfo
{
    HWM_BOOL bShareAudio;                       /**< [en]share audio. [cn]是否共享音频 */
    HWM_BOOL bQualityFirst;                     /**< [en]quality first. [cn]是否质量优先 */
    HWM_BOOL bSupportSelectDisplay;             /**< [en]support select display.
                                                     [cn]是否支持选择屏幕（移动端不支持, pc支持）[cs_allowNull:Y] */
    DisplayInfo displayInfo;                    /**< [en]display info. [cn]设备显示信息 */
    HWM_BOOL bUseSurfaceMode;                   /**< [en]use surface mode capture.
                                                [cn]是否使用surface采集模式 
                                                [cs_allowNull:Y] */
    HWM_INT32* skipPrivacyWindowIds;            /**< [en]skip Privacy Window Ids. [cn]隐私窗口豁免id [cs_allowNull:Y] */
    HWM_INT32 skipPrivacyWindowIdsLen;          /**< [en]length of skip Privacy Window Ids [length for skipPrivacyWindowIds]. [cn]隐私窗口豁免id数目 */

}PrepareDataShareInfo;


/**
* [en]data share skip Privacy Window Id info
* [cn]共享采集相关的豁免隐私窗口信息
* @ios:disable
* @mac:disable
* @android:disable
* @win:disable
*/
typedef struct tagSkipPrivacyWindowIdInfo
{
    HWM_INT32* skipPrivacyWindowIds;            /**< [en]skip Privacy Window Ids. [cn]隐私窗口豁免id [cs_allowNull:Y] */
    HWM_INT32 skipPrivacyWindowIdsLen;          /**< [en]length of skip Privacy Window Ids [length for skipPrivacyWindowIds]. [cn]隐私窗口豁免id数目 */

}SkipPrivacyWindowIdInfo;

/**
 * [en]This structure is used to describe the application window information.
 * [cn]应用程序窗口信息
 */
typedef struct tagHwmAuxASWndInfo
{
    HWM_HWND        hWnd;               /**< [en]Indicates the application window handle. [cn]应用程序窗口句柄 */
    /*HWM_UINT16       *pWndTitle;*/         /**< [en]Indicates the window title. [cn]窗口名称 */
    HWM_HWND        hSmallIcon;         /**< [en]Indicates the icon handle. [cn]ICON图标Handle */
    HWM_BOOL         bChecked;           /**< [en]Indicates whether is selected. [cn]是否被选中 取值；true为被选中，false为没有被选中 */
}HwmAuxASWndInfo;

/**
 * [en]This enumeration is used to describe the page rotation type enumeration, currently only supports 0,1,2,3 four types of rotation.
 * [cn]页面旋转类型枚举，目前仅支持0，1，2，3四种类型的旋转
 */
typedef enum
{
    HwmDsRotateFlipBase = 0,                /**< [en]Indicates that the rotation type starts.
                                                     <br>[cn]旋转类型起始 */

    HwmDsRotateNoneFlipNone = 0,                /**< [en]Indicates not rotated, not flipped.
                                                     <br>[cn]未旋转，未翻转 */
    HwmDsRotate90FlipNone = 1,                /**< [en]Indicates rotate 90 degrees clockwise without flipping
                                                     <br>[cn]顺时针旋转90度，未翻转 */
    HwmDsRotate180FlipNone = 2,                /**< [en]Indicates rotate 180 degrees clockwise without flipping
                                                     <br>[cn]顺时针旋转180度，未翻转 */
    HwmDsRotate270FlipNone = 3,                /**< [en]Indicates rotate 270 degrees clockwise without flipping
                                                     <br>[cn]顺时针旋转270度，未翻转 */

    HwmDsRotateNoneFlipX = 4,                /**< [en]not support
                                                     <br>[cn]不支持 */
    HwmDsRotate90FlipX = 5,                /**< [en]not support
                                                     <br>[cn]不支持 */
    HwmDsRotate180FlipX = 6,                /**< [en]not support
                                                     <br>[cn]不支持 */
    HwmDsRotate270FlipX = 7,                /**< [en]not support
                                                     <br>[cn]不支持 */

    HwmDsRotateNoneFlipY = HwmDsRotate180FlipX, /**< [en]not support
                                                     <br>[cn]不支持 */
    HwmDsRotate90FlipY = HwmDsRotate270FlipX, /**< [en]not support
                                                     <br>[cn]不支持 */
    HwmDsRotate180FlipY = HwmDsRotateNoneFlipX,/**< [en]not support
                                                     <br>[cn]不支持 */
    HwmDsRotate270FlipY = HwmDsRotate90FlipX,  /**< [en]not support
                                                     <br>[cn]不支持 */

    HwmDsRotateNoneFlipXY = HwmDsRotate180FlipNone,  /**< [en]not support
                                                         <br>[cn]不支持 */
    HwmDsRotate90FlipXY = HwmDsRotate270FlipNone,  /**< [en]not support
                                                         <br>[cn]不支持 */
    HwmDsRotate180FlipXY = HwmDsRotateNoneFlipNone, /**< [en]not support
                                                         <br>[cn]不支持 */
    HwmDsRotate270FlipXY = HwmDsRotate90FlipNone,   /**< [en]not support
                                                         <br>[cn]不支持 */

    HwmDsRotateFlipMax = 20                    /**< [en]Indicates that the rotation type is terminated.
                                                         <br>[cn]旋转类型终止 */
}HwmAuxDsRotateFlipType;

/**
 * [en]This structure is used to describe the page information.
 * [cn]页面信息定义
 * @mobile:disable
 */
typedef struct
{
    HWM_INT32                width;                 /**< [en]Indicates page width. [cn]页面宽 */
    HWM_INT32                height;                /**< [en]Indicates page height. [cn]页面高 */
    HWM_INT32                orgX;                  /**< [en]Indicates the starting point X is displayed. [cn]显示起点X */
    HWM_INT32                orgY;                  /**< [en]Indicates the starting point Y is displayed. [cn]显示起点Y */
    HwmAuxDsRotateFlipType   rfType;                /**< [en]Indicates the rotation type of the page. [cn]该页面的旋转类型 */
    HWM_UINT16               zoomPercent;           /**< [en]Indicates the scale at which the page is displayed under the current document zoom type. [cn]当前文档缩放类型下，该页面显示时的缩放比例 */
    HWM_UCHAR                bCopied;               /**< [en]Indicates whether is copied page . [cn]是否是复制的页面：0否，1是 */
    HWM_UCHAR                bEPenDrawn;            /**< [en]Indicates whether the electronic stroke. [cn]是否被电子笔画过：0否，1是 */
    HWM_FLOAT                floatZoomPercent;      /**< [en]Indicates accurate document scaling. [cn]精确的文档缩放比例 */
    HWM_INT32                pageNo;                /**< [en]Indicates page number. [cn]页码 */
}HwmAuxDsPageInfo;

/**水印格式 */
typedef enum {
    HWM_WATERMARKDE_DATA = 0,           //裸数据
    HWM_WATERMARKDE_BMPINFO_DATA = 1,	//附带BITMAPINFO结构BMP数据
} HwmWaterMarkDEFormat;


typedef enum {
    HWM_RENDER_NO = 0,          //不渲染
    HWM_RENDER_UPDATE = 1,      //用当前的数据作为水印背景
    HWM_RENDER_ORIGINAL = 2,    //用之前的数据作为水印背景
} HwmWaterMarkDERender;

/**
 * [en]This structure is used to describe the label icon resource structure definition.
 * [cn]标注水印背景结构定义
 */
typedef struct tagHwmAuxAnnoWaterMarkItem
{
    HWM_UCHAR*                pData;                 /**< [en]Indicates the customize label data. [cn]自定义水印标注数据 */
    HWM_UINT32               dataLen;               /**< [en][length for pData]. [cn]自定义水印数据长度 */
    HwmWaterMarkDEFormat       format;                /**< [en]Indicates the Indicates the customize label format. [cn]自定义水印数据格式 */
    HWM_UINT16               picW;              /**< [en]Indicates the picture width. [cn]水印图片宽度，PIXEL为单位，所有互通终端需要相同 */
    HWM_UINT16               picH;             /**< [en]Indicates the picture height. [cn]水印高度，PIXEL为单位，所有互通终端需要相同 */
    HwmWaterMarkDERender       renderFlag;            /**< [en]Indicates the picture flag. [cn]是否渲染当前水印 */
} HwmAuxAnnoWaterMarkItem; 


/**
* [en] This enum type is used to describe share capture type
* [cn]共享采集模式
*/
typedef enum tagShareCaptureType
{
    SHARE_CAPTURE_TYPE_AUTO = 0,    /**< [en]indicates auto capture type. [cn]自动*/
    SHARE_CAPTURE_TYPE_WGC = 1,     /**< [en]indicates WGC capture type. [cn]WGC采集*/
    SHARE_CAPTURE_TYPE_MAG = 2,     /**< [en]indicates MAG capture type. [cn]MAG采集*/
    SHARE_CAPTURE_TYPE_GDI = 3,     /**< [en]indicates GDI capture type. [cn]GDI采集*/

    SHARE_CAPTURE_TYPE_BUTT
} ShareCaptureType;

/**
* [en] This enum type is used to describe share strategy
* [cn]共享策略
*/
typedef enum tagShareStrategy
{
    HWM_SHARE_STRATEGY_CLARITY                   = 0,   /**< [en]Indicates the CLARITY first. [cn]清晰度优先，默认值 */
    HWM_SHARE_STRATEGY_SMOOTHNESS                = 1,   /**< [en]Indicates the SMOOTHNESS first. [cn]流畅性优先 */
    HWM_SHARE_STRATEGY_CLARITY_AND_SMOOTHNESS    = 2,   /**< [en]Indicates the CLARITY and SMOOTHNESS. [cn]清晰且流畅模式 */


    HWM_SHARE_STRATEGY_BUTT
} HwmShareStrategy;

/**
 * [en]This enumeration is used to describe erase area annotation mode.
 * [cn]区域标注的擦除模式
 */
typedef enum tagEraseAreaAnnoMode {
    ERASE_AREA_ANNO_MODE_ALL = 0, /**< [en]Indicates all annotation in the region
                                       [cn]区域内的全部标注*/
    ERASE_AREA_ANNO_MODE_SELF,    /**< [en]Indicates my annotation in the region
                                       [cn]区域内自己的标注*/
    ERASE_AREA_ANNO_MODE_OTHERS,  /**< [en]Indicates all others annotation
                                       [cn]其他人的全部标注*/
    ERASE_AREA_ANNO_MODE_BUTT     /**< [ios:rename:Butt] */
} EraseAreaAnnoMode;

/**
 * [en]This structure is used to describe annotation to erase in specific area.
 * [cn]擦除区域内标注的参数
 */
typedef struct tagEraseAreaAnnoParam
{
    RectInfo rectArea;      /**< [en]Indicates rectangle area.
                                 [cn]矩形区域 */
    EraseAreaAnnoMode mode; /**< [en]Indicates eraset mode.
                                 [cn]擦除模式 */
}EraseAreaAnnoParam;

/**
* [en] This enum type is used to describe share render frame mode
* [cn]共享渲染帧率模式
*/
typedef enum tagShareRenderFrameMode
{
    SHARE_RENDER_FRAME_MODE_NORMAL = 0,    /**< [en]indicates normal mode. [cn]寻常模式 */
    SHARE_RENDER_FRAME_MODE_ECO = 1,     /**< [en]indicates WGC capture type. [cn]节能模式 */

    SHARE_RENDER_FRAME_MODE_BUTT
} ShareRenderFrameMode;

/**
* [en] Share Audio State
* [cn]共享音频状态
*/
typedef enum tagShareAudioState
{
    SHARE_AUDIO_NONE = 0,       /**< [en]indicates none. [cn]none */
    SHARE_AUDIO_OPEN,           /**< [en]indicates audio open. [cn]共享音频开启 */
    SHARE_AUDIO_CLOSE           /**< [en]indicates audio close. [cn]共享音频关闭 */
} ShareAudioState;

END_HWM_SDK_NAMESPACE
#endif /* __HWM_CONF_SERVICE_SHARE_DEF_H__ */
