//
//  ActionModel.m
//  HWMSDKDemo
//
//  Created by y00450113 on 2020/7/4.
//  Copyright © 2020 HuaWei. All rights reserved.
//

#import "ActionModel.h"

@implementation ActionModel
+ (instancetype)initWithTitle:(NSString *)title
                       action:(SEL)action{
    return [self initWithTitle:title action:action accessibilityId:@""];
}

+ (instancetype)initWithTitle:(NSString *)title
                       action:(SEL)action
              accessibilityId:(NSString *)accessibilityId {
    ActionModel *model = [[ActionModel alloc] init];
    model.action = action;
    model.title = title;
    model.actionCtrl = nil;
    model.accessibilityId = accessibilityId;
    return model;
}

+ (instancetype)initWithTitle:(NSString *)title
                   actionCtrl:(nullable NSString *)ctrl{
    return [self initWithTitle:title actionCtrl:ctrl accessibilityId:@""];
}

+ (instancetype)initWithTitle:(NSString *)title
                   actionCtrl:(nullable NSString *)ctrl
              accessibilityId:(NSString *)accessibilityId {
    ActionModel *model = [[ActionModel alloc] init];
    model.title = title;
    model.actionCtrl = ctrl;
    model.accessibilityId = accessibilityId;
    return model;
}

+ (instancetype)initWithTitle:(NSString *)title type:(NSInteger)type{
    ActionModel *model = [[ActionModel alloc] init];
    model.title = title;
    model.type = type;
    return model;
}

+ (instancetype)initWithTitle:(NSString *)title type:(NSInteger)type accessibilityId:(NSString *)accessibilityId {
    ActionModel *model = [[ActionModel alloc] init];
    model.title = title;
    model.type = type;
    model.accessibilityId = accessibilityId;
    return model;
}

- (NSString *)accessibilityId {
    return _accessibilityId.length > 0 ? _accessibilityId : _title;
}

@end
