//
//  AppDelegate.m
//  HWMSDKDemo
//
//  Created by 融合软终端02 on 2020/2/17.
//  Copyright © 2020 HuaWei. All rights reserved.
//

#import "AppDelegate.h"
#import "NavigationController.h"
#import "FirstViewController.h"

@interface HWMWechatManager : NSObject
+ (BOOL)handleUniversalLink:(NSUserActivity *)userActivity;
@end

@interface AppDelegate ()

@end

@implementation AppDelegate
@synthesize window = _window;

- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions {
    self.window = [[UIWindow alloc] initWithFrame:[UIScreen mainScreen].bounds];
    FirstViewController *first = [[FirstViewController alloc] init];
    NavigationController *nav = [[NavigationController alloc] initWithRootViewController:first];
    self.window.rootViewController = nav;
    [self.window makeKeyAndVisible];
    return YES;
}

- (UIInterfaceOrientationMask)application:(UIApplication *)application supportedInterfaceOrientationsForWindow:(UIWindow *)window {
    if (window.rootViewController) {
        return window.rootViewController.supportedInterfaceOrientations;
    }
    return UIInterfaceOrientationMaskPortrait;
}

- (BOOL)application:(UIApplication *)application continueUserActivity:(NSUserActivity *)userActivity restorationHandler:(void (^)(NSArray<id<UIUserActivityRestoring>> * _Nullable))restorationHandler {
    return [HWMWechatManager handleUniversalLink:userActivity];
}

-(BOOL)application:(UIApplication *)app openURL:(NSURL *)url options:(NSDictionary<UIApplicationOpenURLOptionsKey,id> *)options {
    // 处理方法在 PrivateAppDelegate.m里面
    return YES;
}
@end
