//
//  ConfInfoViewController.m
//  HWMSDKDemo
//
//  Created by y00450113 on 2020/7/4.
//  Copyright © 2020 HuaWei. All rights reserved.
//

#import "ConfInfoViewController.h"
typedef NS_ENUM(NSInteger, CellType) {
    CellTypeInvocation,
    CellTypeNotify,
};

@interface ConfInfoViewController ()
@end

@implementation ConfInfoViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.title = @"会议信息";
    [self setupDatas];
    [self setupTableView];
}

- (void)setupDatas{
    self.dataArray = @[[ActionModel initWithTitle:@"主动调用" actionCtrl:@"InvocationViewController"],
                       [ActionModel initWithTitle:@"SDK通知" actionCtrl:@"NotifyViewController"],
                       [ActionModel initWithTitle:@"字幕消息通知" actionCtrl:@"SubtitleRecordViewController"],
    ];
}


-(UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath{
    TableViewCell * cell = [tableView dequeueReusableCellWithIdentifier:@"TableViewCell"];
    [cell setSelectionStyle:UITableViewCellSelectionStyleDefault];
    ActionModel *model = self.dataArray[indexPath.row];
    cell.titleLabel.text = model.title;
    return cell;
}

//- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
//    [tableView deselectRowAtIndexPath:indexPath animated:NO];
//
//}
@end
