//
//  NotifyViewController.m
//  HWMSDKDemo
//
//  Created by y00450113 on 2020/8/3.
//  Copyright © 2020 HuaWei. All rights reserved.
//

#import "NotifyViewController.h"
#import "NotifyMessageHandler.h"
@interface NotifyViewController () <NotifyMessageDelegate>
@property (nonatomic, strong)NSArray <NotifyMessageModel *> * datas;
@end

@implementation NotifyViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.title = @"通知";
    [self setupTableView];
    [self reloadData];
    [NotifyMessageHandler sharedInstance].delegate = self;


}

- (void)reloadData{
    self.datas = [[NotifyMessageHandler sharedInstance].notifyMessages copy];
    [self.tableView reloadData];
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section{
    return self.datas.count;
}

-(UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath{
    UITableViewCell * cell = [tableView dequeueReusableCellWithIdentifier:@"UITableViewCell"];
       if (cell == nil) {
           cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleSubtitle reuseIdentifier:@"UITableViewCell"];
       }
    [cell setSelectionStyle:UITableViewCellSelectionStyleDefault];
    NotifyMessageModel *model = self.datas[indexPath.row];
    cell.textLabel.text = model.title;
    cell.detailTextLabel.text = model.desc;
    cell.detailTextLabel.numberOfLines = 0;
    return cell;
}

- (void)onMessageChanged:(NSArray *)datas{
    [self reloadData];
}
@end
