//
//  ContactSelectViewController.m
//  HWMSDKDemo
//
//  Created by guoyongliang/gwx917154 on 2020/6/11.
//  Copyright © 2020 HuaWei. All rights reserved.
//

#import "ContactSelectViewController.h"
#import <HWMUISDK/HWMUISDK.h>
#import "AddContactViewController.h"
typedef void (^HWMResultCompleteHander) (id result, NSError *error);

@interface ContactSelectViewController ()
@property (nonatomic, copy) HWMResultCompleteHander completeHandler;
@property (nonatomic, strong) NSMutableArray *selectmodels;
@property (nonatomic, strong) NSMutableArray <HWMContactSelectedModel *> *dataModels;
@end

@implementation ContactSelectViewController

-(void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [self.navigationController setNavigationBarHidden:NO animated:animated];
}

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"自定义添加联系人";
    [self initData];
    [self setupTableView];

    UIButton *finishBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [finishBtn setTitle:@"完成" forState:UIControlStateNormal];
    [finishBtn setBackgroundColor:HexColor(0x1E90FF)];

    [finishBtn addTarget:self action:@selector(finishBtnClick) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:finishBtn];
    [finishBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.bottom.mas_equalTo(0);
        make.height.mas_equalTo(50);
    }];
    
    UIButton *addButton = [UIButton buttonWithType:UIButtonTypeSystem];
    [addButton setTitle:@"添加" forState:UIControlStateNormal];
    [addButton setTitleColor:HexColor(0x333) forState:UIControlStateNormal];
    [addButton addTarget:self action:@selector(addButtoClick) forControlEvents:UIControlEventTouchUpInside];
    UIBarButtonItem *rightItem = [[UIBarButtonItem alloc]initWithCustomView:addButton];
    self.navigationItem.rightBarButtonItem = rightItem;
}

- (void)addButtoClick {
    AddContactViewController * vc = [[AddContactViewController alloc] initWithNibName:@"AddContactViewController" bundle:nil];
    __weak __typeof(self) weakSelf = self;
    vc.addModelResulet = ^(HWMContactSelectedModel * _Nonnull userModel) {
        __strong __typeof(weakSelf) strongSelf = weakSelf;
        [strongSelf.dataModels addObject:userModel];
        [strongSelf.selectmodels addObject:userModel];
        [strongSelf.tableView reloadData];
    };
    [self.navigationController pushViewController:vc animated:YES];
}

- (void)setupTableView {
    [super setupTableView];
    [self.tableView mas_updateConstraints:^(MASConstraintMaker *make) {
        make.bottom.mas_equalTo(-60);
    }];
}

-(NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.dataModels.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    TableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"TableViewCell"];
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    HWMContactSelectedModel *model = self.dataModels[indexPath.row];
    cell.titleLabel.text = model.name;
    cell.selectTypeSwitch.hidden = NO;
    cell.selectTypeSwitch.on = [self.selectmodels containsObject:model];
    __weak __typeof(self) weakSelf = self;
    cell.selectSwitchBlock = ^(BOOL isSelect) {
        __strong __typeof(weakSelf) strongSelf = weakSelf;
        if (isSelect) {
            [strongSelf.selectmodels addObject:model];
        } else {
            [strongSelf.selectmodels removeObject:model];
        }
    };
    return cell;
}

- (void)initData {
    NSMutableArray *users = [NSMutableArray array];
    HWMContactSelectedModel *model = [[HWMContactSelectedModel alloc] initWithName:@"测试账号01" number:@"" contactType:HWMSelectedContactTypeEnterprise];
    model.thirdUserId = @"luqiang01";
    [users addObject:model];

    HWMContactSelectedModel *model2 = [[HWMContactSelectedModel alloc] initWithName:@"测试账号02" number:@"" contactType:HWMSelectedContactTypeEnterprise];
    model2.thirdUserId = @"luqiang02";
    [users addObject:model2];

    HWMContactSelectedModel *model3 = [[HWMContactSelectedModel alloc] initWithName:@"测试账号03" number:@"" contactType:HWMSelectedContactTypeEnterprise];
    model3.thirdUserId = @"luqiang03";
    [users addObject:model3];

    HWMContactSelectedModel *model4 = [[HWMContactSelectedModel alloc] initWithName:@"测试账号04" number:@"" contactType:HWMSelectedContactTypeEnterprise];
    model4.thirdUserId = @"luqiang04";
    [users addObject:model4];

    HWMContactSelectedModel *model5 = [[HWMContactSelectedModel alloc] initWithName:@"测试账号05" number:@"" contactType:HWMSelectedContactTypeEnterprise];
    [users addObject:model5];
    model5.thirdUserId = @"luqiang05";
    
    HWMContactSelectedModel *model6 = [[HWMContactSelectedModel alloc] initWithName:@"wxf(1234)" number:@"" contactType:HWMSelectedContactTypeEnterprise];
    [users addObject:model6];
    model6.thirdUserId = @"1234";
    
    self.dataModels = users;
}

- (void)finishBtnClick {
    // 点击完成回调需要添加的人，回调的为HWMContactSelectedModel数组
    self.completeHandler(self.selectmodels, nil);
    [self.navigationController popViewControllerAnimated:YES];
}

- (instancetype)initWithResultHandler:(void (^) (NSArray<HWMContactSelectedModel *> *result, NSError *error))handler {
    if (self = [super init]) {
        self.completeHandler = handler;
    }
    return self;
}

- (NSMutableArray *)selectmodels {
    if (!_selectmodels) {
        _selectmodels = [NSMutableArray array];
    }
    return _selectmodels;
}

@end
