//
//  HWMVideoCallMenuHandlerImpl.m
//  HWMConfUI
//
//  Created by y00450113 on 2020/7/8.
//  Copyright © 2020 huawei. All rights reserved.
//

#import "VideoCallMenuHandlerImpl.h"
#import "HWMConfToolBarMenuItem.h"
#import "HWMConfMenuListItem.h"
#import "HWMConfSettingGroup.h"
@implementation VideoCallMenuHandlerImpl

/// 构建视频呼叫底部toolbar的会控全量菜单
- (NSArray <HWMConfToolBarMenuItem *> *)buildToolBarMenuItems{
      // 麦克风静音 or 取消静音
      HWMConfToolBarMenuItem *micItem = [HWMConfToolBarMenuItem defaultMicItem];
      // 打开 or 关闭摄像头
      HWMConfToolBarMenuItem *videoItem = [HWMConfToolBarMenuItem defaultVideoItem];
      // 邀请
      HWMConfToolBarMenuItem *inviteItem = [HWMConfToolBarMenuItem defaultInviteItem];
      // 更多
      HWMConfToolBarMenuItem *moreItem = [HWMConfToolBarMenuItem defaultMoreItem];
      return @[micItem, videoItem, inviteItem, moreItem];
}

/// 构建视频呼叫底部toolbar的“更多”菜单，预留
- (NSArray <HWMConfMenuListItem *> *)buildToolBarMoreMenuItems{
    // 转语音通话
    HWMConfMenuListItem *transAudioItem = [HWMConfMenuListItem defaultTransToAudioItem];
    // 设置
    HWMConfMenuListItem *settingItem = [HWMConfMenuListItem defaultSettingItem];
    return @[transAudioItem, settingItem];
}

// 构建视频呼叫点击更多菜单的设置弹出的设置列表项目
- (NSArray <HWMConfSettingGroup *> *)buildSettingItems{
   HWMConfSettingGroup *audioVideoGroup = [[HWMConfSettingGroup alloc] initWithTitle:@"音视频"];
   HWMConfSettingItem *beautyItem = [HWMConfSettingItem defaultBeautyItem];
    HWMConfSettingItem *mirrorItem = [HWMConfSettingItem defaultMirror];
   HWMConfSettingItem *hideSmallViewItem = [HWMConfSettingItem defaultHideSmallVideoItem];
   audioVideoGroup.items = @[beautyItem, mirrorItem, hideSmallViewItem];

   HWMConfSettingGroup *commonGroup = [[HWMConfSettingGroup alloc] initWithTitle:@"通用"];
   HWMConfSettingItem *networkDetectItem = [HWMConfSettingItem defaultNetworkDetectItem];
   HWMConfSettingItem *feedbackItem = [HWMConfSettingItem defaultFeedbackItem];
   commonGroup.items = @[networkDetectItem, feedbackItem];
   
   return @[audioVideoGroup, commonGroup];
}
@end
