//
//  SetAPPIDViewController.m
//  HWMSDKDemo
//
//  Created by guoyongliang/gwx917154 on 2020/11/14.
//  Copyright © 2020 HuaWei. All rights reserved.
//

#import "SetAPPIDViewController.h"
#import "SDKEnvConfig.h"

@interface SetAPPIDViewController ()

@property (nonatomic, strong) UITextField *appIdTextField;      /**< appId输入框 */

@end

@implementation SetAPPIDViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"设置AppId";
}

- (void)setupViews {
    [super setupViews];
    UILabel *contentLabel = [[UILabel alloc] init];
    contentLabel.text = @"注意事项:先设置AppId后初始化";
    
    self.appIdTextField = [[UITextField alloc] init];
    self.appIdTextField.placeholder = @"请输入appId";
    self.appIdTextField.backgroundColor = HexColor(0xf2f2f2);

    UIButton *setAppIdBtn = [UIButton newButtonWithTitle:@"设置AppID"];
    [setAppIdBtn addTarget:self action:@selector(handelSetAppId) forControlEvents:UIControlEventTouchUpInside];

    UIStackView *stackView = [[UIStackView alloc] init];
    stackView.spacing = 10.0;
    stackView.axis = UILayoutConstraintAxisVertical;
    stackView.distribution = UIStackViewDistributionFillEqually;

    [stackView addArrangedSubview:contentLabel];
    [stackView addArrangedSubview:self.appIdTextField];
    [stackView addArrangedSubview:setAppIdBtn];

    [self.view addSubview:stackView];
    [stackView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.view).mas_offset(150);
        make.left.mas_equalTo(50);
        make.right.mas_equalTo(-50);
        make.height.mas_equalTo(250);
    }];

    // info
    self.appIdTextField.text = [SDKEnvConfig sharedInstance].appId;
}

/// 设置AppId
- (void)handelSetAppId {
    [self setAppIdInfo];
    [self showAppIdInfo];
}

- (void)setAppIdInfo {
    [SDKEnvConfig sharedInstance].appId = self.appIdTextField.text;
}

- (void)showAppIdInfo {
    SDKEnvConfig *config = [SDKEnvConfig sharedInstance];
    [UIUtil showMessage:[NSString stringWithFormat:@"appId:%@", config.appId]];
}

@end
