//
//  GlobalHandlerImpl.m
//  HWMSDKDemo
//
//  Created by y00450113 on 2020/7/28.
//  Copyright © 2020 HuaWei. All rights reserved.
//

#import "GlobalHandlerImpl.h"
#import "UIUtil.h"
#import "ShareView.h"
#import "ContactSelectViewController.h"
#import "NotifyMessageHandler.h"

@implementation GlobalHandlerImpl
+ (instancetype)sharedInstance
{
    static id instance = nil;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        instance = [[self alloc] init];
    });
    return instance;
}


#pragma mark - HWMSocialShareHandler
// 此方法与getShareLogoImages getBrandName不能同时使用。同时使用getShareLogoImages getBrandName 无效果
- (void)shareConf:(HWMConfDetail *)confInfo isAnonymous:(BOOL)isAnonymous inCtrl:(UIViewController *)controller {
    NSLog(@"enter share conf");
    ShareView *shareView = [[ShareView alloc] init];
    [shareView showShareView:^(NSInteger index) {
        [UIUtil showMessage:[NSString stringWithFormat:@"点击了第%zd个按钮", index + 1]];
    }];
}

#pragma mark - HWMContactUIHandler
- (void)openContactSelectPage:(NSArray<HWMConfContactModel *> *)param
                        scene:(HWMSelectedContactScene)scene
               completeHander:(void (^)(NSArray<HWMContactSelectedModel *> *result, NSError *error))handler {
    NSLog(@"enter open contact select page");
    ContactSelectViewController *contactSelectVc = [[ContactSelectViewController alloc] initWithResultHandler:handler];
    [[UIUtil findCurrentNavigationController] pushViewController:contactSelectVc animated:YES];
    // 弹窗提示，方便查看
    __block NSMutableString * contactInfo = [[NSMutableString alloc] init];
    [param enumerateObjectsUsingBlock:^(HWMConfContactModel * _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
        [contactInfo appendFormat:@"accountId:%@ thirdUserId:%@\n", obj.accountId, obj.thirdUserId];
    }];
    if (contactInfo.length > 0) {
        [UIUtil showMessage:contactInfo];
    }
}

#pragma mark - confSettingHandler
/// 使用时是否打开麦克风
- (BOOL)isOpenMicrophoneIncoming {
    NSLog(@"isOpenMic:%d", self.isOpenMic);
    return self.isOpenMic;
}

/// 使用时是否打开摄像头
- (BOOL)isOpenCameraIncoming {
    NSLog(@"isOpenCamera:%d", self.isOpenCamera);
    return self.isOpenCamera;
}

-(HWMAnswerBtnShowType)getVideoConfIncomingAnswerBtnShowType {
    NSLog(@"answerBtnShowType:%zd", self.answerBtnShowType);
    return self.answerBtnShowType;
}

-(HWMInComingAnswerType)answerTypeOnCallIncoming {
    return self.inComingAnswerType;
}

-(HWMInComingAnswerType)answerTypeOnConfIncoming {
    return self.inComingAnswerType;
}

#pragma mark - <HWMHeadPortraitApiHandler>
- (void)queryContactAvatarWithAvatalModel:(HWMConfQueryAvatarModel *)model completionBlock:(void (^)(NSError * _Nullable, UIImage * _Nullable))completionBlock {
    NSLog(@"queryContactAvatarWithAvatalModel account:%@ thirdUserId:%@ number:%@, orgId: %@", model.account, model.thirdUserId, model.number, model.orgId);
    UIImage *image = self.headImage;
    if (!image) {
        // 没有图片是设置默认图片
        image = [UIImage imageNamed:@"custom_conf_setting"];
    }
    completionBlock(nil, image);
}

#pragma mark - Getter

- (CustomVirtualBakcgroundImpl *)defaultVirtualBackgroundImpl {
    if (!_defaultVirtualBackgroundImpl) {
        _defaultVirtualBackgroundImpl = [[CustomVirtualBakcgroundImpl alloc] init];
    }
    return _defaultVirtualBackgroundImpl;
}

#pragma mark - HWMCustomUITextHandler

- (NSArray<HWMUILanguageInfo *> *)customLanguageInfosForScene:(HWMCustomUITextScene)scene {
    switch (scene) {
        case HWMCustomUITextSceneCloudRecordFinishedAlert:
            return [self createLanguageInfosWithCNText:@"会议录制文件保存在“个人会议管理平台-我的录制”中，请登录pc客户端查看" enText:@"Meeting recordings are saved on the Management Platform > My Recordings page. Log in to your PC client and view the recordings."];
        case HWMCustomUITextSceneCloudRecordFinishedInMeetingAlert:
            return [self createLanguageInfosWithCNText:@"会议结束后，您可以在“会议管理平台-我的录制”中查看录制文件" enText:@"When this meeting ends, view the recordings on the My Recordings page of Huawei Cloud Meeting Management Platform."];
        case HWMCustomUITextSceneLeaveOrEndConfPopupWindow:
            return [self createLanguageInfosWithCNText:@"离开或结束会议？" enText:@"Leave or end meeting?"];
        case HWMCustomUITextSceneCloudRecordMenuTitle:
            return [self createLanguageInfosWithCNText:@"云录制" enText:@"Cloud recording"];
        case HWMCustomUITextSceneMainWindowCloudRecordDes:
            return [self createLanguageInfosWithCNText:@"录制中" enText:@"Recording"];
        default:
            return nil;
    }
}

- (NSArray<HWMUILanguageInfo *> *)createLanguageInfosWithCNText:(NSString *)cnText enText:(NSString *)enText {
    HWMUILanguageInfo *cn = [HWMUILanguageInfo infoWithCode:@"cn" content:[cnText stringByAppendingString:@" 自定义"]];
    HWMUILanguageInfo *en = [HWMUILanguageInfo infoWithCode:@"en" content:[enText stringByAppendingString:@" Custom"]];
    return @[cn, en];
}

#pragma mark - HWMCustomImageHandler

- (HWMCustomImageInfo *)customImageForScene:(HWMCustomImageScene)scene {
    switch (scene) {
        case HWMCustomImageSceneCloudRecordIcon:
        case HWMCustomImageSceneMainWindowCloudRecordIcon: {
            return [[HWMCustomImageInfo alloc] initWithImage:[UIImage imageNamed:@"custom_conf_setting"] width:24 height:24];
        }
        default:
            return nil;
    }
}

#pragma mark - HWMParticipantListItemCallOtherNumberHandler

- (void)buildCallOtherNumberList:(HWMAttendeeInfo *)attendee callback:(void (^)(NSArray<HWMCallOtherNumberItem *> * _Nonnull))callback {
    if (callback) {
        HWMCallOtherNumberItem *item1 = [[HWMCallOtherNumberItem alloc] init];
        item1.number = @"12345678910";
        item1.callback = ^(HWMAttendeeInfo * _Nonnull attendee) {
            NSString *str = [NSString stringWithFormat:@"name: %@, number: %@", attendee.name, attendee.number];
            NotifyMessageModel *msg = [[NotifyMessageModel alloc] initWithMsgType:NotifyMessageModelTypeCallOtherNumber content:str];
            NotifyMessageHandler *msgHandler = [NotifyMessageHandler sharedInstance];
            [msgHandler.notifyMessages addObject:msg];
            if (msgHandler.delegate && [msgHandler.delegate respondsToSelector:@selector(onMessageChanged:)]) {
                [msgHandler.delegate onMessageChanged:msgHandler.notifyMessages];
            }
        };
        callback(@[item1]);
    }
}

#pragma mark - HWMShareInterceptHandler

- (void)onSelfStartShareIntercept:(void (^)(HWMShareInterceptInfo * _Nonnull))callback {
    if (callback) {
        [UIUtil showMessage:@"已拦截共享"];
        HWMShareInterceptInfo *model = [[HWMShareInterceptInfo alloc] init];
        model.isInterrupt = YES;
        callback(model);
    }
}

#pragma mark - HWMContactApiHandler

- (void)queryContactDetailWithModel:(HWMConfQueryContactModel *)model completeHandler:(HWMQueryContactDetailCompleteHandler)handler {
    NSLog(@"queryContactDetailWithModel, account: %@, thirdUserId: %@, number: %@, orgId: %@", model.account, model.thirdUserId, model.number, model.orgId);
    HWMEnterpriseContact *contact = [[HWMEnterpriseContact alloc] init];
    contact.account = model.account;
    contact.thirdUserId = model.thirdUserId;
    contact.number = model.number;
    contact.orgId = model.orgId;
    if (handler) {
        handler(contact, nil);
    }
}

@end
