//
//  JoinMeetingViewController.m
//  HWMSDKDemo
//
//  Created by adminstrator on 2020/4/1.
//  Copyright © 2020 HuaWei. All rights reserved.
//

#import "JoinMeetingViewController.h"

@interface JoinMeetingViewController ()
@property (nonatomic, strong) UITextField *idTextField;
@property (nonatomic, strong) UITextField *codeTextField;
@property (nonatomic, strong) UITextField *nickTextField;
@end

@implementation JoinMeetingViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.title = @"加入会议";
}

- (void)setupViews {
    [super setupViews];
    self.idTextField = [[UITextField alloc] init];
    [self.view addSubview:self.idTextField];
    self.idTextField.placeholder = @"会议ID";
    [self.idTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(110);
        make.height.mas_equalTo(30);
        make.left.mas_equalTo(50);
        make.right.mas_equalTo(-50);
    }];
    [UIView addBottomLineWithView:self.idTextField parentView:self.view];
    
    self.codeTextField = [[UITextField alloc] init];
    [self.view addSubview:self.codeTextField];
    self.codeTextField.placeholder = @"会议接入码";
    [self.codeTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.idTextField.mas_bottom).mas_offset(25);
        make.height.mas_equalTo(self.idTextField);
        make.left.right.mas_equalTo(self.idTextField);
    }];
    [UIView addBottomLineWithView:self.codeTextField parentView:self.view];
    
    
    self.nickTextField = [[UITextField alloc] init];
    [self.view addSubview:self.nickTextField];
    self.nickTextField.placeholder = @"用户昵称";
    [self.nickTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.codeTextField.mas_bottom).mas_offset(25);
        make.height.mas_equalTo(self.idTextField);
        make.left.right.mas_equalTo(self.idTextField);
    }];
    [UIView addBottomLineWithView:self.nickTextField parentView:self.view];

    
    UIButton * joinMeetingBtn = [UIButton newButtonWithTitle:@"加入会议"];
    [self.view addSubview:joinMeetingBtn];
    [joinMeetingBtn addTarget:self action:@selector(joinMeeting) forControlEvents:UIControlEventTouchUpInside];
    [joinMeetingBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.nickTextField.mas_bottom).mas_offset(50);
        make.left.right.mas_equalTo(self.idTextField);
        make.height.mas_equalTo(50);
    }];
}

- (void)joinMeeting {
    NSLog(@"点击加入会议");
}

@end
