//
//  JoinMeetingViewController.m
//  HWMSDKDemo
//
//  Created by adminstrator on 2020/4/1.
//  Copyright © 2020 HuaWei. All rights reserved.
//

#import "JoinMeetingViewController.h"
#import <HWMUISDK/HWMUISDK.h>
#import "UIUtil.h"

@interface JoinMeetingViewController ()
@property (nonatomic, strong) UITextField *confIdTextField;
@property (nonatomic, strong) UITextField *codeTextField;
@property (nonatomic, strong) UITextField *nickTextField;
@property (nonatomic, strong) UITextField *nickCNTextField;
@property (nonatomic, strong) UITextField *nickENTextField;
@property (nonatomic, strong) UITextField *randomTextField;
@property (nonatomic, strong) UITextField *domainTextField;

@property (nonatomic, strong) UISwitch *cameraSwitch;
@property (nonatomic, strong) UISwitch *micSwitch;
@property (nonatomic, strong) UISwitch *stopConflictConfSwitch;
@property (nonatomic, strong) UISwitch *earpieceSwitch;
@property (nonatomic, strong) UISwitch *hidePasswordAlertSwitch;
@property (nonatomic, strong) UIScrollView *scrollView;

@end

@implementation JoinMeetingViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"加入会议";
}

- (void)setupViews {
    [super setupViews];
    
    self.scrollView = [[UIScrollView alloc] init];
    [self.view addSubview:self.scrollView];
    [self.scrollView addTapAction:@selector(touchesBegan) target:self];
    [self.scrollView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.bottom.mas_equalTo(0);
        make.width.mas_equalTo(Screen_Width);
    }];
    if (@available(iOS 11.0, *)) {
        self.scrollView.contentInsetAdjustmentBehavior = UIScrollViewContentInsetAdjustmentNever;
    }
    
    self.confIdTextField = [[UITextField alloc] init];
    [self.scrollView addSubview:self.confIdTextField];
    self.confIdTextField.placeholder = @"会议ID";
    self.confIdTextField.text = @"";
    self.confIdTextField.accessibilityIdentifier = HWMJoinConfConfId;
    [self.confIdTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(100);
        make.height.mas_equalTo(30);
        make.left.mas_equalTo(50);
        make.right.mas_equalTo(-50);
        make.width.mas_equalTo(Screen_Width - 100);
    }];
    [UIView addBottomLineWithView:self.confIdTextField parentView:self.scrollView];
    
    self.codeTextField = [[UITextField alloc] init];
    [self.scrollView addSubview:self.codeTextField];
    self.codeTextField.placeholder = @"会议密码";
    self.codeTextField.text = @"";
    self.codeTextField.accessibilityIdentifier = HWMJoinConfPwd;
    [self.codeTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.confIdTextField.mas_bottom).mas_offset(25);
        make.height.mas_equalTo(self.confIdTextField);
        make.left.right.mas_equalTo(self.confIdTextField);
    }];
    [UIView addBottomLineWithView:self.codeTextField parentView:self.scrollView];
    
    
    self.nickTextField = [[UITextField alloc] init];
    [self.scrollView addSubview:self.nickTextField];
    self.nickTextField.placeholder = @"用户昵称";
    self.nickTextField.accessibilityIdentifier = HWMJoinConfNick;
    [self.nickTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.codeTextField.mas_bottom).mas_offset(25);
        make.height.mas_equalTo(self.confIdTextField);
        make.left.right.mas_equalTo(self.confIdTextField);
    }];
    [UIView addBottomLineWithView:self.nickTextField parentView:self.scrollView];
    
    self.nickCNTextField = [[UITextField alloc] init];
    [self.scrollView addSubview:self.nickCNTextField];
    self.nickCNTextField.placeholder = @"用户昵称(中文)";
    self.nickCNTextField.accessibilityIdentifier = HWMJoinConfNickCn;
    [self.nickCNTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.nickTextField.mas_bottom).mas_offset(25);
        make.height.left.right.mas_equalTo(self.nickTextField);
    }];
    [UIView addBottomLineWithView:self.nickCNTextField parentView:self.scrollView];
    
    self.nickENTextField = [[UITextField alloc] init];
    [self.scrollView addSubview:self.nickENTextField];
    self.nickENTextField.placeholder = @"用户昵称(英文)";
    self.nickENTextField.accessibilityIdentifier = HWMJoinConfNickEn;
    [self.nickENTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.nickCNTextField.mas_bottom).mas_offset(25);
        make.height.left.right.mas_equalTo(self.nickCNTextField);
    }];
    [UIView addBottomLineWithView:self.nickENTextField parentView:self.scrollView];
    
    self.randomTextField = [[UITextField alloc] init];
    [self.scrollView addSubview:self.randomTextField];
    self.randomTextField.placeholder = @"random入会时填写";
    self.randomTextField.accessibilityIdentifier = HWMJoinConfRandom;
    [self.randomTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.nickENTextField.mas_bottom).mas_offset(25);
        make.height.mas_equalTo(self.confIdTextField);
        make.left.right.mas_equalTo(self.confIdTextField);
    }];
    [UIView addBottomLineWithView:self.randomTextField parentView:self.scrollView];

    self.domainTextField = [[UITextField alloc] init];
    [self.scrollView addSubview:self.domainTextField];
    self.domainTextField.placeholder = @"domain";
    [self.domainTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.randomTextField.mas_bottom).mas_offset(25);
        make.height.mas_equalTo(self.confIdTextField);
        make.left.right.mas_equalTo(self.confIdTextField);
    }];
    [UIView addBottomLineWithView:self.domainTextField parentView:self.scrollView];

    UILabel * cameraLabel = [self newLabelWithTitle:@"打开摄像头"];
    [self.scrollView addSubview:cameraLabel];
    [cameraLabel mas_makeConstraints:^(MASConstraintMaker *make) {
      make.top.mas_equalTo(self.domainTextField.mas_bottom).mas_offset(20);
      make.left.mas_equalTo(self.confIdTextField);
    }];
      
    self.cameraSwitch = [[UISwitch alloc] init];
    [self.scrollView addSubview:self.cameraSwitch];
    self.cameraSwitch.on = NO;
    self.cameraSwitch.accessibilityIdentifier = HWMJoinConfCamera;
    [self.cameraSwitch mas_makeConstraints:^(MASConstraintMaker *make) {
      make.centerY.mas_equalTo(cameraLabel);
      make.right.mas_equalTo(-50);
    }];
    
    UILabel * micLabel = [self newLabelWithTitle:@"打开麦克风"];
    [self.scrollView addSubview:micLabel];
    [micLabel mas_makeConstraints:^(MASConstraintMaker *make) {
      make.top.mas_equalTo(cameraLabel.mas_bottom).mas_offset(20);
      make.left.mas_equalTo(self.confIdTextField);
    }];
      
    self.micSwitch = [[UISwitch alloc] init];
    [self.scrollView addSubview:self.micSwitch];
    self.micSwitch.on = NO;
    self.micSwitch.accessibilityIdentifier = HWMJoinConfMic;
    [self.micSwitch mas_makeConstraints:^(MASConstraintMaker *make) {
      make.centerY.mas_equalTo(micLabel);
      make.right.mas_equalTo(-50);
    }];
    
    UILabel *stopConflictConfLabel = [self newLabelWithTitle:@"会议ID入会强制结束冲突的vmr会议(random入会不可用)"];
    [stopConflictConfLabel setContentCompressionResistancePriority:UILayoutPriorityDefaultLow forAxis:UILayoutConstraintAxisHorizontal];
    [self.scrollView addSubview:stopConflictConfLabel];
    stopConflictConfLabel.numberOfLines = 0;
    [stopConflictConfLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(micLabel.mas_bottom).mas_offset(20);
        make.left.mas_equalTo(self.confIdTextField);
        make.right.equalTo(self.micSwitch.mas_left).offset(-20);
    }];
      
    self.stopConflictConfSwitch = [[UISwitch alloc] init];
    [self.scrollView addSubview:self.stopConflictConfSwitch];
    self.stopConflictConfSwitch.on = NO;
    [self.stopConflictConfSwitch mas_makeConstraints:^(MASConstraintMaker *make) {
      make.centerY.mas_equalTo(stopConflictConfLabel);
      make.right.mas_equalTo(-50);
    }];
    
    UILabel * earpieceLabel = [self newLabelWithTitle:@"打开听筒"];
    [self.scrollView addSubview:earpieceLabel];
    [earpieceLabel mas_makeConstraints:^(MASConstraintMaker *make) {
      make.top.mas_equalTo(self.stopConflictConfSwitch.mas_bottom).mas_offset(20);
      make.left.mas_equalTo(self.confIdTextField);
    }];
      
    self.earpieceSwitch = [[UISwitch alloc] init];
    [self.scrollView addSubview:self.earpieceSwitch];
    self.earpieceSwitch.on = NO;
    self.earpieceSwitch.accessibilityIdentifier = HWMJoinConfEarpiece;
    [self.earpieceSwitch mas_makeConstraints:^(MASConstraintMaker *make) {
      make.centerY.mas_equalTo(earpieceLabel);
      make.right.mas_equalTo(-50);
    }];
    
    UILabel *hidePasswordAlertLabel = [self newLabelWithTitle:@"关闭密码弹窗"];
    [self.scrollView addSubview:hidePasswordAlertLabel];
    [hidePasswordAlertLabel mas_makeConstraints:^(MASConstraintMaker *make) {
      make.top.mas_equalTo(self.earpieceSwitch.mas_bottom).mas_offset(20);
      make.left.mas_equalTo(self.confIdTextField);
    }];
      
    self.hidePasswordAlertSwitch = [[UISwitch alloc] init];
    [self.scrollView addSubview:self.hidePasswordAlertSwitch];
    self.hidePasswordAlertSwitch.on = NO;
    self.hidePasswordAlertSwitch.accessibilityIdentifier = HWMJoinConfPwdAlert;
    [self.hidePasswordAlertSwitch mas_makeConstraints:^(MASConstraintMaker *make) {
      make.centerY.mas_equalTo(hidePasswordAlertLabel);
      make.right.mas_equalTo(-50);
    }];
    
    UIButton * joinMeetingBtn = [UIButton newButtonWithTitle:@"加入会议"];
    joinMeetingBtn.accessibilityIdentifier = HWMJoinConfJoinConf;
    [self.scrollView addSubview:joinMeetingBtn];
    [joinMeetingBtn addTarget:self action:@selector(joinMeeting) forControlEvents:UIControlEventTouchUpInside];
    [joinMeetingBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(hidePasswordAlertLabel.mas_bottom).mas_offset(50);
        make.left.right.mas_equalTo(self.confIdTextField);
        make.height.mas_equalTo(50);
        make.bottom.mas_equalTo(-100);
    }];
}

- (void)joinMeeting {
    if (![HWMSdk hasInit]) {
        [UIUtil showMessage:@"请先初始化"];
        return;
    }
    if (self.codeTextField.text.length == 0 && self.randomTextField.text.length > 0) {
        [self joinConfByRandom];
    } else {
        [self joinConfById];
    }
}

/// 会议Id入会
- (void)joinConfById {
    HWMJoinConfParam *param = [[HWMJoinConfParam alloc] init];
    param.confId = self.confIdTextField.text;
    param.password = self.codeTextField.text;
    param.nickname = self.nickTextField.text;
    param.isCameraOn = self.cameraSwitch.isOn;
    param.isMicOn = self.micSwitch.isOn;
    param.isStopConflictConf = self.stopConflictConfSwitch.isOn;
    param.isSpeakerOff = self.earpieceSwitch.isOn;
    param.aliasCN = self.nickCNTextField.text;
    param.aliasEN = self.nickENTextField.text;
    param.isHidePasswordAlert = self.hidePasswordAlertSwitch.isOn;
    [self showLoading];
    [[HWMSdk getOpenApi] joinConf:param callback:^(NSError * _Nullable error, id  _Nullable result) {
        [self hideLoading];
        if (error) {
            //vmr会议冲突在内部处理了，此处不需要处理
            if (error.code != HWMSDKCmsOnlineConfInCommunal) {
                [UIUtil showMessageWithError:error];
            }
        }else{
            NSLog(@"入会成功");
        }
    }];
}

/// random入会
- (void)joinConfByRandom {
    HWMRandomConfParam *param = [[HWMRandomConfParam alloc] init];
    param.confId = self.confIdTextField.text;
    param.random = self.randomTextField.text;
    param.nickname = self.nickTextField.text;
    param.isCameraOn = self.cameraSwitch.isOn;
    param.isMicOn = self.micSwitch.isOn;
    param.domain = self.domainTextField.text;
    param.isSpeakerOff = self.earpieceSwitch.isOn;
    param.aliasCN = self.nickCNTextField.text;
    param.aliasEN = self.nickENTextField.text;
    [self showLoading];
    [[HWMSdk getOpenApi] joinConf:param callback:^(NSError * _Nullable error, id  _Nullable result) {
        [self hideLoading];
        if (error) {
            //vmr会议冲突在内部处理了，此处不需要处理
            if (error.code != HWMSDKCmsOnlineConfInCommunal) {
                [UIUtil showMessageWithError:error];
            }
        }else{
            NSLog(@"入会成功");
        }
    }];
}

- (UILabel *)newLabelWithTitle:(NSString *)title {
    UILabel * label = [[UILabel alloc] init];
    label.text = title;
    label.font = [UIFont systemFontOfSize:16];
    label.textColor = HexColor(0x333333);
    return label;
}

- (void)touchesBegan {
    [self.view endEditing:YES];
}

@end
