//
//  LoginViewController.m
//  HWMSDKDemo
//
//  Created by adminstrator on 2020/4/1.
//  Copyright © 2020 HuaWei. All rights reserved.
//

#import "LoginViewController.h"
#import <HWMUISDK/HWMUISDK.h>
#import "UIUtil.h"
#import "LoginUtil.h"
#import "LoginManager.h"

@interface LoginViewController ()

@property (nonatomic, strong) UITextField *accountTextField;
@property (nonatomic, strong) UITextField *pwdTextField;

@end

@implementation LoginViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.title = @"登录";
    NSLog(@"%@", [self class]);
}

- (void)setupViews {
    [super setupViews];
    UILabel * accountLabel = [[UILabel alloc] init];
    [self.view addSubview:accountLabel];
    accountLabel.text = @"账  号:";
    accountLabel.font = [UIFont systemFontOfSize:16];
    accountLabel.textColor = HexColor(0x666666);
    [accountLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(50);
        make.width.mas_equalTo(60);
        make.top.mas_equalTo(120);
    }];
    
    self.accountTextField = [[UITextField alloc] init];
    [self.view addSubview:self.accountTextField];
    self.accountTextField.placeholder = @"请输入您的账号";
    self.accountTextField.accessibilityIdentifier = HWMLoginAccount;
    [self.accountTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.mas_equalTo(accountLabel);
        make.height.mas_equalTo(30);
        make.left.mas_equalTo(accountLabel.mas_right);
        make.right.mas_equalTo(-50);
    }];
    
    UILabel * accountLineLabel = [[UILabel alloc] init];
    [self.view addSubview:accountLineLabel];
    accountLineLabel.backgroundColor = HexColor(0xf2f2f2);
    [accountLineLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.accountTextField.mas_bottom).mas_offset(1);
        make.height.mas_equalTo(1);
        make.left.right.mas_equalTo(self.accountTextField);
    }];
    
    
    UILabel * pwdLabel = [[UILabel alloc] init];
    [self.view addSubview:pwdLabel];
    pwdLabel.text = @"密  码:";
    pwdLabel.font = [UIFont systemFontOfSize:16];
    pwdLabel.textColor = HexColor(0x666666);
    [pwdLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(accountLabel);
        make.top.mas_equalTo(accountLabel.mas_bottom).mas_offset(30);
    }];
    
    self.pwdTextField = [[UITextField alloc] init];
    [self.view addSubview:self.pwdTextField];
    self.pwdTextField.placeholder = @"请输入您的密码";
    self.pwdTextField.accessibilityIdentifier = HWMLoginPassword;
    [self.pwdTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.mas_equalTo(pwdLabel);
        make.height.mas_equalTo(self.accountTextField);
        make.left.right.mas_equalTo(self.accountTextField);
    }];
    
    UILabel * pwdLineLabel = [[UILabel alloc] init];
    [self.view addSubview:pwdLineLabel];
    pwdLineLabel.backgroundColor = HexColor(0xf2f2f2);
    [pwdLineLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.pwdTextField.mas_bottom);
        make.height.mas_equalTo(1);
        make.left.right.mas_equalTo(self.pwdTextField);
    }];
    
    UIButton * loginBtn = [UIButton newButtonWithTitle:@"登录"];
    [self.view addSubview:loginBtn];
    loginBtn.accessibilityIdentifier = HWMLoginLogin;
    [loginBtn addTarget:self action:@selector(loginClick) forControlEvents:UIControlEventTouchUpInside];
    [loginBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(pwdLabel.mas_bottom).mas_offset(50);
        make.left.mas_equalTo(accountLabel);
        make.height.mas_equalTo(50);
        make.right.mas_equalTo(self.accountTextField);
    }];
}

- (void)loginClick {
    [self.view endEditing:YES];
    if (![HWMSdk hasInit]) {
        [UIUtil showMessage:@"请先初始化"];
        return;
    }
    NSString *account = self.accountTextField.text;
    if (account.length == 0) {
        [UIUtil showMessage:@"账号不能为空" vc:self];
        return;
    }
    NSString *password = self.pwdTextField.text;
    if (password.length == 0) {
        [UIUtil showMessage:@"密码不能为空" vc:self];
        return;
    }
    [self showLoading];
    [[HWMSdk getOpenApi] login:account password:password callback:^(NSError * _Nullable error, HWMLoginResult * _Nullable result) {
        [self hideLoading];
        if (error == nil) {
            [[LoginManager sharedInstance] updateHasLogin:YES];
            NSString * msg = [NSString stringWithFormat:@"登录成功\nuuid:%@\naccount:%@\nthirdAccount:%@", result.userUuid, result.account, result.thirdAccount];
            [UIUtil showMessage:msg vc:self];
        }else{
            // 412100044:服务器降级，接入方收到该错误码可以继续调用入会接口离线入会
            [UIUtil showMessageWithError:error];
        }
        
    }];
}

@end
