//
//  P2PConfViewController.m
//  HWMSDKDemo
//
//  Created by yaolili/ywx577644 on 2023/6/8.
//  Copyright © 2023 HuaWei. All rights reserved.
//

#import "P2PConfViewController.h"
#import "MediaTypeSwitchView.h"
#import <HWMUISDK/HWMUISDK.h>
#import "UIUtil.h"

@interface P2PConfViewController ()

@property (nonatomic, strong) UITextField *numberTextField;
@property (nonatomic, strong) UITextField *accountTextField;
@property (nonatomic, strong) UITextField *useridTextField;
@property (nonatomic, strong) UITextField *calleeNickNameTextField;
@property (nonatomic, strong) UITextField *calleeCnNickNameTextField;
@property (nonatomic, strong) UITextField *calleeEnNickNameTextField;
@property (nonatomic, strong) UITextField *calleeExtendedFieldTextField;
@property (nonatomic, strong) UITextField *calleeOrgIdTextField;
@property (nonatomic, strong) UITextField *callerNickNameTextField;
@property (nonatomic, strong) UITextField *callerCnNickNameTextField;
@property (nonatomic, strong) UITextField *callerEnNickNameTextField;
@property (nonatomic, strong) UITextField *callerExtendedFieldTextField;
@property (nonatomic, strong) UITextField *customInfoTextField;
@property (nonatomic, strong) UISwitch *videoSwitch;
@property (nonatomic, strong) UIScrollView *scrollView;
@property (nonatomic, strong) UILabel *joinConfRestrictionLabel;
@property (nonatomic, assign) HWMJoinConfRestrictionType confAllowJoinUser;
@property (nonatomic, strong) UISwitch *pwdSwitch;
@property (nonatomic, strong) UISwitch *earpieceSwitch;

@end

@implementation P2PConfViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"立即会议";
}
- (void)setupViews {
    [super setupViews];
    
    self.scrollView = [[UIScrollView alloc] init];
    [self.view addSubview:self.scrollView];
    [self.scrollView addTapAction:@selector(touchesBegan) target:self];
    [self.scrollView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.bottom.mas_equalTo(0);
        make.width.mas_equalTo(Screen_Width);
    }];
    
    UILabel *cameraLabel = [self newLabelWithTitle:@"视频呼叫"];
    [self.scrollView addSubview:cameraLabel];
    [cameraLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(50);
        make.leading.mas_equalTo(50);
    }];

    self.videoSwitch = [[UISwitch alloc] init];
    [self.scrollView addSubview:self.videoSwitch];
    self.videoSwitch.on = YES;
    [self.videoSwitch mas_makeConstraints:^(MASConstraintMaker *make) {
      make.centerY.mas_equalTo(cameraLabel);
      make.trailing.mas_equalTo(-50);
    }];
    
    self.numberTextField = [[UITextField alloc] init];
    [self.scrollView addSubview:self.numberTextField];
    self.numberTextField.placeholder = @"被叫号码";
    self.numberTextField.accessibilityIdentifier = HWMCallNumber;
    [self.numberTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(cameraLabel.mas_bottom).mas_offset(25);
        make.height.mas_equalTo(30);
        make.leading.mas_equalTo(50);
        make.trailing.mas_equalTo(-50);
        make.width.mas_equalTo(Screen_Width - 100);
    }];
    [UIView addBottomLineWithView:self.numberTextField parentView:self.scrollView];
    
    self.useridTextField = [[UITextField alloc] init];
    [self.scrollView addSubview:self.useridTextField];
    self.useridTextField.placeholder = @"被叫账号(第三方账号userid)";
    self.useridTextField.accessibilityIdentifier = HWMCallUserId;
    [self.useridTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.numberTextField.mas_bottom).mas_offset(25);
        make.height.mas_equalTo(self.numberTextField);
        make.leading.trailing.mas_equalTo(self.numberTextField);
    }];
    [UIView addBottomLineWithView:self.useridTextField parentView:self.scrollView];
    
    self.calleeNickNameTextField = [[UITextField alloc] init];
    [self.scrollView addSubview:self.calleeNickNameTextField];
    self.calleeNickNameTextField.placeholder = @"被叫昵称";
    self.calleeNickNameTextField.accessibilityIdentifier = HWMCallNickName;
    [self.calleeNickNameTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.useridTextField.mas_bottom).mas_offset(25);
        make.height.mas_equalTo(self.numberTextField);
        make.leading.trailing.mas_equalTo(self.numberTextField);
    }];
    [UIView addBottomLineWithView:self.calleeNickNameTextField parentView:self.scrollView];
    
    self.calleeCnNickNameTextField = [[UITextField alloc] init];
    [self.scrollView addSubview:self.calleeCnNickNameTextField];
    self.calleeCnNickNameTextField.placeholder = @"被叫中文昵称";
    self.calleeCnNickNameTextField.accessibilityIdentifier = HWMCallCnNickName;
    [self.calleeCnNickNameTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.calleeNickNameTextField.mas_bottom).mas_offset(25);
        make.height.mas_equalTo(self.numberTextField);
        make.leading.trailing.mas_equalTo(self.numberTextField);
    }];
    [UIView addBottomLineWithView:self.calleeCnNickNameTextField parentView:self.scrollView];
    
    self.calleeEnNickNameTextField = [[UITextField alloc] init];
    [self.scrollView addSubview:self.calleeEnNickNameTextField];
    self.calleeEnNickNameTextField.placeholder = @"被叫英文昵称";
    self.calleeEnNickNameTextField.accessibilityIdentifier = HWMCallEnNickName;
    [self.calleeEnNickNameTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.calleeCnNickNameTextField.mas_bottom).mas_offset(25);
        make.height.mas_equalTo(self.numberTextField);
        make.leading.trailing.mas_equalTo(self.numberTextField);
    }];
    [UIView addBottomLineWithView:self.calleeEnNickNameTextField parentView:self.scrollView];
    
    self.accountTextField = [[UITextField alloc] init];
    [self.scrollView addSubview:self.accountTextField];
    self.accountTextField.placeholder = @"被叫账号";
    self.accountTextField.accessibilityIdentifier = HWMCallAccount;
    [self.accountTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.calleeEnNickNameTextField.mas_bottom).mas_offset(25);
        make.height.mas_equalTo(self.calleeNickNameTextField);
        make.leading.trailing.mas_equalTo(self.calleeNickNameTextField);
    }];
    [UIView addBottomLineWithView:self.accountTextField parentView:self.scrollView];
    
    self.calleeExtendedFieldTextField = [[UITextField alloc] init];
    [self.scrollView addSubview:self.calleeExtendedFieldTextField];
    self.calleeExtendedFieldTextField.placeholder = @"被叫扩展字段";
    self.calleeExtendedFieldTextField.accessibilityIdentifier = HWMCallExtendedField;
    [self.calleeExtendedFieldTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.accountTextField.mas_bottom).mas_offset(25);
        make.height.mas_equalTo(self.numberTextField);
        make.leading.trailing.mas_equalTo(self.numberTextField);
    }];
    [UIView addBottomLineWithView:self.calleeExtendedFieldTextField parentView:self.scrollView];
    
    self.calleeOrgIdTextField = [[UITextField alloc] init];
    [self.scrollView addSubview:self.calleeOrgIdTextField];
    self.calleeOrgIdTextField.placeholder = @"被叫企业id";
    self.calleeOrgIdTextField.accessibilityIdentifier = HWMCallCorpId;
    [self.calleeOrgIdTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.calleeExtendedFieldTextField.mas_bottom).mas_offset(25);
        make.height.mas_equalTo(self.numberTextField);
        make.leading.trailing.mas_equalTo(self.numberTextField);
    }];
    [UIView addBottomLineWithView:self.calleeOrgIdTextField parentView:self.scrollView];
    
    self.callerNickNameTextField = [[UITextField alloc] init];
    [self.scrollView addSubview:self.callerNickNameTextField];
    self.callerNickNameTextField.placeholder = @"主叫昵称";
    self.callerNickNameTextField.accessibilityIdentifier = HWMCallNickName;
    [self.callerNickNameTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.calleeOrgIdTextField.mas_bottom).mas_offset(25);
        make.height.mas_equalTo(self.accountTextField);
        make.leading.trailing.mas_equalTo(self.accountTextField);
    }];
    [UIView addBottomLineWithView:self.callerNickNameTextField parentView:self.scrollView];
    
    self.callerCnNickNameTextField = [[UITextField alloc] init];
    [self.scrollView addSubview:self.callerCnNickNameTextField];
    self.callerCnNickNameTextField.placeholder = @"主叫中文昵称";
    self.callerCnNickNameTextField.accessibilityIdentifier = HWMCallCnNickName;
    [self.callerCnNickNameTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.callerNickNameTextField.mas_bottom).mas_offset(25);
        make.height.mas_equalTo(self.accountTextField);
        make.leading.trailing.mas_equalTo(self.accountTextField);
    }];
    [UIView addBottomLineWithView:self.callerCnNickNameTextField parentView:self.scrollView];
    
    self.callerEnNickNameTextField = [[UITextField alloc] init];
    [self.scrollView addSubview:self.callerEnNickNameTextField];
    self.callerEnNickNameTextField.placeholder = @"主叫英文昵称";
    self.callerEnNickNameTextField.accessibilityIdentifier = HWMCallEnNickName;
    [self.callerEnNickNameTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.callerCnNickNameTextField.mas_bottom).mas_offset(25);
        make.height.mas_equalTo(self.accountTextField);
        make.leading.trailing.mas_equalTo(self.accountTextField);
    }];
    [UIView addBottomLineWithView:self.callerEnNickNameTextField parentView:self.scrollView];
    
    self.callerExtendedFieldTextField = [[UITextField alloc] init];
    [self.scrollView addSubview:self.callerExtendedFieldTextField];
    self.callerExtendedFieldTextField.placeholder = @"主叫扩展字段";
    self.callerExtendedFieldTextField.accessibilityIdentifier = HWMCallExtendedField;
    [self.callerExtendedFieldTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.callerEnNickNameTextField.mas_bottom).mas_offset(25);
        make.height.mas_equalTo(self.accountTextField);
        make.leading.trailing.mas_equalTo(self.accountTextField);
    }];
    [UIView addBottomLineWithView:self.callerExtendedFieldTextField parentView:self.scrollView];
    
    self.customInfoTextField = [[UITextField alloc] init];
    [self.scrollView addSubview:self.customInfoTextField];
    self.customInfoTextField.placeholder = @"自定义字段";
    self.customInfoTextField.accessibilityIdentifier = HWMCallCustomInfoField;
    [self.customInfoTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.callerExtendedFieldTextField.mas_bottom).mas_offset(25);
        make.height.mas_equalTo(self.accountTextField);
        make.leading.trailing.mas_equalTo(self.accountTextField);
    }];
    [UIView addBottomLineWithView:self.customInfoTextField parentView:self.scrollView];
    
    UILabel *joinConfRestrictionLabel = [self newLabelWithTitle:@"允许入会"];
    [self.scrollView addSubview:joinConfRestrictionLabel];
    joinConfRestrictionLabel.userInteractionEnabled = YES;
    [joinConfRestrictionLabel addTapAction:@selector(selectJoinConfRestriction:) target:self];
    [joinConfRestrictionLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(50);
        make.trailing.mas_equalTo(self.customInfoTextField);
        make.top.mas_equalTo(self.customInfoTextField.mas_bottom).mas_offset(20);
    }];
    
    self.joinConfRestrictionLabel = [self newLabelWithTitle:@""];
    [self.scrollView addSubview:self.joinConfRestrictionLabel];
    [self updateJoinConfRestrictionLabelText];
    [self.joinConfRestrictionLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.trailing.mas_equalTo(self.callerExtendedFieldTextField);
        make.centerY.mas_equalTo(joinConfRestrictionLabel);
    }];
    
    UILabel *guestJoinConfWithoutPwdLabel = [self newLabelWithTitle:@"是否需要来宾密码"];
    [self.scrollView addSubview:guestJoinConfWithoutPwdLabel];
    [guestJoinConfWithoutPwdLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(joinConfRestrictionLabel.mas_bottom).mas_offset(25);
        make.leading.mas_equalTo(joinConfRestrictionLabel);
    }];

    self.pwdSwitch = [[UISwitch alloc] init];
    [self.scrollView addSubview:self.pwdSwitch];
    self.pwdSwitch.on = YES;
    [self.pwdSwitch mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.mas_equalTo(guestJoinConfWithoutPwdLabel);
        make.trailing.mas_equalTo(-50);
    }];
    
    UILabel *earpieceLabel = [self newLabelWithTitle:@"打开听筒"];
    [self.scrollView addSubview:earpieceLabel];
    [earpieceLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(guestJoinConfWithoutPwdLabel.mas_bottom).mas_offset(25);
        make.leading.mas_equalTo(guestJoinConfWithoutPwdLabel);
    }];

    self.earpieceSwitch = [[UISwitch alloc] init];
    [self.scrollView addSubview:self.earpieceSwitch];
    self.earpieceSwitch.on = NO;
    [self.earpieceSwitch mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.mas_equalTo(earpieceLabel);
        make.trailing.mas_equalTo(-50);
    }];
    
    UIButton *callBtn = [UIButton newButtonWithTitle:@"发起立即会议"];
    callBtn.accessibilityIdentifier = HWMCallCall;
    [self.scrollView addSubview:callBtn];
    [callBtn addTarget:self action:@selector(initiateCall) forControlEvents:UIControlEventTouchUpInside];
    [callBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(earpieceLabel.mas_bottom).mas_offset(50);
        make.leading.trailing.mas_equalTo(self.calleeNickNameTextField);
        make.height.mas_equalTo(50);
        make.bottom.mas_equalTo(-150);
    }];
}

- (void)touchesBegan {
    [self endEdit];
}

- (void)endEdit {
    [self.scrollView endEditing:YES];
}
 
 
- (void)initiateCall {
    if (![HWMSdk hasInit]) {
        [UIUtil showMessage:@"请先初始化"];
        return;
    }
    
    [self startP2PConf];
}

- (void)startP2PConf {
    HWMCalleeInfo *calleeInfo = [[HWMCalleeInfo alloc] init];
    calleeInfo.nickName = self.calleeNickNameTextField.text;
    calleeInfo.number = self.numberTextField.text;
    calleeInfo.thirdUserId = self.useridTextField.text;
    calleeInfo.aliasCN = self.calleeCnNickNameTextField.text;
    calleeInfo.aliasEN = self.calleeEnNickNameTextField.text;
    calleeInfo.extendedField = self.calleeExtendedFieldTextField.text;
    calleeInfo.orgId = self.calleeOrgIdTextField.text;

    HWMCallerInfo *callerInfo = [[HWMCallerInfo alloc] init];
    callerInfo.nickName = self.callerNickNameTextField.text;
    callerInfo.aliasCN = self.callerCnNickNameTextField.text;
    callerInfo.aliasEN = self.callerEnNickNameTextField.text;
    callerInfo.extendedField = self.callerExtendedFieldTextField.text;
    
    HWMStartP2PConfParam *param = [[HWMStartP2PConfParam alloc] init];
    param.mediaType = self.videoSwitch.isOn ? HWMMediaTypeVideo : HWMMediaTypeAudio;
    param.calleeInfo = calleeInfo;
    param.callerInfo = callerInfo;
    param.isGuestJoinConfWithoutPwd = !self.pwdSwitch.isOn;
    param.confAllowJoinUser = self.confAllowJoinUser;
    param.isSpeakerOff = self.earpieceSwitch.isOn;
    param.customInfo = self.customInfoTextField.text;
    [[HWMSdk getOpenApi] startP2PConf:param callback:^(NSError * _Nullable error, HWMCreateConfResult * _Nullable result) {
        if (error) {
            [UIUtil showMessageWithError:error];
        } else {
            [UIUtil showMessage:[NSString stringWithFormat:@"会议ID：%@, isP2PConf:%@", result.confId, result.isP2PConf?@"YES":@"NO"]];
        }
    }];
}

- (UILabel *)newLabelWithTitle:(NSString *)title {
    UILabel * label = [[UILabel alloc] init];
    label.text = title;
    label.font = [UIFont systemFontOfSize:16];
    label.textColor = HexColor(0x333333);
    return label;
}

- (void)selectJoinConfRestriction:(UITapGestureRecognizer *)tap {
    UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"允许入会" message:nil preferredStyle:UIAlertControllerStyleActionSheet];
    if (Is_Ipad) {
        alertController.popoverPresentationController.sourceView = self.scrollView;
        alertController.popoverPresentationController.sourceRect = tap.view.frame;
    }
    UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleCancel handler:nil];
    cancelAction.accessibilityIdentifier = HWMCreatConfJoinConfRestrictionCancel;
    
    UIAlertAction *allAction = [UIAlertAction actionWithTitle:@"所有人" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        self.confAllowJoinUser = HWMJoinConfRestrictionAll;
        [self updateJoinConfRestrictionLabelText];
    }];
    allAction.accessibilityIdentifier = HWMCreatConfJoinConfRestrictionAll;
    UIAlertAction *companyAction = [UIAlertAction actionWithTitle:@"仅企业内人员" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        self.confAllowJoinUser = HWMJoinConfRestrictionCompany;
        [self updateJoinConfRestrictionLabelText];
    }];
    companyAction.accessibilityIdentifier = HWMCreatConfJoinConfRestrictionCompany;
    UIAlertAction *invitedAction = [UIAlertAction actionWithTitle:@"仅会议邀请人员" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        self.confAllowJoinUser = HWMJoinConfRestrictionInvited;
        [self updateJoinConfRestrictionLabelText];
    }];
    invitedAction.accessibilityIdentifier = HWMCreatConfJoinConfRestrictionInvited;
    [alertController addAction:cancelAction];
    [alertController addAction:allAction];
    [alertController addAction:companyAction];
    [alertController addAction:invitedAction];
    [self presentViewController:alertController animated:YES completion:nil];
}

- (void)updateJoinConfRestrictionLabelText {
    self.joinConfRestrictionLabel.text = [self getTitleAllowInComming:self.confAllowJoinUser];
}

- (NSString *)getTitleAllowInComming:(HWMJoinConfRestrictionType)confAllowJoinUser
{
    switch (confAllowJoinUser) {
        case HWMJoinConfRestrictionAll:
            return @"所有人";
            break;
        case HWMJoinConfRestrictionCompany:
            return @"仅企业内人员";
            break;
        case HWMJoinConfRestrictionInvited:
            return @"仅会议邀请人员";
            break;
        default:
            return @"";
            break;
    }
}

@end
