//
//  CustomUIViewController.m
//  HWMSDKDemo
//
//  Created by y00450113 on 2020/7/4.
//  Copyright © 2020 HuaWei. All rights reserved.
//

#import "CustomUIViewController.h"
#import <HWMUISDK/HWMUISDK.h>
#import "CustomInMeetingUIManager.h"
#import "UIUtil.h"
#import "CustomMenuViewController.h"
@interface CustomUIViewController ()

@end

@implementation CustomUIViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupDatas];
    [self setupTableView];
}

- (void)setupDatas {
    self.dataArray = @[[ActionModel initWithTitle:@"会中title点击的会议信息页面定制" type:CustomUITypeConfTitleInfo],
                       [ActionModel initWithTitle:@"音频呼叫底部会控菜单定制" type:CustomUITypeAudioCallToolBar],
                       [ActionModel initWithTitle:@"音频会议底部会控菜单定制" type:CustomUITypeAudioConfToolBar],
                       [ActionModel initWithTitle:@"视频呼叫底部会控菜单定制" type:CustomUITypeVideoCallToolBar],
                       [ActionModel initWithTitle:@"视频会议底部会控菜单定制" type:CustomUITypeVideoConfToolBar],
                       [ActionModel initWithTitle:@"音频会议更多菜单定制" type:CustomUITypeAudioConfMore],
                       [ActionModel initWithTitle:@"视频呼叫更多菜单定制" type:CustomUITypeVideoCallMore],
                       [ActionModel initWithTitle:@"视频会议更多菜单定制" type:CustomUITypeVideoConfMore],
                       [ActionModel initWithTitle:@"音频会议设置页面定制" type:CustomUITypeAudioConfSetting],
                       [ActionModel initWithTitle:@"视频呼叫设置页面定制" type:CustomUITypeVideoCallSetting],
                       [ActionModel initWithTitle:@"视频会议设置页面定制" type:CustomUITypeVideoConfSetting],
                       [ActionModel initWithTitle:@"与会者列表顶部菜单定制" type:CustomUITypeMemberListTitleBar],
                       [ActionModel initWithTitle:@"与会者列表底部菜单定制" type:CustomUITypeMemberListToolBar],
                       [ActionModel initWithTitle:@"与会者列表更多菜单更多" type:CustomUITypeMemberListMore],
                       [ActionModel initWithTitle:@"与会者操作actionSheet定制" type:CustomUITypeMemberListActionSheet],
                       [ActionModel initWithTitle:@"会中状态栏定制" type:CustomUITypeConfStatusBar],
                       [ActionModel initWithTitle:@"等候中列表底部菜单定制" type:CustomUITypeWaitingListToolBar],
                       [ActionModel initWithTitle:@"未入会列表底部菜单定制" type:CustomUITypeOfflineListToolBar]
                      
    ];
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    TableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"TableViewCell"];
    ActionModel *model = self.dataArray[indexPath.row];
    cell.titleLabel.text = model.title;
    return cell;
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    ActionModel *model = [self.dataArray objectAtIndex:indexPath.row];
    CustomMenuViewController *menuCustomCtrl = [[CustomMenuViewController alloc] initWithType:model.type title:model.title];
    [self.navigationController pushViewController:menuCustomCtrl animated:YES];
    
}
@end
