//
//  PrivateP2PConfViewController.m
//  HWMSDKDemo
//
//  Created by Shepherd on 2023/12/28.
//  Copyright © 2023 HuaWei. All rights reserved.
//

#import "PrivateP2PConfViewController.h"

@interface PrivateP2PConfViewController ()

@property (nonatomic, strong) UITextField *numberTextField;
@property (nonatomic, strong) UITextField *useridTextField;
@property (nonatomic, strong) UITextField *calleeNickNameTextField;
@property (nonatomic, strong) UISwitch *videoSwitch;

@end

@implementation PrivateP2PConfViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"立即会议";
}
- (void)setupViews {
    [super setupViews];
    
    UILabel *cameraLabel = [self newLabelWithTitle:@"视频呼叫"];
    [self.view addSubview:cameraLabel];
    [cameraLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(100);
        make.leading.mas_equalTo(50);
    }];

    self.videoSwitch = [[UISwitch alloc] init];
    [self.view addSubview:self.videoSwitch];
    self.videoSwitch.on = YES;
    [self.videoSwitch mas_makeConstraints:^(MASConstraintMaker *make) {
      make.centerY.mas_equalTo(cameraLabel);
      make.trailing.mas_equalTo(-50);
    }];
    
    self.numberTextField = [[UITextField alloc] init];
    [self.view addSubview:self.numberTextField];
    self.numberTextField.placeholder = @"被叫号码";
    self.numberTextField.accessibilityIdentifier = HWMCallNumber;
    [self.numberTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(cameraLabel.mas_bottom).mas_offset(25);
        make.height.mas_equalTo(30);
        make.leading.mas_equalTo(50);
        make.trailing.mas_equalTo(-50);
    }];
    [UIView addBottomLineWithView:self.numberTextField parentView:self.view];
    
    self.useridTextField = [[UITextField alloc] init];
    [self.view addSubview:self.useridTextField];
    self.useridTextField.placeholder = @"被叫账号(第三方账号userid)";
    self.useridTextField.accessibilityIdentifier = HWMCallUserId;
    [self.useridTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.numberTextField.mas_bottom).mas_offset(25);
        make.height.mas_equalTo(self.numberTextField);
        make.leading.trailing.mas_equalTo(self.numberTextField);
    }];
    [UIView addBottomLineWithView:self.useridTextField parentView:self.view];
    
    self.calleeNickNameTextField = [[UITextField alloc] init];
    [self.view addSubview:self.calleeNickNameTextField];
    self.calleeNickNameTextField.placeholder = @"被叫昵称";
    self.calleeNickNameTextField.accessibilityIdentifier = HWMCallNickName;
    [self.calleeNickNameTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.useridTextField.mas_bottom).mas_offset(25);
        make.height.mas_equalTo(self.numberTextField);
        make.leading.trailing.mas_equalTo(self.numberTextField);
    }];
    [UIView addBottomLineWithView:self.calleeNickNameTextField parentView:self.view];
    
    UIButton *callBtn = [UIButton newButtonWithTitle:@"发起立即会议"];
    callBtn.accessibilityIdentifier = HWMCallCall;
    [self.view addSubview:callBtn];
    [callBtn addTarget:self action:@selector(initiateCall) forControlEvents:UIControlEventTouchUpInside];
    [callBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.calleeNickNameTextField.mas_bottom).mas_offset(50);
        make.leading.trailing.mas_equalTo(self.calleeNickNameTextField);
        make.height.mas_equalTo(50);
    }];
}
 
 
- (void)initiateCall {
    if (![HWMSdk hasInit]) {
        [UIUtil showMessage:@"请先初始化"];
        return;
    }
    
    [self startP2PConf];
}

- (void)startP2PConf {
    HWMInternalStartCallParam *param = [[HWMInternalStartCallParam alloc] init];
    param.number = self.numberTextField.text;
    param.nickName = self.calleeNickNameTextField.text;
    param.contactsId = self.useridTextField.text;
    param.isVideo = self.videoSwitch.isOn;
    [[HWMSdk getPrivateApi] startCallWithParam:param isEncrypt:YES callback:^(NSError * _Nonnull error) {
        if (error) {
            [UIUtil showMessageWithError:error];
        }
    }];
    
}

- (UILabel *)newLabelWithTitle:(NSString *)title {
    UILabel * label = [[UILabel alloc] init];
    label.text = title;
    label.font = [UIFont systemFontOfSize:16];
    label.textColor = HexColor(0x333333);
    return label;
}

@end
