//
//  RemoteControlVerificationCodeViewController.m
//  HWMSDKDemo
//
//  Created by yaolili/ywx577644 on 2023/9/11.
//  Copyright © 2023 HuaWei. All rights reserved.
//

#import "RemoteControlVerificationCodeViewController.h"
#import "UIUtil.h"
#import "RemoteControlWebViewController.h"

@interface RemoteControlVerificationCodeViewController ()

@property (weak, nonatomic) IBOutlet UITextField *verificationCodeTextField;

@end

@implementation RemoteControlVerificationCodeViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view from its nib.
}

- (void)viewDidLayoutSubviews {
    [super viewDidLayoutSubviews];
    self.activityIndicator.frame = self.view.bounds;
}

- (IBAction)pairBtnClick:(UIButton *)sender {
    [self showLoading];
    self.pairInfo.verifyCode = self.verificationCodeTextField.text;
    [[HWMRoomsControllerSdk getRoomsControllerOpenApi] requestPair:self.pairInfo successCallback:^(HWMSDKRequestPairResultModel * _Nonnull requestPairResult) {
        [self hideLoading];
        self.verificationCodeTextField.text = @"";
        [self showWebviewWithNonce:requestPairResult.nonce code:requestPairResult.code isForce:self.pairInfo.isForcePair];
    } failedCallback:^(NSError * _Nullable error) {
        [self hideLoading];
        self.verificationCodeTextField.text = @"";
        NSString *msg = @"设备配对失败";
        if (error.code == HWMSDKUsgOfflinePairDoubleCheckFailed) {
            msg = @"验证码错误，请重新输入";
        } else if (error.code == HWMSDKUsgOfflinePairCodeInvalid) {
            msg = @"配对码错误，请重新输入";
        }
        [UIUtil showMessage:msg error:error];
    }];
}

- (void)showWebviewWithNonce:(NSString *)nonce code:(NSString *)code isForce:(BOOL)isForce {
    RemoteControlWebViewController *ctrl = [[RemoteControlWebViewController alloc] initWithNonce:nonce code:code isForce:isForce];
    [self.navigationController pushViewController:ctrl animated:YES];
}

- (void)showLoading {
    [self.activityIndicator startAnimating];
}

- (void)hideLoading {
    [self.activityIndicator stopAnimating];
}

@end
