//
//  ShareView.m
//  HWMSDKDemo
//
//  Created by guoyongliang/gwx917154 on 2020/6/11.
//  Copyright © 2020 HuaWei. All rights reserved.
//

#import "ShareView.h"
#import "UIView+HWM.h"
const CGFloat bottomViewHeight = 158;
@interface ShareView ()
@property (nonatomic, strong) UIView *bottomView;
@property (nonatomic, copy) ItemBlock itemBlcok;
@end

@implementation ShareView

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    self.frame = [UIScreen mainScreen].bounds;
    if (self) {
        [self createViews];
    }
    return self;
}

- (void)createViews {
    self.bottomView = [[UIView alloc] initWithFrame:CGRectMake(0, Screen_Height, Screen_Width, bottomViewHeight)];
    self.bottomView.backgroundColor = [UIColor whiteColor];
    [self addSubview:self.bottomView];
    NSArray *items = @[@{ @"image": @"hwm_share_sms", @"title": @"短息邀请" }, @{ @"image": @"hwm_share_link", @"title": @"复制链接" }];
    CGFloat itemWid = Screen_Width / 4.0;
    for (int i = 0; i < items.count; i++) {
        UIView *itemView = [[UIView alloc] initWithFrame:CGRectMake(itemWid * i, 0, itemWid, 50)];
        [self.bottomView addSubview:itemView];
        itemView.tag = i;
        itemView.userInteractionEnabled = YES;
        [itemView addTapAction:@selector(itemViewClick:) target:self];
        UIImageView *imageView = [[UIImageView alloc] init];
        imageView.backgroundColor = RandomColor;
        [itemView addSubview:imageView];
        [imageView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerX.equalTo(0);
            make.top.equalTo(0).offset(20);
            make.size.mas_equalTo(CGSizeMake(50.0, 50.0));
        }];

        UILabel *label = [[UILabel alloc] init];
        label.font = [UIFont systemFontOfSize:12];
        label.textAlignment = NSTextAlignmentCenter;
        [itemView addSubview:label];
        [label mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerX.equalTo(imageView);
            make.top.equalTo(imageView.mas_bottom).offset(12);
            make.left.mas_offset(5);
            make.right.mas_offset(-5);
        }];

        imageView.image = [UIImage imageNamed:items[i][@"image"]];
        label.text = items[i][@"title"];
    }

    UIButton *cancelBtn = [UIButton buttonWithType:UIButtonTypeSystem];
    cancelBtn.frame = CGRectMake(0, bottomViewHeight - 50, Screen_Width, 50);
    [cancelBtn setBackgroundColor:HexColor(0xf7f7f7)];
    [cancelBtn setTitle:@"取消" forState:UIControlStateNormal];
    [cancelBtn addTarget:self action:@selector(cancelClick) forControlEvents:UIControlEventTouchUpInside];
    [self.bottomView addSubview:cancelBtn];
}

- (void)itemViewClick:(UIGestureRecognizer *)tap {
    NSLog(@"itemViewClick");
    if (self.itemBlcok) {
        self.itemBlcok(tap.view.tag);
    }

    [self hideShareView];
}

- (void)cancelClick {
    NSLog(@"cancelClick");
    [self hideShareView];
}

- (void)hideShareView {
    [UIView animateWithDuration:0.3 animations:^{
        self.backgroundColor = [UIColor colorWithRed:0 green:0 blue:0 alpha:0];
        self.bottomView.frame = CGRectMake(0, Screen_Height + bottomViewHeight, Screen_Width, bottomViewHeight);
    } completion:^(BOOL finished) {
        [self removeFromSuperview];
    }];
}

- (void)showShareView:(ItemBlock)itemBlock {
    UIWindow *window = [UIApplication sharedApplication].keyWindow;
    [window addSubview:self];
    self.itemBlcok = itemBlock;
    [UIView animateWithDuration:0.3 animations:^{
        self.backgroundColor = [UIColor colorWithRed:0 green:0 blue:0 alpha:0.3];
        self.bottomView.frame = CGRectMake(0, Screen_Height - bottomViewHeight, Screen_Width, bottomViewHeight);
    }];
}

@end
