//
//  CommonUtil.m
//  HWMSDKDemo
//
//  Created by lining on 2022/9/15.
//  Copyright © 2022 HuaWei. All rights reserved.
//

#import "CommonUtil.h"

@implementation CommonUtil

+ (NSString *)getTitleAllowInComming:(HWMCallInRestrictionType)callInRestrictionType {
    switch (callInRestrictionType) {
        case HWMCallRestrictionAll:
            return @"所有人";
            break;
        case HWMCallRestrictionCompany:
            return @"仅企业内人员";
            break;
        case HWMCallRestrictionInvited:
            return @"仅会议邀请人员";
            break;
        default:
            return @"";
            break;
    }
}

+ (NSString *)convertDictionaryToJson:(NSDictionary *)dict {
    NSData *data = [NSJSONSerialization dataWithJSONObject:dict options:0 error:NULL];
    if (!data) {
        return @"";
    }
    
    return [[NSString alloc] initWithData:data encoding:NSUTF8StringEncoding];
}

+ (NSString *)getTitleAutoMute:(HWMAutoMuteType)autoMuteType {
    switch (autoMuteType) {
        case HWMSDKAutoMuteTypeDefault:
            return @"默认";
        case HWMSDKAutoMuteTypeMute:
            return @"开启";
        case HWMSDKAutoMuteTypeUnmute:
            return @"关闭";
        default:
            return @"";
    }
}

+ (UIAlertController *)createAutoMuteAlertController:(void (^)(HWMAutoMuteType))handler {
    UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"入会自动静音" message:nil preferredStyle:UIAlertControllerStyleActionSheet];
    UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleCancel handler:nil];
    cancelAction.accessibilityIdentifier = HWMCreatConfAutoMuteCancel;
    
    UIAlertAction *defaultAction = [UIAlertAction actionWithTitle:@"默认" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        if (handler) {
            handler(HWMSDKAutoMuteTypeDefault);
        }
    }];
    defaultAction.accessibilityIdentifier = HWMCreatConfAutoMuteModeDefault;
    UIAlertAction *muteAction = [UIAlertAction actionWithTitle:@"开启" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        if (handler) {
            handler(HWMSDKAutoMuteTypeMute);
        }
    }];
    muteAction.accessibilityIdentifier = HWMCreatConfAutoMuteModeMute;
    UIAlertAction *unmuteAction = [UIAlertAction actionWithTitle:@"关闭" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        if (handler) {
            handler(HWMSDKAutoMuteTypeUnmute);
        }
    }];
    unmuteAction.accessibilityIdentifier = HWMCreatConfAutoMuteModeUnmute;
    [alertController addAction:cancelAction];
    [alertController addAction:defaultAction];
    [alertController addAction:muteAction];
    [alertController addAction:unmuteAction];
    return alertController;
}

@end
