//
//  DateUtil.m
//  HWMSDKDemo
//
//  Created by guoyongliang/gwx917154 on 2020/8/21.
//  Copyright © 2020 HuaWei. All rights reserved.
//

#import "DateUtil.h"

@implementation DateUtil
+ (NSString *)formatTimeStringWithTimeInterval:(NSTimeInterval)timeStamp isHasTimeZoneInterval:(BOOL)isHasTimeZoneInterval {
    NSDate *date = [NSDate dateWithTimeIntervalSince1970:timeStamp];
    NSDateFormatter *formatter = [[NSDateFormatter alloc]init];
    [formatter setDateFormat:@"yyyy-MM-dd HH:mm"];
    NSDate *localeDate = [date dateByAddingTimeInterval:isHasTimeZoneInterval ? [self getSystemTimeZoneInterval] : 0];
    NSString *dateStr = [formatter stringFromDate:localeDate];
    return dateStr;
}

+ (NSDate *)formatDateWithTimeInterval:(NSTimeInterval)timeStamp isHasTimeZoneInterval:(BOOL)isHasTimeZoneInterval {
    NSDate *date = [NSDate dateWithTimeIntervalSince1970:timeStamp];
    NSDate *localeDate = [date dateByAddingTimeInterval:isHasTimeZoneInterval ? [self getSystemTimeZoneInterval] : 0];
    return localeDate;
}

+ (NSInteger)getSystemTimeZoneInterval
{
    return [[NSTimeZone systemTimeZone] secondsFromGMT];
}

+ (NSTimeInterval)formatTimeIntervalWithTime:(NSString *)time {
    NSDateFormatter *formatter = [[NSDateFormatter alloc] init];
    [formatter setDateFormat:@"yyyy-MM-dd HH:mm"];
    NSDate *date = [formatter dateFromString:time];
    return [date timeIntervalSince1970];
}
@end
