//
//  UIButton+HWM.m
//  HWMSDKDemo
//
//  Created by adminstrator on 2020/4/1.
//  Copyright © 2020 HuaWei. All rights reserved.
//

#import "UIButton+HWM.h"

@implementation UIButton (HWM)

+(UIButton *)newButtonWithTitle:(NSString *)title {
    return [self newButtonWithTitle:title fontSize:17];
}

+(UIButton *)newButtonWithTitle:(NSString *)title fontSize:(NSInteger) fontSize {
    UIButton * btn = [UIButton buttonWithType:UIButtonTypeCustom];
    [btn setTitle:title forState:UIControlStateNormal];
    [btn setDefaultButton];
    return btn;
}

- (void)setDefaultButton; {
    [self setBackgroundColor:HexColor(0xf3f3f3)];
    [self setTitleColor:HexColor(0x333333) forState:UIControlStateNormal];
    [self setTitleColor:HexColor(0x333333) forState:UIControlStateHighlighted];
    self.layer.masksToBounds = YES;
    self.layer.cornerRadius = 5;
    self.titleLabel.font = [UIFont systemFontOfSize:17];
}
@end
