//
//  AlertView.m
//  HWMSDKDemo
//
//  Created by guoyongliang/gwx917154 on 2022/1/20.
//  Copyright © 2022 HuaWei. All rights reserved.
//

#import "AlertView.h"
@interface AlertView()
@property (nonatomic, copy) NSString *message;
@end

@implementation AlertView
+ (instancetype)alertViewWithMessage:(NSString *)message {
    AlertView * alertView = [[AlertView alloc] init];
    alertView.message = message;
    [alertView showAlertView];
    return alertView;
}

- (void)showAlertView {
    UIWindow *window = [UIApplication sharedApplication].keyWindow;
    [window addSubview:self];
    [self mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.equalTo(window);
    }];
    [self setupViews];
}

- (void)setupViews {
    self.backgroundColor = [UIColor colorWithWhite:0 alpha:0.2];

    UIStackView * stackView = [[UIStackView alloc] init];
    stackView.spacing = 10;
    stackView.axis = UILayoutConstraintAxisVertical;
    stackView.distribution = UIStackViewDistributionEqualSpacing;
    [self addSubview:stackView];
    [stackView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.mas_equalTo(0);
        make.left.mas_equalTo(30);
        make.right.mas_equalTo(-30);
    }];
    UILabel * titleLabel = [[UILabel alloc] init];
    titleLabel.text = @"提 示";
    titleLabel.accessibilityIdentifier = HWMAlertTitle;
    titleLabel.textAlignment = NSTextAlignmentCenter;
    titleLabel.textColor = HexColor(0x666666);
    UILabel * messageLabel = [[UILabel alloc] init];
    messageLabel.numberOfLines = 0;
    messageLabel.text = self.message;
    messageLabel.accessibilityIdentifier = HWMAlertMessage;
    messageLabel.textAlignment = NSTextAlignmentCenter;
    UIButton * btn = [UIButton buttonWithType:UIButtonTypeCustom];
    [btn setTitle:@"确  定" forState:UIControlStateNormal];
    btn.accessibilityIdentifier = HWMAlertConfirm;
    [btn setTitleColor:HexColor(0x333333) forState:UIControlStateNormal];
    [btn addTarget:self action:@selector(remove) forControlEvents:(UIControlEventTouchUpInside)];
    
    [stackView addArrangedSubview:titleLabel];
    [stackView addArrangedSubview:messageLabel];
    [stackView addArrangedSubview:btn];
    
    UIView * whiteView = [[UIView alloc] init];
    whiteView.backgroundColor = [UIColor whiteColor];
    whiteView.layer.cornerRadius = 5;
    whiteView.layer.masksToBounds = YES;
    [self insertSubview:whiteView belowSubview:stackView];
    [whiteView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.mas_equalTo(stackView);
    }];
}

- (void)remove {
    [self removeFromSuperview];
}

@end
