#import <Foundation/Foundation.h>

#import "HWMDataCoordinatedFileTransiting.h"
#import "HWMDataTransiting.h"
NS_ASSUME_NONNULL_BEGIN


@interface HWMDataTransmitter : NSObject <ScreenShareDataTransitingDelegate>

@property (nonatomic, strong) id<HWMDataTransiting> screenShareDataMessenger;
@property (nonatomic, strong, readonly) dispatch_queue_t queue;

- (instancetype)initWithOptionalDirectory:(nullable NSString *)directory NS_DESIGNATED_INITIALIZER;

- (void)passMessageObject:(nullable id <NSCoding>)messageObject
			   identifier:(nullable NSString *)identifier;

- (void)postLog:(nullable NSString *)logMessage;

- (nullable id)messageWithIdentifier:(nullable NSString *)identifier;


- (void)clearMessageContentsForIdentifier:(nullable NSString *)identifier;

- (void)clearAllMessageContents;

- (void)listenForMessageWithIdentifier:(nullable NSString *)identifier
                              listener:(nullable void (^)(__nullable id messageObject))listener;

- (void)stopListeningForMessageWithIdentifier:(nullable NSString *)identifier;

@end

NS_ASSUME_NONNULL_END
