//
//  HWMBaseConfDetailParam.h
//  HWMConf
//
//  Created by guoyongliang/gwx917154 on 2020/8/20.
//

#import <Foundation/Foundation.h>
#import "HWMConfSdkDefine.h"
#import "HWMSDKCommonDefine.h"
NS_ASSUME_NONNULL_BEGIN

@interface HWMBaseConfDetailParam : NSObject

/// 会议id
@property (nonatomic, copy) NSString *confId;
/// VMR会议ID,显示时使用
@property (nonatomic, copy) NSString *vmrConferenceId;
/// 会议主题
@property (nonatomic, copy) NSString *confSubject;
/// 主席密码
@property (nonatomic, copy) NSString *chairmanPwd;
/// 来宾密码
@property (nonatomic, copy) NSString *generalPwd;
/// 会议开始时间
@property (nonatomic, assign) NSTimeInterval startTime DEPRECATED_MSG_ATTRIBUTE("Use 'startTimeStamp' instead");
/// 会议结束时间
@property (nonatomic, assign) NSTimeInterval endTime DEPRECATED_MSG_ATTRIBUTE("Use 'endTimeStamp' instead");
/// 会议开始时间戳
@property (nonatomic, assign) NSTimeInterval startTimeStamp;
/// 会议结束时间戳
@property (nonatomic, assign) NSTimeInterval endTimeStamp;
/// 媒体类型，取值参考CONFCTRL_E_CONF_MEDIATYPE_FLAG，可进行"|"操作
@property (nonatomic, assign) ConfMediaType mediaType;
/// 预订者姓名
@property (nonatomic, copy) NSString *scheduserName;
/// 主持人加入会议uri链接
@property (nonatomic, copy) NSString *chairJoinUri;
/// 普通与会者加入会议uri链接
@property (nonatomic, copy) NSString *guestJoinUri;
/// 会议角色
@property (nonatomic, assign) ConfRoleType role;
/// 会议方数
@property (nonatomic, assign) NSUInteger size;
/// 是否是网络研讨会
@property (nonatomic, assign) BOOL isWebinar;
/// 会议状态
@property (nonatomic, assign) ConfStatusType confStatusType;
/// 会议类型，普通或者周期会议
@property (nonatomic, assign) HWMConferenceType conferenceType;
/// 是不是立即会议
@property (nonatomic, assign) BOOL isP2PConf;
/// 是否是会议预订者
@property (nonatomic, assign) BOOL isCreator;
/// 个人客户端入会是否自动静音
@property (nonatomic, assign) HWMAutoMuteType autoMuteMode;
/// 会议室设备入会是否自动静音
@property (nonatomic, assign) HWMAutoMuteType hardTerminalAutoMuteMode;
/// 是否支持多人共享
@property (nonatomic, assign) BOOL supportMultiShare;
/// 多人共享类型
@property (nonatomic, assign) HWMMultiShareType multiShareType;
/// 是否提供水印
@property (nonatomic, assign) BOOL supportWatermark;
/// 录制时，智能会议纪要的默认状态，仅支持会议纪要时生效
@property (nonatomic, assign) HWMSummaryState defaultSummaryState;
/// 是否免审核自动发布纪要
@property (nonatomic, assign) BOOL autoPublishSummary;

@end

NS_ASSUME_NONNULL_END
