//
//  HWMBaseJoinConfParam.h
//  HWMConf
//
//  Created by guoyongliang/gwx917154 on 2020/9/16.
//  Copyright © 2020 huawei. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface HWMBaseJoinConfParam : NSObject

/// 会议id, 必填字段
@property(nonatomic, copy) NSString *confId;

/// 会议中的昵称。如果不传入，会使用设备名字
@property(nonatomic, copy) NSString *nickname;

/// 是否打开摄像头.默认关闭
@property(nonatomic, assign) BOOL isCameraOn;

/// 是否打开麦克风。默认打开
@property(nonatomic, assign) BOOL isMicOn;

/// 是否关闭扬声器，默认不关闭
@property (nonatomic, assign) BOOL isSpeakerOff;

/// 中文别名
@property (nullable, nonatomic, copy) NSString *aliasCN;

/// 英文别名
@property (nullable, nonatomic, copy) NSString *aliasEN;

/// 三方自定义字段
@property (nonatomic, copy) NSString *extendedField;

@end

NS_ASSUME_NONNULL_END
